/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.ui.FilteringTableSpeedSearch;
import com.intellij.profiler.ui.JBRunnerClosableTabs;
import com.intellij.profiler.ui.callusage.CallUsageTableCellRenderer;
import com.intellij.profiler.ui.callusage.Percentage;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiArray;
import com.intellij.profiler.ultimate.hprof.api.MuiElement;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiRecord;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiStub;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.api.MuiTypes;
import com.intellij.profiler.ultimate.hprof.api.MuiUtils;
import com.intellij.profiler.ultimate.hprof.api.visitors.CollectMuiVisitor;
import com.intellij.profiler.ultimate.hprof.api.visitors.MuiVisitor;
import com.intellij.profiler.ultimate.hprof.api.visitors.MuiVisitorWithComparator;
import com.intellij.profiler.ultimate.hprof.comparators.MuiComparators;
import com.intellij.profiler.ultimate.hprof.ui.ClassHistogramPanel;
import com.intellij.profiler.ultimate.hprof.ui.LazyPanel;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewComponentTab;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewTopLevelComponent;
import com.intellij.profiler.ultimate.hprof.ui.MergedPathPanel;
import com.intellij.profiler.ultimate.hprof.ui.ObjectViewPanel;
import com.intellij.profiler.ultimate.hprof.ui.OnePercentProgressIndicator;
import com.intellij.profiler.ultimate.hprof.ui.RenderUtilsKt;
import com.intellij.profiler.ultimate.hprof.ui.SummarySnapshotPanel;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004*\u0004\u000f\u001a\u001d \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u00052\u00020\u0006B)\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ3\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140)2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002\u00a2\u0006\u0002\u00101J\u0018\u00102\u001a\u00020.2\u000e\u00103\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000304H\u0002J\b\u00105\u001a\u000206H\u0016J\u001d\u00107\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u0001082\u0006\u0010*\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u000206H\u0016J\b\u0010;\u001a\u00020\u0018H\u0016J\u0015\u0010<\u001a\u00020=2\u0006\u0010*\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010>J%\u0010?\u001a\u00020@2\u000e\u00103\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003042\u0006\u0010*\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010AJ\u0013\u0010B\u001a\u00020@2\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010CR\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R$\u0010\u0011\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\b\u0001\u0012\u00020\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel;", "T", "Lcom/intellij/profiler/ultimate/hprof/api/MuiType;", "I", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewComponentTab;", "snapshot", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "project", "Lcom/intellij/openapi/project/Project;", "topLevelComponent", "Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewTopLevelComponent;", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewTopLevelComponent;)V", "classColumn", "com/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$classColumn$1", "Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$classColumn$1;", "columns", "", "Lcom/intellij/util/ui/ColumnInfo;", "", "[Lcom/intellij/util/ui/ColumnInfo;", "hprofClassToStringConvertor", "Lcom/intellij/util/containers/Convertor;", "", "instanceColumn", "com/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$instanceColumn$1", "Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$instanceColumn$1;", "retainedSizeColumn", "com/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$retainedSizeColumn$1", "Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$retainedSizeColumn$1;", "shallowSizeColumn", "com/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$shallowSizeColumn$1", "Lcom/intellij/profiler/ultimate/hprof/ui/ClassHistogramPanel$shallowSizeColumn$1;", "getSnapshot", "()Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "table", "Lcom/intellij/ui/table/TableView;", "getTable", "()Lcom/intellij/ui/table/TableView;", "collectObjects", "", "type", "limit", "", "values", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "localIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiType;ILit/unimi/dsi/fastutil/longs/LongOpenHashSet;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/util/List;", "collectViewObjectIds", "panel", "Lcom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel;", "createCenterComponent", "Ljavax/swing/JComponent;", "createComparator", "Ljava/util/Comparator;", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiType;)Ljava/util/Comparator;", "createRightComponent", "getTabName", "isSimpleInsertion", "", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiType;)Z", "loadMore", "", "(Lcom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel;Lcom/intellij/profiler/ultimate/hprof/api/MuiType;)V", "openObjectView", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiType;)V", "intellij.profiler.ultimate"})
public final class ClassHistogramPanel<T extends MuiType, I extends MuiInstance>
extends BorderLayoutPanel
implements MemoryViewComponentTab {
    private final Convertor<MuiType, String> hprofClassToStringConvertor;
    private final classColumn.1 classColumn;
    private final instanceColumn.1 instanceColumn;
    private final shallowSizeColumn.1 shallowSizeColumn;
    private final retainedSizeColumn.1 retainedSizeColumn;
    private final ColumnInfo<MuiType, ? extends Object>[] columns;
    @NotNull
    private final TableView<MuiType> table;
    @NotNull
    private final MuiSnapshot<T, I> snapshot;
    private final Project project;
    private final MemoryViewTopLevelComponent topLevelComponent;

    @NotNull
    public final TableView<MuiType> getTable() {
        return this.table;
    }

    public final void openObjectView(@NotNull T type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String string = type.getShortName();
        if (string == null) {
            string = UltimateProfilerBundleKt.profilerMessage("hprof.stub.unknown.class", new Object[0]);
        }
        ObjectViewPanel panel2 = new ObjectViewPanel(this.project, this.topLevelComponent, string, CollectionsKt.emptyList(), this.snapshot, null, 32, null);
        this.topLevelComponent.addTab(panel2, true);
        this.loadMore(panel2, type);
    }

    private final void loadMore(ObjectViewPanel<?, ?> panel2, T type) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        boolean bl = application.isDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = panel2.getEmptyText().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"panel.emptyText.text");
        String emptyText = string;
        panel2.getEmptyText().setText(UltimateProfilerBundleKt.profilerMessage("hprof.object.view.loading", new Object[0]));
        new Task.Backgroundable(this, panel2, (MuiType)type, emptyText, this.project, UltimateProfilerBundleKt.profilerMessage("hprof.status.objects", new Object[0])){
            final /* synthetic */ ClassHistogramPanel this$0;
            final /* synthetic */ ObjectViewPanel $panel;
            final /* synthetic */ MuiType $type;
            final /* synthetic */ String $emptyText;

            public void run(@NotNull ProgressIndicator indicator) {
                int n;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                OnePercentProgressIndicator localIndicator = new OnePercentProgressIndicator(indicator);
                localIndicator.setIndeterminate(false);
                localIndicator.setText(UltimateProfilerBundleKt.profilerMessage("hprof.status.objects", new Object[0]));
                LongOpenHashSet values = ClassHistogramPanel.access$collectViewObjectIds(this.this$0, this.$panel);
                long l = this.$type.getId();
                if (l == this.this$0.getSnapshot().getIdOfType(MuiTypes.CLASS)) {
                    T t = this.this$0.getSnapshot().getTypeById(this.$type.getId());
                    Intrinsics.checkNotNull(t);
                    n = t.getInstanceCount();
                } else {
                    n = 100000;
                }
                int limit = n;
                List result = ClassHistogramPanel.access$collectObjects(this.this$0, this.$type, limit, values, (ProgressIndicator)localIndicator);
                ApplicationManager.getApplication().invokeLater(new Runnable(this, result){
                    final /* synthetic */ loadMore.1 this$0;
                    final /* synthetic */ List $result;

                    public final void run() {
                        this.this$0.$panel.getEmptyText().setText(this.this$0.$emptyText);
                        this.this$0.$panel.removeTrailingLink();
                        this.this$0.$panel.addResults(this.$result);
                        if (this.this$0.$panel.count() < this.this$0.$type.getInstanceCount()) {
                            ObjectViewPanel objectViewPanel = this.this$0.$panel;
                            String string = UltimateProfilerBundleKt.profilerMessage("hprof.stub.first.results", new Object[0]);
                            Object[] objectArray = new Object[]{this.this$0.$panel.count()};
                            boolean bl = false;
                            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
                            objectViewPanel.addTrailingLink(string2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                                final /* synthetic */ loadMore.run.1 this$0;

                                public final void invoke() {
                                    ClassHistogramPanel.access$loadMore(this.this$0.this$0.this$0, this.this$0.this$0.$panel, this.this$0.this$0.$type);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            }));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$result = list;
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$panel = $captured_local_variable$1;
                this.$type = $captured_local_variable$2;
                this.$emptyText = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5);
            }
        }.queue();
    }

    private final List<Object> collectObjects(T type, int limit, LongOpenHashSet values, ProgressIndicator localIndicator) {
        MuiVisitorWithComparator muiVisitorWithComparator = new MuiVisitorWithComparator<I>(this, (MuiType)type, limit, localIndicator, values, type.getInstanceCount(), limit, this.createComparator(type)){
            private int counter;
            final /* synthetic */ ClassHistogramPanel this$0;
            final /* synthetic */ MuiType $type;
            final /* synthetic */ int $limit;
            final /* synthetic */ ProgressIndicator $localIndicator;
            final /* synthetic */ LongOpenHashSet $values;

            public final int getCounter() {
                return this.counter;
            }

            public final void setCounter(int n) {
                this.counter = n;
            }

            public boolean accept(@NotNull I value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                int n = this.counter;
                this.counter = n + 1;
                double fraction = (double)(100 * n / this.$type.getInstanceCount()) / 100.0;
                if (this.$limit > 0 && this.getComparator() == null) {
                    fraction *= (double)this.$type.getInstanceCount() / (double)this.$limit;
                }
                this.$localIndicator.setFraction(fraction);
                return super.accept((MuiElement)value);
            }

            public boolean isIgnored(@NotNull I value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return this.$values.contains(value.getId());
            }
            {
                this.this$0 = this$0;
                this.$type = $captured_local_variable$1;
                this.$limit = $captured_local_variable$2;
                this.$localIndicator = $captured_local_variable$3;
                this.$values = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
        boolean bl = false;
        boolean bl2 = false;
        MuiVisitorWithComparator $this$apply = muiVisitorWithComparator;
        boolean bl3 = false;
        this.snapshot.forEachInstance(type, (MuiVisitor)$this$apply);
        return muiVisitorWithComparator.getResult();
    }

    private final LongOpenHashSet collectViewObjectIds(ObjectViewPanel<?, ?> panel2) {
        LongOpenHashSet longOpenHashSet = new LongOpenHashSet(panel2.count());
        boolean bl = false;
        boolean bl2 = false;
        LongOpenHashSet set = longOpenHashSet;
        boolean bl3 = false;
        Iterator<Object> $this$forEach$iv = panel2.elements();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv;
        boolean bl4 = false;
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator3.next();
            boolean bl5 = false;
            if (!(it instanceof MuiInstance)) continue;
            set.add(((MuiInstance)it).getId());
        }
        return longOpenHashSet;
    }

    private final Comparator<I> createComparator(T type) {
        Comparator comparator;
        if (!this.isSimpleInsertion(type)) {
            boolean bl = false;
            Comparator comparator2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    MuiInstance it = (MuiInstance)a;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(it.getRetainedSize());
                    it = (MuiInstance)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = Long.valueOf(it.getRetainedSize());
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
            };
            boolean bl2 = false;
            comparator2 = new Comparator<T>(comparator2){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = comparator;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        boolean bl = false;
                        MuiInstance it = (MuiInstance)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getInstanceSize());
                        it = (MuiInstance)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Comparable comparable3 = Long.valueOf(it.getInstanceSize());
                        n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                    }
                    return n;
                }
            };
            bl2 = false;
            comparator = ((Comparator)new Comparator<T>(comparator2){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = comparator;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        boolean bl = false;
                        MuiInstance it = (MuiInstance)a;
                        boolean bl2 = false;
                        MuiInstance muiInstance = it;
                        Comparable comparable = muiInstance instanceof MuiRecord ? (Comparable)Integer.valueOf(((MuiRecord)it).getFieldCount()) : (muiInstance instanceof MuiArray ? (Comparable)Integer.valueOf(((MuiArray)it).getValueCount()) : (Comparable)Integer.valueOf(0));
                        it = (MuiInstance)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        muiInstance = it;
                        Comparable comparable3 = muiInstance instanceof MuiRecord ? (Comparable)Integer.valueOf(((MuiRecord)it).getFieldCount()) : (muiInstance instanceof MuiArray ? (Comparable)Integer.valueOf(((MuiArray)it).getValueCount()) : (Comparable)Integer.valueOf(0));
                        n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                    }
                    return n;
                }
            }).reversed();
        } else {
            comparator = null;
        }
        return comparator;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSimpleInsertion(T type) {
        void result;
        if (type.getId() == this.snapshot.getIdOfType(MuiTypes.CLASS)) return false;
        if (type.isArray()) return false;
        MuiSnapshot<T, I> muiSnapshot = this.snapshot;
        boolean bl = false;
        boolean bl2 = false;
        MuiSnapshot<T, I> it = muiSnapshot;
        boolean bl3 = false;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        it.forEachType(new MuiVisitor<T>((Ref.BooleanRef)result){
            final /* synthetic */ Ref.BooleanRef $result;

            public boolean accept(@NotNull T value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                this.$result.element = this.$result.element && value.getRetainedSize() == 0L;
                return this.$result.element;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        });
        if (!result.element) return false;
        return true;
    }

    @Override
    @NotNull
    public String getTabName() {
        return UltimateProfilerBundleKt.profilerMessage("hprof.tab.classes", new Object[0]);
    }

    @Override
    @NotNull
    public JComponent createRightComponent() {
        JBRunnerClosableTabs tabs = new JBRunnerClosableTabs(this.project, (Disposable)this.topLevelComponent);
        ClassHistogramPanel classHistogramPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        ClassHistogramPanel it = classHistogramPanel;
        boolean bl3 = false;
        tabs.addTab(new TabInfo((JComponent)((Object)new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.dominators.view", new Object[0]), true, null, new Function1<ProgressIndicator, ObjectViewPanel<T, I>>(this, tabs){
            final /* synthetic */ ClassHistogramPanel this$0;
            final /* synthetic */ JBRunnerClosableTabs $tabs$inlined;
            {
                this.this$0 = classHistogramPanel;
                this.$tabs$inlined = jBRunnerClosableTabs;
                super(1);
            }

            @NotNull
            public final ObjectViewPanel<T, I> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.this$0.getSnapshot().doCalculateRetainedSize(indicator);
                indicator.setIndeterminate(false);
                indicator.setText(UltimateProfilerBundleKt.profilerMessage("hprof.status.dominators", new Object[0]));
                indicator.setFraction(0.0);
                int limit = 1000;
                MuiVisitorWithComparator<T> visitor2 = new MuiVisitorWithComparator<T>(limit, limit, Comparator.comparingLong(createRightComponent.1.visitor.1.INSTANCE).reversed());
                this.this$0.getSnapshot().getDominators(indicator, (MuiVisitor)visitor2);
                List<T> collection = visitor2.getResult();
                if (collection.size() == limit) {
                    List<T> list = collection;
                    if (list == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.profiler.ultimate.hprof.api.MuiElement>");
                    }
                    List list2 = TypeIntrinsics.asMutableList(list);
                    String string = UltimateProfilerBundleKt.profilerMessage("hprof.stub.first.results", new Object[0]);
                    Object[] objectArray = new Object[]{limit};
                    boolean bl = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
                    list2.add(new MuiStub(string2));
                }
                return new ObjectViewPanel<T, I>(ClassHistogramPanel.access$getProject$p(this.this$0), ClassHistogramPanel.access$getTopLevelComponent$p(this.this$0), "", collection, this.this$0.getSnapshot(), null, 32, null);
            }
        }, 8, null))).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.biggest.objects", new Object[0])));
        classHistogramPanel = this;
        bl = false;
        bl2 = false;
        it = classHistogramPanel;
        boolean bl4 = false;
        tabs.addTab(new TabInfo((JComponent)((Object)new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.roots.view", new Object[0]), false, null, new Function1<ProgressIndicator, ObjectViewPanel<T, I>>(this, tabs){
            final /* synthetic */ ClassHistogramPanel this$0;
            final /* synthetic */ JBRunnerClosableTabs $tabs$inlined;
            {
                this.this$0 = classHistogramPanel;
                this.$tabs$inlined = jBRunnerClosableTabs;
                super(1);
            }

            @NotNull
            public final ObjectViewPanel<T, I> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                boolean bl = false;
                List roots = new ArrayList<E>();
                this.this$0.getSnapshot().getRootInstances((MuiVisitor)new CollectMuiVisitor<T>(roots));
                Map objects = new HashMap<K, V>();
                Iterable iterable = roots;
                Comparator<MuiElement> comparator = MuiComparators.comparingElements().reversed();
                Intrinsics.checkNotNullExpressionValue(comparator, (String)"MuiComparators.comparingElements().reversed()");
                CollectionsKt.sortedWith((Iterable)iterable, comparator);
                for (MuiInstance root : roots) {
                    MuiType t;
                    if (root.getId() < 0L) continue;
                    if (root.getType() == null) {
                        throw new NullPointerException("null cannot be cast to non-null type T");
                    }
                    ((List)objects.computeIfAbsent(t, createRightComponent.2.1.INSTANCE)).add(root);
                }
                List list = ContainerUtil.filter((Collection)objects.keySet(), (Condition)createRightComponent.2.classes.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.filter(obj\u2026Type? -> aClass != null }");
                List classes2 = list;
                boolean bl2 = false;
                Comparator comparator2 = new Comparator<T>(objects){
                    final /* synthetic */ Map $objects$inlined;
                    {
                        this.$objects$inlined = map;
                    }

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        MuiType it = (MuiType)a;
                        boolean bl2 = false;
                        Map map = this.$objects$inlined;
                        boolean bl3 = false;
                        V v = map.get(it);
                        Intrinsics.checkNotNull(v);
                        it = (MuiType)b;
                        Comparable comparable = Long.valueOf(((List)v).stream().mapToLong(createRightComponent.2.2.1.INSTANCE).sum());
                        bl2 = false;
                        map = this.$objects$inlined;
                        bl3 = false;
                        V v2 = map.get(it);
                        Intrinsics.checkNotNull(v2);
                        Comparable comparable2 = Long.valueOf(((List)v2).stream().mapToLong(createRightComponent.2.2.1.INSTANCE).sum());
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)comparable2);
                    }
                };
                boolean bl3 = false;
                Comparator<T> comparator3 = ((Comparator)new Comparator<T>(comparator2){
                    final /* synthetic */ Comparator $this_thenBy;
                    {
                        this.$this_thenBy = comparator;
                    }

                    public final int compare(T a, T b) {
                        int n;
                        int previousCompare = this.$this_thenBy.compare(a, b);
                        if (previousCompare != 0) {
                            n = previousCompare;
                        } else {
                            boolean bl = false;
                            MuiType it = (MuiType)a;
                            boolean bl2 = false;
                            Comparable comparable = Long.valueOf(it.getInstanceSize());
                            it = (MuiType)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Comparable comparable3 = Long.valueOf(it.getInstanceSize());
                            n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                        }
                        return n;
                    }
                }).reversed();
                Intrinsics.checkNotNullExpressionValue(comparator3, (String)"compareBy<MuiType> { obj\u2026instanceSize }.reversed()");
                CollectionsKt.sortWith((List)classes2, comparator3);
                return new ObjectViewPanel<T, I>(ClassHistogramPanel.access$getProject$p(this.this$0), ClassHistogramPanel.access$getTopLevelComponent$p(this.this$0), "", classes2, this.this$0.getSnapshot(), (Function1<? super MuiType, ? extends List<? extends MuiInstance>>)((Function1)new Function1<MuiType, List<? extends MuiInstance>>(objects){
                    final /* synthetic */ Map $objects;
                    {
                        this.$objects = map;
                        super(1);
                    }

                    @NotNull
                    public final List<MuiInstance> invoke(@NotNull MuiType it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Map map = this.$objects;
                        boolean bl = false;
                        V v = map.get(it);
                        Intrinsics.checkNotNull(v);
                        return (List)v;
                    }
                }));
            }
        }, 8, null))).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.roots", new Object[0])));
        classHistogramPanel = this;
        bl = false;
        bl2 = false;
        it = classHistogramPanel;
        boolean bl5 = false;
        LazyPanel lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.merged.paths", new Object[0]), true, new LazyPanel.AbandonedComponentListener<MergedPathPanel>(){

            public void abandoned(@NotNull MergedPathPanel component) {
                Intrinsics.checkNotNullParameter((Object)((Object)component), (String)"component");
                Disposer.dispose((Disposable)component);
            }
        }, (Function1)new Function1<ProgressIndicator, MergedPathPanel>(this, tabs){
            final /* synthetic */ ClassHistogramPanel this$0;
            final /* synthetic */ JBRunnerClosableTabs $tabs$inlined;
            {
                this.this$0 = classHistogramPanel;
                this.$tabs$inlined = jBRunnerClosableTabs;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MergedPathPanel invoke(@NotNull ProgressIndicator it) {
                void var3_3;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = this.this$0.getTable().getSelectedObject();
                Intrinsics.checkNotNull((Object)object);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"table.selectedObject!!");
                MuiType type = (MuiType)object;
                MergedPathPanel mergedPathPanel = new MergedPathPanel(this.this$0.getSnapshot(), type);
                Disposer.register((Disposable)ClassHistogramPanel.access$getTopLevelComponent$p(this.this$0), (Disposable)mergedPathPanel);
                return var3_3;
            }
        });
        lazyPanel2.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(lazyPanel2, this, tabs){
            final /* synthetic */ LazyPanel $lazyPanel;
            final /* synthetic */ ClassHistogramPanel this$0;
            final /* synthetic */ JBRunnerClosableTabs $tabs$inlined;
            {
                this.$lazyPanel = lazyPanel2;
                this.this$0 = classHistogramPanel;
                this.$tabs$inlined = jBRunnerClosableTabs;
            }

            public final void valueChanged(ListSelectionEvent it) {
                ListSelectionEvent listSelectionEvent = it;
                Intrinsics.checkNotNullExpressionValue((Object)listSelectionEvent, (String)"it");
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    this.$lazyPanel.setEnabled(this.this$0.getTable().getSelectedObject() != null);
                    this.$lazyPanel.clear();
                }
            }
        });
        tabs.addTab(new TabInfo((JComponent)((Object)lazyPanel2)).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.merged.paths", new Object[0])));
        tabs.addTab(new TabInfo((JComponent)((Object)new SummarySnapshotPanel<T, I>(this.snapshot, this.project, this.topLevelComponent))).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary", new Object[0])));
        return (JComponent)tabs;
    }

    @Override
    @NotNull
    public JComponent createCenterComponent() {
        return (JComponent)((Object)this);
    }

    @NotNull
    public final MuiSnapshot<T, I> getSnapshot() {
        return this.snapshot;
    }

    public ClassHistogramPanel(@NotNull MuiSnapshot<T, I> snapshot, @NotNull Project project, @NotNull MemoryViewTopLevelComponent topLevelComponent) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)topLevelComponent), (String)"topLevelComponent");
        this.snapshot = snapshot;
        this.project = project;
        this.topLevelComponent = topLevelComponent;
        this.hprofClassToStringConvertor = hprofClassToStringConvertor.1.INSTANCE;
        this.classColumn = new ColumnInfo<MuiType, MuiType>(this, UltimateProfilerBundleKt.profilerMessage("hprof.classes.column.class", new Object[0])){
            final /* synthetic */ ClassHistogramPanel this$0;

            @NotNull
            public MuiType valueOf(@NotNull MuiType item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item;
            }

            @NotNull
            public Class<?> getColumnClass() {
                return MuiType.class;
            }

            @NotNull
            public Comparator<MuiType> getComparator() {
                Convertor convertor = ClassHistogramPanel.access$getHprofClassToStringConvertor$p(this.this$0);
                boolean bl = false;
                return new Comparator<T>(convertor){
                    final /* synthetic */ Convertor receiver$0$inlined;
                    {
                        this.receiver$0$inlined = convertor;
                    }

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        MuiType p1 = (MuiType)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)((String)this.receiver$0$inlined.convert((Object)p1)));
                        p1 = (MuiType)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = (String)this.receiver$0$inlined.convert((Object)p1);
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                };
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        this.instanceColumn = new ColumnInfo<MuiType, Percentage>(this, UltimateProfilerBundleKt.profilerMessage("hprof.classes.column.count", new Object[0])){
            final /* synthetic */ ClassHistogramPanel this$0;

            @NotNull
            public Percentage valueOf(@NotNull MuiType item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Double d = (double)item.getInstanceCount() / (double)this.this$0.getSnapshot().getTotalInstances();
                boolean bl = false;
                boolean bl2 = false;
                double it = ((Number)d).doubleValue();
                boolean bl3 = false;
                double d2 = it;
                boolean bl4 = false;
                Double d3 = !Double.isNaN(d2) ? d : null;
                double value = d3 != null ? d3 : 0.0;
                return new Percentage(value, (Number)item.getInstanceCount());
            }

            @NotNull
            public Class<?> getColumnClass() {
                return Percentage.class;
            }

            @NotNull
            public Comparator<MuiType> getComparator() {
                boolean bl = false;
                return new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        MuiType it = (MuiType)a;
                        boolean bl2 = false;
                        Comparable comparable = Integer.valueOf(it.getInstanceCount());
                        it = (MuiType)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Comparable comparable3 = Integer.valueOf(it.getInstanceCount());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                    }
                };
            }

            @NotNull
            public String getMaxStringValue() {
                return "999,999,999,999";
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        this.shallowSizeColumn = new ColumnInfo<MuiType, Percentage>(this, UltimateProfilerBundleKt.profilerMessage("hprof.classes.column.size", new Object[0])){
            final /* synthetic */ ClassHistogramPanel this$0;

            @NotNull
            public Percentage valueOf(@NotNull MuiType item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Double d = (double)item.getTotalSize() / (double)this.this$0.getSnapshot().getTotalBytes();
                boolean bl = false;
                boolean bl2 = false;
                double it = ((Number)d).doubleValue();
                boolean bl3 = false;
                double d2 = it;
                boolean bl4 = false;
                Double d3 = !Double.isNaN(d2) ? d : null;
                double value = d3 != null ? d3 : 0.0;
                return new Percentage(value, (Number)item.getTotalSize());
            }

            @NotNull
            public Class<?> getColumnClass() {
                return Percentage.class;
            }

            @NotNull
            public Comparator<MuiType> getComparator() {
                boolean bl = false;
                return new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        MuiType it = (MuiType)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getTotalSize());
                        it = (MuiType)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Comparable comparable3 = Long.valueOf(it.getTotalSize());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                    }
                };
            }

            @NotNull
            public String getMaxStringValue() {
                return "999,999,999,999";
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        this.retainedSizeColumn = new ColumnInfo<MuiType, Percentage>(this, UltimateProfilerBundleKt.profilerMessage("hprof.classes.column.retained", new Object[0])){
            final /* synthetic */ ClassHistogramPanel this$0;

            @NotNull
            public Percentage valueOf(@NotNull MuiType item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Double d = (double)item.getRetainedSize() / (double)this.this$0.getSnapshot().getTotalBytes();
                boolean bl = false;
                boolean bl2 = false;
                double it = ((Number)d).doubleValue();
                boolean bl3 = false;
                double d2 = it;
                boolean bl4 = false;
                Double d3 = !Double.isNaN(d2) ? d : null;
                double value = d3 != null ? d3 : 0.0;
                double d4 = 1.0;
                bl2 = false;
                return new Percentage(Math.min(value, d4), (Number)item.getRetainedSize());
            }

            @NotNull
            public Class<?> getColumnClass() {
                return Percentage.class;
            }

            @NotNull
            public Comparator<MuiType> getComparator() {
                boolean bl = false;
                return new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        MuiType it = (MuiType)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getRetainedSize());
                        it = (MuiType)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Comparable comparable3 = Long.valueOf(it.getRetainedSize());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                    }
                };
            }

            @NotNull
            public String getMaxStringValue() {
                return "999,999,999,999";
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        this.columns = new ColumnInfo[]{this.classColumn, this.instanceColumn, this.shallowSizeColumn, this.retainedSizeColumn};
        this.table = (TableView)new TableView<MuiType>(this, new ListTableModel(this.columns, MuiUtils.collectTypes(this.snapshot), ArraysKt.indexOf((Object[])this.columns, (Object)((Object)this.shallowSizeColumn)), SortOrder.DESCENDING)){
            final /* synthetic */ ClassHistogramPanel this$0;

            @NotNull
            protected TableRowSorter<TableModel> createRowSorter(@Nullable TableModel model) {
                return (TableRowSorter)new JBTable.DefaultColumnInfoBasedRowSorter(this, model, model){
                    @NotNull
                    private Map<SortOrder, ? extends SortOrder> nextKey;
                    final /* synthetic */ table.1 this$0;
                    final /* synthetic */ TableModel $model;

                    @NotNull
                    public final Map<SortOrder, SortOrder> getNextKey() {
                        return this.nextKey;
                    }

                    public final void setNextKey(@NotNull Map<SortOrder, ? extends SortOrder> map) {
                        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
                        this.nextKey = map;
                    }

                    public void toggleSortOrder(int column) {
                        block5: {
                            boolean bl;
                            Object object;
                            Object object2;
                            ArrayList<RowSorter.SortKey> sortKeys;
                            block7: {
                                block6: {
                                    block4: {
                                        if (column != ArraysKt.indexOf((Object[])ClassHistogramPanel.access$getColumns$p(this.this$0.this$0), (Object)((Object)ClassHistogramPanel.access$getClassColumn$p(this.this$0.this$0)))) break block4;
                                        super.toggleSortOrder(column);
                                        break block5;
                                    }
                                    if (!this.isSortable(column)) break block5;
                                    sortKeys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
                                    object2 = (RowSorter.SortKey)CollectionsKt.firstOrNull((List)sortKeys);
                                    if (object2 == null) break block6;
                                    object = object2;
                                    bl = false;
                                    boolean bl2 = false;
                                    RowSorter.SortKey it = object;
                                    boolean bl3 = false;
                                    object2 = column == it.getColumn() ? object : null;
                                    if (object2 != null && (object2 = object2.getSortOrder()) != null) break block7;
                                }
                                object2 = SortOrder.UNSORTED;
                            }
                            RowSorter.SortKey oldKey = object2;
                            sortKeys.removeIf(new Predicate<RowSorter.SortKey>(column){
                                final /* synthetic */ int $column;

                                public final boolean test(@NotNull RowSorter.SortKey key) {
                                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                                    return key.getColumn() == this.$column;
                                }
                                {
                                    this.$column = n;
                                }
                            });
                            SortOrder sortOrder = this.nextKey.get(oldKey);
                            if (sortOrder == null) {
                                object = "Unknown sort key " + oldKey;
                                bl = false;
                                throw (Throwable)new IllegalStateException(object.toString());
                            }
                            sortKeys.add(0, new RowSorter.SortKey(column, sortOrder));
                            this.setSortKeys(sortKeys);
                        }
                    }
                    {
                        this.this$0 = this$0;
                        this.$model = $captured_local_variable$1;
                        super($super_call_param$2);
                        this.nextKey = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)SortOrder.UNSORTED), (Object)((Object)SortOrder.DESCENDING)), TuplesKt.to((Object)((Object)SortOrder.DESCENDING), (Object)((Object)SortOrder.ASCENDING)), TuplesKt.to((Object)((Object)SortOrder.ASCENDING), (Object)((Object)SortOrder.DESCENDING))});
                    }
                };
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        new FilteringTableSpeedSearch(this.table, (Function1)new Function1<MuiType, String>(){

            @Nullable
            public final String invoke(@NotNull MuiType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (String)hprofClassToStringConvertor.convert((Object)it);
            }
        });
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel, (String)"table.selectionModel");
        listSelectionModel.setSelectionMode(0);
        HashSet<KeyStroke> forward = new HashSet<KeyStroke>(this.table.getFocusTraversalKeys(0));
        forward.add(KeyStroke.getKeyStroke("TAB"));
        this.table.setFocusTraversalKeys(0, (Set)forward);
        HashSet<KeyStroke> backward = new HashSet<KeyStroke>(this.table.getFocusTraversalKeys(1));
        backward.add(KeyStroke.getKeyStroke("shift TAB"));
        this.table.setFocusTraversalKeys(1, (Set)backward);
        this.table.setDefaultRenderer(MuiType.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                this.setBackground(UIUtil.getTableBackground((boolean)selected, (boolean)table2.hasFocus()));
                if (value instanceof MuiType) {
                    String string = ((MuiType)value).getName();
                    if (string == null) {
                        string = UltimateProfilerBundleKt.profilerMessage("hprof.stub.unknown.class", new Object[0]);
                    }
                    String text = string;
                    int index = StringUtil.lastIndexOf((CharSequence)text, (char)'.', (int)0, (int)text.length());
                    if (index > 0) {
                        String packageName = RenderUtilsKt.substring(text, 0, index + 1);
                        this.append(packageName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    String className = RenderUtilsKt.substring(text, index + 1, text.length());
                    this.append(className, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table2, (SimpleColoredComponent)((SimpleColoredComponent)this), (boolean)false, (boolean)selected);
                }
            }
        });
        this.table.setDefaultRenderer(Percentage.class, (TableCellRenderer)new CallUsageTableCellRenderer());
        final DefaultActionGroup popup2 = new DefaultActionGroup(new AnAction[]{(AnAction)new DumbAwareAction(this, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.new.tab", new Object[0])){
            final /* synthetic */ ClassHistogramPanel this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row = this.this$0.getTable().getSelectedRow();
                if (row >= 0) {
                    TableModel tableModel = this.this$0.getTable().getModel();
                    if (tableModel == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.ui.ListTableModel<*>");
                    }
                    Object object = ((ListTableModel)tableModel).getItem(this.this$0.getTable().convertRowIndexToModel(row));
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type T");
                    }
                    MuiType item = (MuiType)object;
                    this.this$0.openObjectView(item);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(this.this$0.getTable().getSelectedRow() >= 0);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{(Shortcut)new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null), (Shortcut)new MouseShortcut(1, 0, 2)}), (JComponent)this$0.getTable(), ClassHistogramPanel.access$getTopLevelComponent$p(this$0));
            }
        }});
        this.table.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component comp, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)popup2);
                Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"ActionManager.getInstanc\u2026ionPlaces.UNKNOWN, popup)");
                actionPopupMenu.getComponent().show(comp, x, y);
            }
        });
        this.add(ScrollPaneFactory.createScrollPane((Component)((Component)this.table)));
    }

    public static final /* synthetic */ LongOpenHashSet access$collectViewObjectIds(ClassHistogramPanel $this, ObjectViewPanel panel2) {
        return $this.collectViewObjectIds(panel2);
    }

    public static final /* synthetic */ List access$collectObjects(ClassHistogramPanel $this, MuiType type, int limit, LongOpenHashSet values, ProgressIndicator localIndicator) {
        return $this.collectObjects(type, limit, values, localIndicator);
    }

    public static final /* synthetic */ void access$loadMore(ClassHistogramPanel $this, ObjectViewPanel panel2, MuiType type) {
        $this.loadMore(panel2, type);
    }

    public static final /* synthetic */ Project access$getProject$p(ClassHistogramPanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ MemoryViewTopLevelComponent access$getTopLevelComponent$p(ClassHistogramPanel $this) {
        return $this.topLevelComponent;
    }

    public static final /* synthetic */ ColumnInfo[] access$getColumns$p(ClassHistogramPanel $this) {
        return $this.columns;
    }

    public static final /* synthetic */ classColumn.1 access$getClassColumn$p(ClassHistogramPanel $this) {
        return $this.classColumn;
    }
}

