/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.impl.utils;

import com.intellij.profiler.ultimate.hprof.utils.IntBufferStack;
import com.intellij.profiler.ultimate.hprof.utils.IntList;
import com.intellij.profiler.ultimate.hprof.utils.IntMultimap;
import java.util.BitSet;
import java.util.Iterator;
import java.util.function.LongToIntFunction;

public class LiveObjectIterator
implements AutoCloseable {
    private final BitSet myVisited;
    private final IntBufferStack myStack;
    private final IntMultimap myOutbounds;

    public LiveObjectIterator(Iterator<Long> rootSet, int totalInstances, LongToIntFunction remap, IntMultimap outbounds2) {
        this.myVisited = new BitSet(totalInstances);
        this.myStack = new IntBufferStack(totalInstances){

            @Override
            protected IntList create(int maximumSize) {
                return new IntList.OffHeap(maximumSize);
            }
        };
        this.myOutbounds = outbounds2;
        rootSet.forEachRemaining(root -> {
            int index = remap.applyAsInt((long)root);
            if (index >= 0) {
                this.myStack.push(index);
                this.myVisited.set(index);
            }
        });
    }

    public boolean hasNext() {
        return !this.myStack.empty();
    }

    public int nextInt() {
        int next = this.myStack.pop();
        this.myOutbounds.get(next, child -> {
            if (!this.myVisited.get(child)) {
                this.myStack.push(child);
                this.myVisited.set(child);
            }
        });
        return next;
    }

    @Override
    public void close() {
        this.myVisited.clear();
        this.myStack.close();
        this.myOutbounds.close();
    }
}

