/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.impl.utils;

import com.intellij.profiler.ultimate.hprof.utils.IntList;
import com.intellij.profiler.ultimate.hprof.utils.IntMultimap;
import com.intellij.profiler.ultimate.hprof.utils.IntRoundQueue;
import java.util.BitSet;
import java.util.function.IntPredicate;
import java.util.function.LongToIntFunction;

public class BfsObjectIterator
implements AutoCloseable {
    private final BitSet myVisited;
    private final IntList myPredcessor;
    private final IntRoundQueue myQueue;
    private final IntMultimap myInbounds;
    private final IntPredicate myCanProceed;

    public BfsObjectIterator(long objectId, int totalInstances, LongToIntFunction remap, IntMultimap inbounds2, IntPredicate canProcess) {
        this.myPredcessor = new IntList.OffHeap(totalInstances);
        this.myQueue = new IntRoundQueue(totalInstances){

            @Override
            protected IntList create(int maximumSize) {
                return new IntList.OffHeap(maximumSize);
            }
        };
        this.myCanProceed = canProcess;
        this.myInbounds = inbounds2;
        int objectIndex = remap.applyAsInt(objectId);
        this.myQueue.offer(objectIndex);
        this.myVisited = new BitSet(totalInstances);
        this.myVisited.set(objectIndex);
    }

    public boolean hasNext() {
        return !this.myQueue.empty();
    }

    public int nextInt() {
        int next = this.myQueue.poll();
        if (!this.myCanProceed.test(next)) {
            return next;
        }
        this.myInbounds.get(next, child -> {
            if (!this.myVisited.get(child)) {
                this.myQueue.offer(child);
                this.myPredcessor.put(child, next);
                this.myVisited.set(child);
            }
        });
        return next;
    }

    public int predcessor(int value) {
        return this.myPredcessor.get(value);
    }

    @Override
    public void close() {
        this.myQueue.close();
    }
}

