/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.api.visitors;

import com.intellij.profiler.ultimate.hprof.api.MuiElement;
import com.intellij.profiler.ultimate.hprof.api.visitors.MuiVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/intellij/profiler/ultimate/hprof/api/visitors/MuiVisitorWithComparator;", "T", "Lcom/intellij/profiler/ultimate/hprof/api/MuiElement;", "Lcom/intellij/profiler/ultimate/hprof/api/visitors/MuiVisitor;", "initCapacity", "", "limit", "comparator", "Ljava/util/Comparator;", "(IILjava/util/Comparator;)V", "_result", "", "getComparator", "()Ljava/util/Comparator;", "getLimit", "()I", "result", "", "getResult", "()Ljava/util/List;", "accept", "", "value", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiElement;)Z", "isIgnored", "postVisit", "", "intellij.profiler.ultimate"})
public class MuiVisitorWithComparator<T extends MuiElement>
implements MuiVisitor<T> {
    private final List<T> _result;
    private final int limit;
    @Nullable
    private final Comparator<T> comparator;

    @NotNull
    public final List<T> getResult() {
        return this._result;
    }

    @Override
    public boolean accept(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (this.isIgnored(value)) {
            return true;
        }
        if (this.limit > 0) {
            if (this.comparator == null) {
                this._result.add(value);
                if (this._result.size() >= this.limit) {
                    return false;
                }
            } else {
                int n = Collections.binarySearch(this._result, value, this.comparator);
                boolean bl = false;
                boolean bl2 = false;
                int i = n;
                boolean bl3 = false;
                int search = i < 0 ? -i - 1 : i;
                this._result.add(search, value);
            }
            while (this._result.size() > this.limit) {
                this._result.remove(this._result.size() - 1);
            }
        } else {
            this._result.add(value);
        }
        return true;
    }

    @Override
    public void postVisit() {
        if (this.limit <= 0 && this.comparator != null) {
            CollectionsKt.sortWith(this._result, this.comparator);
        }
    }

    public boolean isIgnored(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return false;
    }

    public final int getLimit() {
        return this.limit;
    }

    @Nullable
    public final Comparator<T> getComparator() {
        return this.comparator;
    }

    public MuiVisitorWithComparator(int initCapacity, int limit, @Nullable Comparator<T> comparator) {
        int n;
        this.limit = limit;
        this.comparator = comparator;
        if (this.limit > 0) {
            int n2 = this.limit;
            int n3 = 1000;
            boolean bl = false;
            n = Math.max(n2, n3);
        } else {
            n = initCapacity;
        }
        this._result = new ArrayList(n);
    }

    public /* synthetic */ MuiVisitorWithComparator(int n, int n2, Comparator comparator, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 100;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        if ((n3 & 4) != 0) {
            comparator = null;
        }
        this(n, n2, comparator);
    }

    public MuiVisitorWithComparator() {
        this(0, 0, null, 7, null);
    }
}

