/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.HprofProfilerData;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.ui.ProgressBarWatcherVisitor;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ultimate/hprof/HprofFileParser;", "Lcom/intellij/profiler/api/ProfilerDumpFileParser;", "()V", "helpId", "", "getHelpId", "()Ljava/lang/String;", "parse", "Lcom/intellij/profiler/api/ProfilerDumpFileParsingResult;", "file", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.profiler.ultimate"})
final class HprofFileParser
implements ProfilerDumpFileParser {
    @NotNull
    private final String helpId;

    @NotNull
    public ProfilerDumpFileParsingResult parse(@NotNull File file, @NotNull ProgressIndicator indicator) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Path path2 = path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        HprofDump hprof = new HprofDump(path2);
        indicator.setIndeterminate(false);
        indicator.setText(UltimateProfilerBundleKt.profilerMessage("hprof.status.parse", new Object[0]));
        hprof.loadGeneralInfo(indicator, new ProgressBarWatcherVisitor(path, indicator, 0, 4, null));
        return (ProfilerDumpFileParsingResult)new Success((ProfilerData)new HprofProfilerData(hprof));
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    public HprofFileParser() {
        this.helpId = "profiler.hprof";
    }
}

