/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async.configurations;

import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.configurations.ProfilerAttacher;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.linux.HasInvalidVariables;
import com.intellij.profiler.linux.KernelVariablesChangeRequiredException;
import com.intellij.profiler.linux.KernelVariablesValidatorKt;
import com.intellij.profiler.linux.ValidationResult;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationType;
import com.intellij.profiler.ultimate.async.AgentConfiguration;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionBase;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionBaseKt;
import com.intellij.profiler.ultimate.async.AsyncProfilerProcess;
import com.intellij.profiler.ultimate.async.UtilsKt;
import com.intellij.profiler.ultimate.async.configurations.AgentOptions;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurable;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurationState;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerStarter;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationTypeBase;", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationType;", "Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationState;", "()V", "createAttacher", "Lcom/intellij/profiler/api/configurations/ProfilerAttacher;", "state", "createConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "createStarter", "Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerStarter;", "isAvailable", "", "Companion", "intellij.profiler.ultimate"})
public abstract class AsyncProfilerConfigurationTypeBase
extends JavaProfilerConfigurationType<AsyncProfilerConfigurationState> {
    @NotNull
    public static final String defaultOptions = "interval=1ms,framebuf=15000000";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public UnnamedConfigurable createConfigurable(@NotNull AsyncProfilerConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return new AsyncProfilerConfigurable(state);
    }

    public boolean isAvailable() {
        return UtilsKt.asyncProfilerAvailable();
    }

    @NotNull
    public ProfilerAttacher createAttacher(@NotNull AsyncProfilerConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return new ProfilerAttacher(state){
            final /* synthetic */ AsyncProfilerConfigurationState $state;

            @NotNull
            public Promise<? extends ProfilerProcess<? extends AttachableTargetProcess>> attachTo(@NotNull AttachableTargetProcess targetProcess, @NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                String agentPath = UtilsKt.getNativeAgentPath(this.$state);
                MisConfiguredException misConfiguredException = AsyncProfilerConfigurationExtensionBaseKt.validateAgentPath(agentPath, project, (ProfilerConfigurationState)this.$state);
                if (misConfiguredException != null) {
                    MisConfiguredException misConfiguredException2 = misConfiguredException;
                    boolean bl = false;
                    boolean bl2 = false;
                    MisConfiguredException it = misConfiguredException2;
                    boolean bl3 = false;
                    return Promises.rejectedPromise((Throwable)((Throwable)it));
                }
                ValidationResult kernelVariablesValidationResult = KernelVariablesValidatorKt.checkKernelVariables(AsyncProfilerConfigurationExtensionBase.Companion.getRequiredKernelVariables());
                if (kernelVariablesValidationResult instanceof HasInvalidVariables) {
                    return Promises.rejectedPromise((Throwable)((Throwable)new KernelVariablesChangeRequiredException((HasInvalidVariables)kernelVariablesValidationResult, project)));
                }
                String string = UtilsKt.tryToHandleSpacesInAgentPath(agentPath);
                AgentOptions agentOptions = this.$state.agentOptions();
                File file = FileUtil.createTempFile((String)"asyncprofiler", (String)".jfr", (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\u2026cprofiler\", \".jfr\", true)");
                AgentConfiguration configuration = new AgentConfiguration(string, agentOptions, file);
                return AsyncProfilerProcess.Companion.attach(targetProcess, (ProfilerConfigurationState)this.$state, configuration, 120000, project);
            }
            {
                this.$state = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public AsyncProfilerStarter createStarter(@NotNull AsyncProfilerConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return AsyncProfilerStarter.INSTANCE;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationTypeBase$Companion;", "", "()V", "defaultOptions", "", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

