/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.async.FileReader;
import com.intellij.util.io.CountingInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ultimate/async/ZIPExtractor;", "Lcom/intellij/profiler/ultimate/async/FileReader;", "file", "Ljava/util/zip/ZipFile;", "(Ljava/util/zip/ZipFile;)V", "countingStream", "Lcom/intellij/util/io/CountingInputStream;", "getCountingStream", "()Lcom/intellij/util/io/CountingInputStream;", "setCountingStream", "(Lcom/intellij/util/io/CountingInputStream;)V", "zipEntry", "Ljava/util/zip/ZipEntry;", "createReader", "Ljava/io/BufferedReader;", "getEntry", "progressFraction", "", "withProgressFraction", "", "intellij.profiler.ultimate"})
final class ZIPExtractor
extends FileReader {
    private final ZipEntry zipEntry;
    @NotNull
    public CountingInputStream countingStream;
    private final ZipFile file;

    @NotNull
    public final CountingInputStream getCountingStream() {
        CountingInputStream countingInputStream = this.countingStream;
        if (countingInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"countingStream");
        }
        return countingInputStream;
    }

    public final void setCountingStream(@NotNull CountingInputStream countingInputStream) {
        Intrinsics.checkNotNullParameter((Object)countingInputStream, (String)"<set-?>");
        this.countingStream = countingInputStream;
    }

    @Override
    @NotNull
    protected BufferedReader createReader() {
        InputStream decompressedStream = this.file.getInputStream(this.zipEntry);
        CountingInputStream countingInputStream = this.countingStream = new CountingInputStream(decompressedStream);
        if (countingInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"countingStream");
        }
        InputStream inputStream = (InputStream)countingInputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable closeable = inputStream;
        int n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        boolean bl2 = false;
        return closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
    }

    /*
     * WARNING - void declaration
     */
    private final ZipEntry getEntry() {
        void $this$filterTo$iv$iv;
        Enumeration<? extends ZipEntry> enumeration = this.file.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"file.entries()");
        Object object = enumeration;
        boolean bl = false;
        ArrayList<? extends ZipEntry> arrayList = Collections.list(object);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
        Iterable $this$filter$iv = arrayList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ZipEntry it = (ZipEntry)element$iv$iv;
            boolean bl2 = false;
            ZipEntry zipEntry = it;
            Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"it");
            String string = zipEntry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            if (!(!StringsKt.startsWith$default((String)string, (String)"__MACOSX/", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entries = (List)destination$iv$iv;
        object = entries;
        bl = false;
        boolean bl3 = false;
        if (object.isEmpty()) {
            throw (Throwable)new IllegalArgumentException(UltimateProfilerBundleKt.profilerMessage("zip.is.empty", new Object[0]));
        }
        if (entries.size() > 1) {
            throw (Throwable)new IllegalArgumentException(UltimateProfilerBundleKt.profilerMessage("zip.too.many.files", new Object[0]));
        }
        Object object2 = CollectionsKt.first((List)entries);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"entries.first()");
        return (ZipEntry)object2;
    }

    @Override
    protected boolean withProgressFraction() {
        return this.zipEntry.getSize() > 1L;
    }

    @Override
    protected double progressFraction() {
        CountingInputStream countingInputStream = this.countingStream;
        if (countingInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"countingStream");
        }
        return (double)countingInputStream.getBytesRead() / (double)this.zipEntry.getSize();
    }

    public ZIPExtractor(@NotNull ZipFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.zipEntry = this.getEntry();
    }
}

