/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profiler.ultimate.async.LazyCachingExtractorFromJar;
import com.intellij.profiler.ultimate.async.UtilsKt;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurationState;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0018\u001a\u00020\u0015H\u0000\u001a\b\u0010\u0019\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\"\u001b\u0010\u0011\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001f"}, d2={"AGENT_FILE_NAME", "", "FRAME_TYPE_CPP", "FRAME_TYPE_KERNEL", "FRAME_TYPE_NATIVE", "JATTACH_FILE_NAME", "JATTACH_PATH", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PROFILER_AGENT_PATH", "asyncProfilerAgentExtractor", "Lcom/intellij/profiler/ultimate/async/LazyCachingExtractorFromJar;", "getAsyncProfilerAgentExtractor", "()Lcom/intellij/profiler/ultimate/async/LazyCachingExtractorFromJar;", "asyncProfilerAgentExtractor$delegate", "Lkotlin/Lazy;", "jattachExtractor", "getJattachExtractor", "jattachExtractor$delegate", "asyncProfilerAvailable", "", "binaryRelativePathInJar", "binaryName", "dtraceProfilerAvailable", "getJattachPath", "getNativeAgentPath", "settings", "Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationState;", "tryToHandleSpacesInAgentPath", "path", "intellij.profiler.ultimate"})
public final class UtilsKt {
    private static final Logger LOG;
    private static final String PROFILER_AGENT_PATH = "idea.async.profiler.agent.path";
    private static final String JATTACH_PATH = "idea.async.profiler.jattach.path";
    @NotNull
    public static final String FRAME_TYPE_NATIVE = "Native";
    @NotNull
    public static final String FRAME_TYPE_CPP = "C++";
    @NotNull
    public static final String FRAME_TYPE_KERNEL = "Kernel";
    private static final String AGENT_FILE_NAME = "libasyncProfiler.so";
    private static final String JATTACH_FILE_NAME = "jattach";
    private static final Lazy asyncProfilerAgentExtractor$delegate;
    private static final Lazy jattachExtractor$delegate;

    public static final boolean asyncProfilerAvailable() {
        return SystemInfo.isMac || SystemInfo.isLinux;
    }

    public static final boolean dtraceProfilerAvailable() {
        return SystemInfo.isMac && Registry.get((String)"idea.profiler.jvm.dtrace").asBoolean();
    }

    private static final String binaryRelativePathInJar(String binaryName) {
        String string;
        if (SystemInfo.isMac) {
            string = "macos";
        } else if (SystemInfo.isLinux) {
            string = "linux";
        } else {
            LOG.warn("Unsupported OS: " + SystemInfo.OS_NAME);
            string = "other";
        }
        String osPart = string;
        return "/binaries/" + osPart + '/' + binaryName;
    }

    private static final LazyCachingExtractorFromJar getAsyncProfilerAgentExtractor() {
        Lazy lazy = asyncProfilerAgentExtractor$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (LazyCachingExtractorFromJar)lazy.getValue();
    }

    private static final LazyCachingExtractorFromJar getJattachExtractor() {
        Lazy lazy = jattachExtractor$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (LazyCachingExtractorFromJar)lazy.getValue();
    }

    @NotNull
    public static final String getNativeAgentPath(@NotNull AsyncProfilerConfigurationState settings) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        String string2 = settings.getAgentPath();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            if (charSequence.length() > 0) {
                return it;
            }
        }
        if ((string = System.getProperty(PROFILER_AGENT_PATH)) == null) {
            String string4 = UtilsKt.getAsyncProfilerAgentExtractor().getFile().getAbsolutePath();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asyncProfilerAgentExtractor.getFile().absolutePath");
        }
        return string;
    }

    @NotNull
    public static final String getJattachPath() {
        String string = System.getProperty(JATTACH_PATH);
        if (string == null) {
            String string2 = UtilsKt.getJattachExtractor().getFile().getAbsolutePath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jattachExtractor.getFile().absolutePath");
        }
        return string;
    }

    @NotNull
    public static final String tryToHandleSpacesInAgentPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String absolutePath = new File(path).getAbsolutePath();
        String string = JavaExecutionUtil.handleSpacesInAgentPath((String)absolutePath, (String)"asyncProfiler", null);
        if (string == null) {
            String string2 = absolutePath;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"absolutePath");
        }
        return string;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.profiler.ultimate.async.Utils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026er.ultimate.async.Utils\")");
        LOG = logger;
        asyncProfilerAgentExtractor$delegate = LazyKt.lazy((Function0)asyncProfilerAgentExtractor.2.INSTANCE);
        jattachExtractor$delegate = LazyKt.lazy((Function0)jattachExtractor.2.INSTANCE);
    }

    public static final /* synthetic */ String access$binaryRelativePathInJar(String binaryName) {
        return UtilsKt.binaryRelativePathInJar(binaryName);
    }
}

