/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.CopyFileDumpWriter;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ultimate.AttachFailed;
import com.intellij.profiler.ultimate.AttachResult;
import com.intellij.profiler.ultimate.AttachedToAlreadyRunningProcessCommunicator;
import com.intellij.profiler.ultimate.Canceled;
import com.intellij.profiler.ultimate.JavaProfilerProcess;
import com.intellij.profiler.ultimate.NativeAgentAttachKt;
import com.intellij.profiler.ultimate.ProfilerProcessCommunicator;
import com.intellij.profiler.ultimate.TimeOut;
import com.intellij.profiler.ultimate.async.AgentConfiguration;
import com.intellij.profiler.ultimate.async.AsyncProfilerProcess;
import com.intellij.profiler.ultimate.async.configurations.AgentOptions;
import com.intellij.profiler.ultimate.jfr.JFRDumpParserProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001(B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0014J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014R\u0019\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerProcess;", "TargetProcess", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "project", "Lcom/intellij/openapi/project/Project;", "communicator", "Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;", "profilerConfiguration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "agentConfiguration", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "attachedTimestamp", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;Lcom/intellij/profiler/ultimate/async/AgentConfiguration;J)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getAttachedTimestamp", "()J", "helpId", "", "getHelpId", "()Ljava/lang/String;", "getProfilerConfiguration", "()Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "doStop", "", "targetProcessId", "", "onTerminateCalled", "", "readPreparedDump", "Lcom/intellij/profiler/api/ProfilerState;", "dump", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.profiler.ultimate"})
public final class AsyncProfilerProcess<TargetProcess extends ProfilerTargetProcess>
extends JavaProfilerProcess<TargetProcess> {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final String helpId;
    @NotNull
    private final ProfilerConfigurationState profilerConfiguration;
    private final AgentConfiguration agentConfiguration;
    private final long attachedTimestamp;
    private static final Logger staticLogger;
    private static final int TERMINATE_AGENT_TIMEOUT = 5000;
    public static final Companion Companion;

    @NotNull
    protected Logger getLOG() {
        return this.LOG;
    }

    @Override
    protected boolean doStop(int targetProcessId) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, targetProcessId){
            final /* synthetic */ AsyncProfilerProcess this$0;
            final /* synthetic */ int $targetProcessId;

            public final void run() {
                if (this.this$0.getState() != Attached.INSTANCE) {
                    return;
                }
                AsyncProfilerProcess.access$runUnderDumpReadIndicator(this.this$0, (Function1)new Function1<ProgressIndicator, Unit>(this){
                    final /* synthetic */ doStop.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ProgressIndicator indicator) {
                        String message;
                        void agentOptions;
                        void agentPath;
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        AsyncProfilerProcess.access$getCommunicator$p(this.this$0.this$0).dispose();
                        AsyncProfilerProcess.access$changeStateAndNotifyAsync(this.this$0.this$0, (ProfilerState)ReadingData.INSTANCE);
                        AgentConfiguration agentConfiguration = AsyncProfilerProcess.access$getAgentConfiguration$p(this.this$0.this$0);
                        String string = agentConfiguration.component1();
                        AgentOptions agentOptions2 = agentConfiguration.component2();
                        File dumpFile = agentConfiguration.component3();
                        AttachResult result = NativeAgentAttachKt.attachAgent(this.this$0.$targetProcessId, (String)agentPath, agentOptions.stopAgent(), -1, indicator);
                        if (result instanceof Canceled) {
                            return;
                        }
                        AttachResult attachResult = result;
                        String string2 = attachResult instanceof AttachFailed ? "Can't stop profiler, jattach output:\n" + ((AttachFailed)result).getMessage() : (message = attachResult instanceof TimeOut ? "Stop command timeout" : null);
                        if (message != null) {
                            AsyncProfilerProcess.access$changeStateAndNotifyAsync(this.this$0.this$0, (ProfilerState)new ProfilerError(message));
                            return;
                        }
                        this.this$0.this$0.getLOG().info("doStop, targetPid: " + this.this$0.$targetProcessId + ", dumpFile: " + dumpFile.getAbsolutePath());
                        ProfilerState readResult = AsyncProfilerProcess.access$readPreparedDumpAndReportStatistics(this.this$0.this$0, dumpFile, indicator);
                        AsyncProfilerProcess.access$changeStateAndNotifyAsync(this.this$0.this$0, readResult);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = asyncProfilerProcess;
                this.$targetProcessId = n;
            }
        });
        return true;
    }

    @NotNull
    protected ProfilerState readPreparedDump(@NotNull File dump, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        if (!dump.exists()) {
            return (ProfilerState)new ProfilerError("There is no dump file");
        }
        if (dump.length() == 0L) {
            return (ProfilerState)new ProfilerError("Dump file is empty");
        }
        ProfilerDumpFileParsingResult result = JFRDumpParserProvider.INSTANCE.createParser(this.getProject()).parse(dump, indicator);
        return this.asProfilerState(result, (ProfilerDumpWriter)new CopyFileDumpWriter(dump, this.getTargetProcess().getFullName(), this.getAttachedTimestamp(), "jfr"));
    }

    protected void onTerminateCalled() {
        if (this.getState().isActive()) {
            this.getCommunicator().dispose();
            Integer n = this.getCommunicator().getTargetProcessId();
            if (n == null) {
                return;
            }
            int pid = n;
            NativeAgentAttachKt.attachAgent$default(pid, this.agentConfiguration.getAgentPath(), "stop", 5000, null, 16, null);
        }
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    @NotNull
    public ProfilerConfigurationState getProfilerConfiguration() {
        return this.profilerConfiguration;
    }

    public long getAttachedTimestamp() {
        return this.attachedTimestamp;
    }

    public AsyncProfilerProcess(@NotNull Project project, @NotNull ProfilerProcessCommunicator<TargetProcess> communicator, @NotNull ProfilerConfigurationState profilerConfiguration, @NotNull AgentConfiguration agentConfiguration, long attachedTimestamp) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(communicator, (String)"communicator");
        Intrinsics.checkNotNullParameter((Object)profilerConfiguration, (String)"profilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)agentConfiguration, (String)"agentConfiguration");
        super(project, communicator, agentConfiguration.getDumpFile());
        this.profilerConfiguration = profilerConfiguration;
        this.agentConfiguration = agentConfiguration;
        this.attachedTimestamp = attachedTimestamp;
        this.LOG = staticLogger;
        this.helpId = "procedures.profiler";
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AsyncProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        staticLogger = logger;
    }

    public static final /* synthetic */ void access$runUnderDumpReadIndicator(AsyncProfilerProcess $this, Function1 process) {
        $this.runUnderDumpReadIndicator(process);
    }

    public static final /* synthetic */ ProfilerProcessCommunicator access$getCommunicator$p(AsyncProfilerProcess $this) {
        return $this.getCommunicator();
    }

    public static final /* synthetic */ void access$changeStateAndNotifyAsync(AsyncProfilerProcess $this, ProfilerState newState) {
        $this.changeStateAndNotifyAsync(newState);
    }

    public static final /* synthetic */ AgentConfiguration access$getAgentConfiguration$p(AsyncProfilerProcess $this) {
        return $this.agentConfiguration;
    }

    public static final /* synthetic */ ProfilerState access$readPreparedDumpAndReportStatistics(AsyncProfilerProcess $this, File dump, ProgressIndicator indicator) {
        return $this.readPreparedDumpAndReportStatistics(dump, indicator);
    }

    public static final /* synthetic */ Logger access$getStaticLogger$cp() {
        return staticLogger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerProcess$Companion;", "", "()V", "TERMINATE_AGENT_TIMEOUT", "", "staticLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "attach", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/profiler/ultimate/async/AsyncProfilerProcess;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "targetProcess", "profilerConfiguration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "agentConfiguration", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "timeoutInMilliseconds", "project", "Lcom/intellij/openapi/project/Project;", "intellij.profiler.ultimate"})
    public static final class Companion {
        @NotNull
        public final Promise<AsyncProfilerProcess<AttachableTargetProcess>> attach(@NotNull AttachableTargetProcess targetProcess, @NotNull ProfilerConfigurationState profilerConfiguration, @NotNull AgentConfiguration agentConfiguration, int timeoutInMilliseconds, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
            Intrinsics.checkNotNullParameter((Object)profilerConfiguration, (String)"profilerConfiguration");
            Intrinsics.checkNotNullParameter((Object)agentConfiguration, (String)"agentConfiguration");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AsyncPromise result = new AsyncPromise();
            new Task.Backgroundable(targetProcess, agentConfiguration, timeoutInMilliseconds, result, project, profilerConfiguration, project, CommonProfilerBundleKt.profilerMessage((String)"attach.task.title", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){
                final /* synthetic */ AttachableTargetProcess $targetProcess;
                final /* synthetic */ AgentConfiguration $agentConfiguration;
                final /* synthetic */ int $timeoutInMilliseconds;
                final /* synthetic */ AsyncPromise $result;
                final /* synthetic */ Project $project;
                final /* synthetic */ ProfilerConfigurationState $profilerConfiguration;

                /*
                 * WARNING - void declaration
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    void agentPath;
                    void agentOptions;
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    indicator.setText(CommonProfilerBundleKt.profilerMessage((String)"attach.task.text", (Object[])new Object[]{this.$targetProcess.getFullName()}));
                    AgentConfiguration agentConfiguration = this.$agentConfiguration;
                    String string = agentConfiguration.component1();
                    AgentOptions agentOptions2 = agentConfiguration.component2();
                    File dumpFile = agentConfiguration.component3();
                    String attachOptions = agentOptions.startAgent(dumpFile);
                    AsyncProfilerProcess.access$getStaticLogger$cp().info("attach profiler to running process: agent:" + (String)agentPath + ", options:" + attachOptions);
                    AttachResult attachResult = NativeAgentAttachKt.attachAgent(this.$targetProcess.getPid(), (String)agentPath, attachOptions, this.$timeoutInMilliseconds, indicator);
                    AttachedToAlreadyRunningProcessCommunicator communicator = new AttachedToAlreadyRunningProcessCommunicator(this.$targetProcess);
                    AsyncPromise $this$catchError$iv = this.$result;
                    boolean $i$f$catchError = false;
                    try {
                        boolean bl = false;
                        NativeAgentAttachKt.throwIfFailed(attachResult, this.$targetProcess);
                        this.$result.setResult(new AsyncProfilerProcess<TargetProcess>(this.$project, communicator, this.$profilerConfiguration, this.$agentConfiguration, System.currentTimeMillis()));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable e$iv) {
                        $this$catchError$iv.setError(e$iv);
                        Object var11_12 = null;
                    }
                }
                {
                    this.$targetProcess = $captured_local_variable$0;
                    this.$agentConfiguration = $captured_local_variable$1;
                    this.$timeoutInMilliseconds = $captured_local_variable$2;
                    this.$result = $captured_local_variable$3;
                    this.$project = $captured_local_variable$4;
                    this.$profilerConfiguration = $captured_local_variable$5;
                    super($super_call_param$6, $super_call_param$7, $super_call_param$8, $super_call_param$9);
                }
            }.queue();
            return (Promise)result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

