/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CallTreeBuilder;
import com.intellij.profiler.CollapsedDumpParser;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.NewCallTreeOnlyProfilerData;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ultimate.JavaCallStackElementRenderer;
import com.intellij.profiler.ultimate.async.AsyncProfilerDumpParserProviderKt;
import com.intellij.profiler.ultimate.async.FileReader;
import com.intellij.profiler.ultimate.async.GZIPExtractor;
import com.intellij.profiler.ultimate.async.PlaneTextFileReader;
import com.intellij.profiler.ultimate.async.ZIPExtractor;
import java.io.File;
import java.util.Map;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerFileParser;", "Lcom/intellij/profiler/api/ProfilerDumpFileParser;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "helpId", "", "getHelpId", "()Ljava/lang/String;", "parse", "Lcom/intellij/profiler/api/ProfilerDumpFileParsingResult;", "file", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.profiler.ultimate"})
public final class AsyncProfilerFileParser
implements ProfilerDumpFileParser {
    @NotNull
    private final String helpId;
    private final Project project;

    @NotNull
    public ProfilerDumpFileParsingResult parse(@NotNull File file, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        CollapsedDumpParser<BaseCallStackElement> parser2 = AsyncProfilerDumpParserProviderKt.createCollapsedParser(this.project);
        Map extractors2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"zip", (Object)new Function0<ZIPExtractor>(file){
            final /* synthetic */ File $file;

            @NotNull
            public final ZIPExtractor invoke() {
                return new ZIPExtractor(new ZipFile(this.$file));
            }
            {
                this.$file = file;
                super(0);
            }
        }), TuplesKt.to((Object)"gzip", (Object)new Function0<GZIPExtractor>(file){
            final /* synthetic */ File $file;

            @NotNull
            public final GZIPExtractor invoke() {
                return new GZIPExtractor(this.$file);
            }
            {
                this.$file = file;
                super(0);
            }
        }), TuplesKt.to((Object)"gz", (Object)new Function0<GZIPExtractor>(file){
            final /* synthetic */ File $file;

            @NotNull
            public final GZIPExtractor invoke() {
                return new GZIPExtractor(this.$file);
            }
            {
                this.$file = file;
                super(0);
            }
        })});
        Object object = (Function0)extractors2.get(FilesKt.getExtension((File)file));
        if (object == null || (object = (FileReader)object.invoke()) == null) {
            object = new PlaneTextFileReader(file);
        }
        Function0 reader = object;
        reader.readFully(parser2, indicator);
        return (ProfilerDumpFileParsingResult)new Success((ProfilerData)new NewCallTreeOnlyProfilerData((CallTreeBuilder)parser2.getDataBuilder(), (BaseCallStackElementRenderer)JavaCallStackElementRenderer.Companion.getINSTANCE()));
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    public AsyncProfilerFileParser(@Nullable Project project) {
        this.project = project;
        this.helpId = "procedures.profiler";
    }
}

