/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.DefaultProfilerExecutorGroup;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.linux.HasInvalidVariables;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesChangeRequiredException;
import com.intellij.profiler.linux.KernelVariablesValidatorKt;
import com.intellij.profiler.linux.ValidationResult;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationExtension;
import com.intellij.profiler.ultimate.ProfilerRunnerSettings;
import com.intellij.profiler.ultimate.async.AgentConfiguration;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionBase;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionBaseKt;
import com.intellij.profiler.ultimate.async.UtilsKt;
import com.intellij.profiler.ultimate.async.configurations.AgentOptions;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurationState;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerStarter;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J3\u0010\n\u001a\u00020\u000b\"\f\b\u0000\u0010\f*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u0002H\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J1\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\"\f\b\u0000\u0010\f*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u0002H\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004\u00a2\u0006\u0002\u0010\u0019J;\u0010\u001a\u001a\u00020\u000b\"\f\b\u0000\u0010\f*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u0002H\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fR'\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u00020\u0005\u00a2\u0006\u0002\b\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBase;", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension;", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "()V", "profilerParametersKey", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProfilerParametersKey", "()Lcom/intellij/openapi/util/Key;", "doUpdateJavaParameters", "", "T", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "configuration", "settings", "Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationState;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationState;Lcom/intellij/execution/configurations/JavaParameters;)V", "isApplicableFor", "", "makeProfilerAgentParameters", "", "", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationState;)Ljava/util/List;", "updateJavaParameters", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "executor", "Lcom/intellij/execution/Executor;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;Lcom/intellij/execution/Executor;)V", "Companion", "intellij.profiler.ultimate"})
public abstract class AsyncProfilerConfigurationExtensionBase
extends JavaProfilerConfigurationExtension<AgentConfiguration> {
    @NotNull
    private final Key<AgentConfiguration> profilerParametersKey = PROFILER_AGENT_CONFIGURATION_KEY;
    @NotNull
    private static final Key<AgentConfiguration> PROFILER_AGENT_CONFIGURATION_KEY;
    @NotNull
    private static final List<KernelVariable> requiredKernelVariables;
    public static final Companion Companion;

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
        return AsyncProfilerStarter.INSTANCE.isApplicable(project) && AsyncProfilerStarter.INSTANCE.canRun((RunProfile)configuration);
    }

    public final <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters params, @Nullable RunnerSettings runnerSettings, @NotNull Executor executor) {
        DefaultProfilerExecutorGroup defaultProfilerExecutorGroup;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
                if (!(runnerSettings instanceof ProfilerRunnerSettings)) {
                    return;
                }
                defaultProfilerExecutorGroup = DefaultProfilerExecutorGroup.Companion.getInstance();
                if (defaultProfilerExecutorGroup == null) break block6;
                String string = executor.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executor.id");
                if ((defaultProfilerExecutorGroup = (DefaultProfilerExecutorGroup.ProfilerExecutorSettings)defaultProfilerExecutorGroup.getRegisteredSettings(string)) != null) break block7;
            }
            return;
        }
        DefaultProfilerExecutorGroup executorSettings = defaultProfilerExecutorGroup;
        ProfilerConfigurationState profilerConfigurationState = executorSettings.getState();
        if (!(profilerConfigurationState instanceof AsyncProfilerConfigurationState)) {
            profilerConfigurationState = null;
        }
        AsyncProfilerConfigurationState asyncProfilerConfigurationState = (AsyncProfilerConfigurationState)profilerConfigurationState;
        if (asyncProfilerConfigurationState == null) {
            return;
        }
        AsyncProfilerConfigurationState settings = asyncProfilerConfigurationState;
        this.doUpdateJavaParameters(configuration, settings, params);
    }

    protected <T extends RunConfigurationBase<?>> void doUpdateJavaParameters(@NotNull T configuration, @NotNull AsyncProfilerConfigurationState settings, @NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List<String> vmParameters = this.makeProfilerAgentParameters(configuration, settings);
        params.getVMParametersList().addAll(vmParameters);
    }

    @NotNull
    protected final <T extends RunConfigurationBase<?>> List<String> makeProfilerAgentParameters(@NotNull T configuration, @NotNull AsyncProfilerConfigurationState settings) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        String nativeAgentPath = UtilsKt.getNativeAgentPath(settings);
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
        MisConfiguredException misConfiguredException = AsyncProfilerConfigurationExtensionBaseKt.validateAgentPath(nativeAgentPath, project, (ProfilerConfigurationState)settings);
        if (misConfiguredException != null) {
            MisConfiguredException misConfiguredException2 = misConfiguredException;
            boolean bl = false;
            boolean bl2 = false;
            MisConfiguredException it = misConfiguredException2;
            boolean bl3 = false;
            throw (Throwable)it;
        }
        ValidationResult validationResult = KernelVariablesValidatorKt.checkKernelVariables(requiredKernelVariables);
        if (validationResult instanceof HasInvalidVariables) {
            HasInvalidVariables hasInvalidVariables = (HasInvalidVariables)validationResult;
            Project project2 = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"configuration.project");
            throw (Throwable)new KernelVariablesChangeRequiredException(hasInvalidVariables, project2);
        }
        String agentPath = UtilsKt.tryToHandleSpacesInAgentPath(nativeAgentPath);
        File file = FileUtil.createTempFile((String)"asyncprofiler", (String)".jfr", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\u2026cprofiler\", \".jfr\", true)");
        File dumpFile = file;
        AgentOptions options = settings.agentOptions();
        configuration.putUserData(this.getProfilerConfigurationStateKey(), (Object)settings);
        configuration.putUserData(this.getProfilerParametersKey(), (Object)new AgentConfiguration(agentPath, options, dumpFile));
        String agentArgs = options.startAgent(dumpFile);
        String vmParameters = "-agentpath:" + agentPath + '=' + agentArgs;
        AsyncProfilerConfigurationExtensionBaseKt.access$getLOG$p().info("start profiler from run configuration, add VM parameters: " + vmParameters);
        return CollectionsKt.listOf((Object)vmParameters);
    }

    @Override
    @NotNull
    protected Key<AgentConfiguration> getProfilerParametersKey() {
        return this.profilerParametersKey;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"async.profiler.agent.configuration");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<AgentConfigur\u2026ler.agent.configuration\")");
        PROFILER_AGENT_CONFIGURATION_KEY = key;
        requiredKernelVariables = CollectionsKt.listOf((Object[])new KernelVariable[]{new KernelVariable("perf_event_paranoid", "1", (Function1)Companion.requiredKernelVariables.1.INSTANCE), new KernelVariable("kptr_restrict", "0", (Function1)Companion.requiredKernelVariables.2.INSTANCE)});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBase$Companion;", "", "()V", "PROFILER_AGENT_CONFIGURATION_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPROFILER_AGENT_CONFIGURATION_KEY", "()Lcom/intellij/openapi/util/Key;", "requiredKernelVariables", "", "Lcom/intellij/profiler/linux/KernelVariable;", "getRequiredKernelVariables", "()Ljava/util/List;", "intellij.profiler.ultimate"})
    public static final class Companion {
        @NotNull
        public final Key<AgentConfiguration> getPROFILER_AGENT_CONFIGURATION_KEY() {
            return PROFILER_AGENT_CONFIGURATION_KEY;
        }

        @NotNull
        public final List<KernelVariable> getRequiredKernelVariables() {
            return requiredKernelVariables;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

