/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.ultimate.JavaTargetProcess;
import com.intellij.profiler.ultimate.async.TargetProcessBase;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getAllJavaProcesses", "", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getAllJavaProcessesUsingJvmStat", "intellij.profiler.ultimate"})
public final class ProcessUtilKt {
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AttachableTargetProcess> getAllJavaProcesses(@Nullable ProgressIndicator progressIndicator) {
        List list;
        if (SystemInfo.isWindows) {
            void $this$mapTo$iv$iv;
            List<VirtualMachineDescriptor> list2 = VirtualMachine.list();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"VirtualMachine.list()");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void it;
                VirtualMachineDescriptor virtualMachineDescriptor = (VirtualMachineDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.id(), (String)"it.id()");
                boolean bl2 = false;
                int n = Integer.parseInt(string);
                String string2 = it.displayName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.displayName()");
                TargetProcessBase targetProcessBase = new TargetProcessBase(n, StringsKt.substringBefore$default((String)string2, (char)' ', null, (int)2, null));
                collection.add(targetProcessBase);
            }
            list = (List)destination$iv$iv;
        } else {
            list = ProcessUtilKt.getAllJavaProcessesUsingJvmStat(progressIndicator);
        }
        return list;
    }

    public static /* synthetic */ List getAllJavaProcesses$default(ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 1) != 0) {
            progressIndicator = null;
        }
        return ProcessUtilKt.getAllJavaProcesses(progressIndicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List<AttachableTargetProcess> getAllJavaProcessesUsingJvmStat(ProgressIndicator progressIndicator) throws ProcessCanceledException {
        void $this$mapNotNullTo$iv$iv;
        MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(new HostIdentifier((String)null));
        Set<Integer> set = monitoredHost.activeVms();
        Intrinsics.checkNotNullExpressionValue(set, (String)"monitoredHost.activeVms()");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JavaTargetProcess javaTargetProcess;
            JavaTargetProcess javaTargetProcess2;
            block7: {
                boolean bl;
                MonitoredVm it;
                MonitoredVm monitoredVm;
                boolean bl2;
                boolean bl3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl4 = false;
                Integer pid = (Integer)element$iv$iv;
                boolean bl5 = false;
                MonitoredVm vm = null;
                ProgressIndicator progressIndicator2 = progressIndicator;
                if (progressIndicator2 != null) {
                    progressIndicator2.checkCanceled();
                }
                try {
                    JavaTargetProcess process;
                    vm = monitoredHost.getMonitoredVm(new VmIdentifier("//" + pid + "?mode=r"));
                    Integer n = pid;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"pid");
                    int n2 = n;
                    String string = MonitoredVmUtil.mainClass(vm, true);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MonitoredVmUtil.mainClass(vm, true)");
                    String string2 = MonitoredVmUtil.jvmArgs(vm);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MonitoredVmUtil.jvmArgs(vm)");
                    String string3 = MonitoredVmUtil.jvmFlags(vm);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MonitoredVmUtil.jvmFlags(vm)");
                    String string4 = MonitoredVmUtil.commandLine(vm);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MonitoredVmUtil.commandLine(vm)");
                    javaTargetProcess2 = process = new JavaTargetProcess(n2, string, string2, string3, string4);
                    if (vm == null) break block7;
                    bl3 = false;
                    bl2 = false;
                    it = monitoredVm;
                    bl = false;
                }
                catch (Exception e) {
                    try {
                        LOG.debug((Throwable)e);
                        javaTargetProcess2 = null;
                        if (vm == null) break block7;
                        bl3 = false;
                        bl2 = false;
                        it = monitoredVm;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        MonitoredVm monitoredVm2 = vm;
                        if (monitoredVm2 != null) {
                            MonitoredVm monitoredVm3 = monitoredVm2;
                            bl2 = false;
                            boolean bl6 = false;
                            MonitoredVm it2 = monitoredVm3;
                            boolean bl7 = false;
                            monitoredHost.detach(it2);
                        }
                        throw throwable;
                    }
                    monitoredHost.detach(it);
                }
                monitoredHost.detach(it);
            }
            if (javaTargetProcess2 == null) continue;
            boolean bl = false;
            boolean bl8 = false;
            JavaTargetProcess it$iv$iv = javaTargetProcess;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List getAllJavaProcessesUsingJvmStat$default(ProgressIndicator progressIndicator, int n, Object object) throws ProcessCanceledException {
        if ((n & 1) != 0) {
            progressIndicator = null;
        }
        return ProcessUtilKt.getAllJavaProcessesUsingJvmStat(progressIndicator);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.profiler.ultimate.ProcessUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026er.ultimate.ProcessUtil\")");
        LOG = logger;
    }
}

