/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.api.AttachCanceledException;
import com.intellij.profiler.api.AttachProfilerUtilsKt;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.ultimate.AttachFailed;
import com.intellij.profiler.ultimate.AttachResult;
import com.intellij.profiler.ultimate.Canceled;
import com.intellij.profiler.ultimate.NoSuchProcess;
import com.intellij.profiler.ultimate.Success;
import com.intellij.profiler.ultimate.TimeOut;
import com.intellij.profiler.ultimate.async.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "attachAgent", "Lcom/intellij/profiler/ultimate/AttachResult;", "targetPid", "", "agentPath", "", "agentOptions", "timeout", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "throwIfFailed", "", "target", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "intellij.profiler.ultimate"})
public final class NativeAgentAttachKt {
    private static final Logger LOG;

    @NotNull
    public static final AttachResult attachAgent(int targetPid, @NotNull String agentPath, @NotNull String agentOptions, int timeout, @Nullable ProgressIndicator indicator) {
        ProgressIndicator output;
        ProgressIndicator progressIndicator;
        block8: {
            CapturingProcessHandler handler;
            block7: {
                Intrinsics.checkNotNullParameter((Object)agentPath, (String)"agentPath");
                Intrinsics.checkNotNullParameter((Object)agentOptions, (String)"agentOptions");
                GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{UtilsKt.getJattachPath(), String.valueOf(targetPid), "load", agentPath, "true", agentOptions}).withRedirectErrorStream(true);
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine(getJa\u2026RedirectErrorStream(true)");
                GeneralCommandLine jattachCmd = generalCommandLine;
                handler = new CapturingProcessHandler(jattachCmd);
                progressIndicator = indicator;
                if (progressIndicator == null) break block7;
                ProgressIndicator progressIndicator2 = progressIndicator;
                boolean bl = false;
                boolean bl2 = false;
                ProgressIndicator it = progressIndicator2;
                boolean bl3 = false;
                progressIndicator = handler.runProcessWithProgressIndicator(it, timeout, true);
                if (progressIndicator != null) break block8;
            }
            progressIndicator = handler.runProcess(timeout, true);
        }
        ProgressIndicator progressIndicator3 = output = progressIndicator;
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator3, (String)"output");
        if (progressIndicator3.isCancelled()) {
            return Canceled.INSTANCE;
        }
        if (output.getExitCode() == 0) {
            return Success.INSTANCE;
        }
        if (output.isTimeout()) {
            return TimeOut.INSTANCE;
        }
        String string = output.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.stdout");
        String jattachOutput = StringsKt.trimEnd((String)string, (char[])new char[]{'\n'});
        CharSequence charSequence = StringsKt.substringBefore$default((String)jattachOutput, (char)'\n', null, (int)2, null);
        Regex regex = new Regex("Process \\d+ not found");
        boolean bl = false;
        if (regex.matches(charSequence)) {
            return NoSuchProcess.INSTANCE;
        }
        LOG.error("jattach failed with text", new String[]{jattachOutput});
        return new AttachFailed(jattachOutput);
    }

    public static /* synthetic */ AttachResult attachAgent$default(int n, String string, String string2, int n2, ProgressIndicator progressIndicator, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            progressIndicator = null;
        }
        return NativeAgentAttachKt.attachAgent(n, string, string2, n2, progressIndicator);
    }

    public static final void throwIfFailed(@NotNull AttachResult $this$throwIfFailed, @NotNull AttachableTargetProcess target) throws Exception {
        Intrinsics.checkNotNullParameter((Object)$this$throwIfFailed, (String)"$this$throwIfFailed");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        AttachResult attachResult = $this$throwIfFailed;
        if (attachResult instanceof Canceled) {
            throw (Throwable)AttachCanceledException.INSTANCE;
        }
        if (attachResult instanceof TimeOut) {
            throw (Throwable)AttachProfilerUtilsKt.attachFailedTimeout((AttachableTargetProcess)target);
        }
        if (attachResult instanceof NoSuchProcess) {
            throw (Throwable)AttachProfilerUtilsKt.attachFailedCantGrubPid((AttachableTargetProcess)target);
        }
        if (attachResult instanceof AttachFailed) {
            throw (Throwable)new RuntimeException(((AttachFailed)$this$throwIfFailed).getMessage());
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.profiler.ultimate.NativeAgentAttach");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026imate.NativeAgentAttach\")");
        LOG = logger;
    }
}

