/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.FileBasedProfilerProcess;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.ultimate.ProfilerProcessCommunicator;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0004J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H$R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "TargetProcess", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/FileBasedProfilerProcess;", "project", "Lcom/intellij/openapi/project/Project;", "communicator", "Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;", "dumpFileWhenTargetProcessFinished", "Ljava/io/File;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;Ljava/io/File;)V", "getCommunicator", "()Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;", "canBeStopped", "", "doStop", "targetProcessId", "", "intellij.profiler.ultimate"})
public abstract class JavaProfilerProcess<TargetProcess extends ProfilerTargetProcess>
extends FileBasedProfilerProcess<TargetProcess> {
    @NotNull
    private final ProfilerProcessCommunicator<TargetProcess> communicator;

    protected abstract boolean doStop(int var1);

    protected final boolean doStop() {
        if (!this.canBeStopped()) {
            return false;
        }
        Integer n = this.communicator.getTargetProcessId();
        if (n == null) {
            return false;
        }
        int pid = n;
        return this.doStop(pid);
    }

    public boolean canBeStopped() {
        return this.communicator.canBeStopped();
    }

    @NotNull
    protected final ProfilerProcessCommunicator<TargetProcess> getCommunicator() {
        return this.communicator;
    }

    public JavaProfilerProcess(@NotNull Project project, @NotNull ProfilerProcessCommunicator<TargetProcess> communicator, @NotNull File dumpFileWhenTargetProcessFinished) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(communicator, (String)"communicator");
        Intrinsics.checkNotNullParameter((Object)dumpFileWhenTargetProcessFinished, (String)"dumpFileWhenTargetProcessFinished");
        super(project, communicator.getTargetProcess(), dumpFileWhenTargetProcessFinished);
        this.communicator = communicator;
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.communicator);
        this.initTargetProcessLifecycleListener(this.communicator.getTargetProcessHandler());
    }
}

