/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ultimate.ProfilerRunnerSettings;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 #*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0004J1\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00028\u00002\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J\u001e\u0010\u001b\u001a\u00020\u000e2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0010J3\u0010\u001e\u001a\u00020\u000e\"\f\b\u0001\u0010\u001f*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000f\u001a\u0002H\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\"R'\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension;", "ProfilerParameters", "Lcom/intellij/execution/RunConfigurationExtension;", "()V", "profilerConfigurationStateKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProfilerConfigurationStateKey", "()Lcom/intellij/openapi/util/Key;", "profilerParametersKey", "getProfilerParametersKey", "attachToProcess", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "profilerConfigurationState", "profilerParameters", "runConfiguration", "(Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;Ljava/lang/Object;Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/process/ProcessHandler;)V", "cleanUserData", "runConfigurationBase", "openToolWindowAndReportStart", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "updateJavaParameters", "T", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;)V", "Companion", "intellij.profiler.ultimate"})
public abstract class JavaProfilerConfigurationExtension<ProfilerParameters>
extends RunConfigurationExtension {
    @NotNull
    private final Key<ProfilerConfigurationState> profilerConfigurationStateKey;
    public static final Companion Companion = new Companion(null);

    public final <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters params, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!(runnerSettings instanceof ProfilerRunnerSettings)) {
            return;
        }
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
        throw (Throwable)((Object)new Companion.CantDetectProfilerExecutorId(project));
    }

    @NotNull
    protected final Key<ProfilerConfigurationState> getProfilerConfigurationStateKey() {
        return this.profilerConfigurationStateKey;
    }

    @NotNull
    protected abstract Key<ProfilerParameters> getProfilerParametersKey();

    public final void openToolWindowAndReportStart(@NotNull ProfilerProcess<?> profilerProcess, @NotNull RunConfigurationBase<?> runConfiguration) {
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        String string = profilerProcess.getProfilerConfiguration().getConfigurationTypeId();
        ConfigurationType configurationType = runConfiguration.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"runConfiguration.type");
        String string2 = configurationType.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"runConfiguration.type.id");
        ProfilerUsageTriggerCollector.Companion.reportStart(string, string2);
        Project project = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"runConfiguration.project");
        ProfilerToolWindowManager.addProfilerProcessTab$default((ProfilerToolWindowManager)ProfilerToolWindowManager.Companion.getInstance(project), profilerProcess, (boolean)false, (int)2, null);
    }

    protected abstract void attachToProcess(@NotNull ProfilerConfigurationState var1, ProfilerParameters var2, @NotNull RunConfigurationBase<?> var3, @NotNull ProcessHandler var4) throws ExecutionException;

    protected final void attachToProcess(@NotNull RunConfigurationBase<?> configuration, @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (!(runnerSettings instanceof ProfilerRunnerSettings)) {
            return;
        }
        Object profilerParameters = configuration.getUserData(this.getProfilerParametersKey());
        ProfilerConfigurationState profilerConfigurationState = (ProfilerConfigurationState)configuration.getUserData(this.profilerConfigurationStateKey);
        this.cleanUserData(configuration);
        if (profilerParameters == null || profilerConfigurationState == null) {
            return;
        }
        this.attachToProcess(profilerConfigurationState, profilerParameters, configuration, handler);
    }

    public void cleanUserData(@Nullable RunConfigurationBase<?> runConfigurationBase) {
        block1: {
            RunConfigurationBase<?> runConfigurationBase2 = runConfigurationBase;
            if (runConfigurationBase2 != null) {
                runConfigurationBase2.putUserData(this.getProfilerParametersKey(), null);
            }
            RunConfigurationBase<?> runConfigurationBase3 = runConfigurationBase;
            if (runConfigurationBase3 == null) break block1;
            runConfigurationBase3.putUserData(this.profilerConfigurationStateKey, null);
        }
    }

    public JavaProfilerConfigurationExtension() {
        Key key = Key.create((String)"profiler.configuration.state");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<ProfilerConfi\u2026ler.configuration.state\")");
        this.profilerConfigurationStateKey = key;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension$Companion;", "", "()V", "CantDetectProfilerExecutorId", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension$Companion$CantDetectProfilerExecutorId;", "Lcom/intellij/profiler/MisConfiguredException;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fixAction", "", "intellij.profiler.ultimate"})
        private static final class CantDetectProfilerExecutorId
        extends MisConfiguredException {
            public void fixAction(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                BrowserUtil.browse((String)"https://youtrack.jetbrains.com/newIssue?project=IDEA");
            }

            public CantDetectProfilerExecutorId(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                super(project, UltimateProfilerBundleKt.profilerMessage("profiler.exceptions.configurations.patch", new Object[0]), UltimateProfilerBundleKt.profilerMessage("profiler.exceptions.ask.report", new Object[0]));
            }
        }
    }
}

