/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.openapi.util.TextRange;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CantBeParsedCall;
import com.intellij.profiler.model.NativeCall;
import com.intellij.profiler.ui.NativeCallStackElementRenderer;
import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.profiler.ultimate.JavaCallStackElementRenderer;
import com.intellij.profiler.ultimate.model.BaseJavaCall;
import com.intellij.profiler.ultimate.model.BaseJavaMethodCall;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.UtilKt;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 '2\u00020\u0001:\u0003&'(B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J,\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eH\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020%0$0#2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer;", "Lcom/intellij/profiler/ui/NativeCallStackElementRenderer;", "()V", "appendStackElementInRenderer", "", "node", "Lcom/intellij/profiler/api/BaseCallStackElement;", "label", "Lcom/intellij/ui/SimpleColoredComponent;", "component", "Ljavax/swing/JComponent;", "selected", "", "buildString", "", "pkg", "cls", "method", "args", "doAppendStackElementInRenderer", "speedSearchHighlightedRanges", "", "Lcom/intellij/openapi/util/TextRange;", "fillJavaMethodText", "Lcom/intellij/profiler/ultimate/model/BaseJavaMethodCall;", "rect", "Ljava/awt/geom/Rectangle2D;", "fontMetrics", "Ljava/awt/FontMetrics;", "fillTextInsideNode", "getColorScheme", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "type", "getText", "styledText", "", "Lkotlin/Pair;", "Lcom/intellij/ui/SimpleTextAttributes;", "CPP", "Companion", "KERNEL", "intellij.profiler.ultimate"})
public class JavaCallStackElementRenderer
extends NativeCallStackElementRenderer {
    @NotNull
    private static final JavaCallStackElementRenderer INSTANCE;
    public static final Companion Companion;

    @NotNull
    public String fillTextInsideNode(@NotNull BaseCallStackElement node, @NotNull Rectangle2D rect, @NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        if (node instanceof BaseJavaMethodCall) {
            try {
                return this.fillJavaMethodText((BaseJavaMethodCall)node, rect, fontMetrics);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.fillTextInsideNode(node, rect, fontMetrics);
    }

    @NotNull
    public String getText(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return CollectionsKt.joinToString$default((Iterable)this.styledText(node), (CharSequence)"", null, null, (int)0, null, (Function1)getText.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    public void appendStackElementInRenderer(@NotNull BaseCallStackElement node, @NotNull SimpleColoredComponent label, @NotNull JComponent component, boolean selected) {
        Iterable highlightedRanges;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        SpeedSearchSupply speedSearchSupply = SpeedSearchSupply.getSupply((JComponent)component);
        Iterable iterable = highlightedRanges = speedSearchSupply != null ? speedSearchSupply.matchingFragments(this.getText(node)) : null;
        if (highlightedRanges == null) {
            for (Pair<String, SimpleTextAttributes> pair : this.styledText(node)) {
                void text;
                String string = (String)pair.component1();
                SimpleTextAttributes style = (SimpleTextAttributes)pair.component2();
                SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)component, (String)text, (SimpleTextAttributes)style, (boolean)selected, (SimpleColoredComponent)label);
            }
        } else {
            this.doAppendStackElementInRenderer(node, highlightedRanges, label, selected);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void doAppendStackElementInRenderer(@NotNull BaseCallStackElement node, @NotNull Iterable<? extends TextRange> speedSearchHighlightedRanges, @NotNull SimpleColoredComponent label, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(speedSearchHighlightedRanges, (String)"speedSearchHighlightedRanges");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        List highlightedRanges = CollectionsKt.toMutableList(speedSearchHighlightedRanges);
        int prefixLength = 0;
        TextRange overlappingFromPreviousStep = null;
        for (Pair<String, SimpleTextAttributes> pair : this.styledText(node)) {
            void $this$mapTo$iv$iv;
            void text;
            Object item$iv2;
            String string = (String)pair.component1();
            SimpleTextAttributes attributes = (SimpleTextAttributes)pair.component2();
            boolean bl = false;
            List rangesForText = new ArrayList();
            UtilKt.addIfNotNull((List)rangesForText, (Object)overlappingFromPreviousStep);
            Iterable $this$takeWhile$iv = highlightedRanges;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv2 : $this$takeWhile$iv) {
                TextRange it = (TextRange)item$iv2;
                boolean bl2 = false;
                if (!(it.getStartOffset() < prefixLength + text.length())) break;
                list$iv.add(item$iv2);
            }
            List taken = list$iv;
            highlightedRanges.removeAll(taken);
            rangesForText.addAll(taken);
            TextRange lastMaybeOverlappingRange = (TextRange)CollectionsKt.lastOrNull((List)rangesForText);
            if (lastMaybeOverlappingRange != null && lastMaybeOverlappingRange.getEndOffset() >= prefixLength + text.length()) {
                rangesForText.set(CollectionsKt.getLastIndex((List)rangesForText), new TextRange(lastMaybeOverlappingRange.getStartOffset(), prefixLength + text.length()));
                overlappingFromPreviousStep = new TextRange(prefixLength + text.length(), lastMaybeOverlappingRange.getEndOffset());
            } else {
                overlappingFromPreviousStep = null;
            }
            Iterable $this$map$iv = rangesForText;
            boolean $i$f$map = false;
            item$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextRange textRange = (TextRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                TextRange textRange2 = it.shiftLeft(prefixLength);
                collection.add(textRange2);
            }
            List shifted = (List)destination$iv$iv;
            prefixLength += text.length();
            SpeedSearchUtil.appendSpeedSearchColoredFragments((SimpleColoredComponent)label, (String)text, (Iterable)shifted, (SimpleTextAttributes)attributes, (boolean)selected);
        }
    }

    private final List<Pair<String, SimpleTextAttributes>> styledText(BaseCallStackElement node) {
        boolean bl = false;
        List result = new ArrayList();
        if (node instanceof BaseJavaMethodCall) {
            CharSequence charSequence = ((BaseJavaMethodCall)node).getFullPackageName();
            boolean bl2 = false;
            if (charSequence.length() > 0) {
                result.add(new Pair((Object)(((BaseJavaMethodCall)node).getFullPackageName() + "."), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            }
            charSequence = ((BaseJavaMethodCall)node).getClassName();
            bl2 = false;
            if (charSequence.length() > 0) {
                result.add(new Pair((Object)(((BaseJavaMethodCall)node).getClassName() + "." + ((BaseJavaMethodCall)node).getMethodName()), (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                if (((BaseJavaMethodCall)node).getArgumentTypes() != null) {
                    result.add(new Pair((Object)((BaseJavaMethodCall)node).argumentTypesString(), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                }
            } else {
                result.add(new Pair((Object)((BaseJavaMethodCall)node).getMethodName(), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            }
        } else {
            result.add(new Pair((Object)node.fullName(), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
        }
        return result;
    }

    @NotNull
    public FlameChartColorScheme getColorScheme(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BaseCallStackElement baseCallStackElement = node;
        return baseCallStackElement instanceof BaseJavaCall ? (FlameChartColorScheme)FlameChartColors.JAVA.INSTANCE : (baseCallStackElement instanceof NativeCall ? this.getColorScheme(((NativeCall)node).getType()) : (baseCallStackElement instanceof CantBeParsedCall ? this.getColorScheme(((CantBeParsedCall)node).getType()) : super.getColorScheme(node)));
    }

    private final FlameChartColorScheme getColorScheme(String type) {
        FlameChartColorScheme flameChartColorScheme;
        switch (type) {
            case "Native": {
                flameChartColorScheme = (FlameChartColorScheme)FlameChartColors.NATIVE.INSTANCE;
                break;
            }
            case "C++": {
                flameChartColorScheme = (FlameChartColorScheme)CPP.INSTANCE;
                break;
            }
            case "Kernel": {
                flameChartColorScheme = (FlameChartColorScheme)KERNEL.INSTANCE;
                break;
            }
            default: {
                flameChartColorScheme = (FlameChartColorScheme)FlameChartColors.NATIVE.INSTANCE;
            }
        }
        return flameChartColorScheme;
    }

    /*
     * WARNING - void declaration
     */
    private final String fillJavaMethodText(BaseJavaMethodCall node, Rectangle2D rect, FontMetrics fontMetrics) {
        void $this$mapTo$iv$iv;
        double maxWidth = rect.getWidth() - (double)4;
        String argumentTypesString = node.argumentTypesString();
        String fullName = this.buildString(node.getFullPackageName(), node.getClassName(), node.getMethodName(), argumentTypesString);
        if ((double)fontMetrics.stringWidth(fullName) < maxWidth) {
            return fullName;
        }
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)node.getFullPackageName(), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char c = StringsKt.first((CharSequence)((CharSequence)it));
            boolean bl2 = false;
            Character c2 = Character.valueOf(Character.toLowerCase(c));
            collection.add(c2);
        }
        String abbrevPackage = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        String shortPkg = this.buildString(abbrevPackage, node.getClassName(), node.getMethodName(), argumentTypesString);
        if ((double)fontMetrics.stringWidth(shortPkg) < maxWidth) {
            return shortPkg;
        }
        String shortPkgNoArgs = this.buildString(abbrevPackage, node.getClassName(), node.getMethodName(), "");
        if ((double)fontMetrics.stringWidth(shortPkgNoArgs) < maxWidth) {
            return shortPkgNoArgs;
        }
        String clsMethodNoArgs = this.buildString("", node.getClassName(), node.getMethodName(), "");
        if ((double)fontMetrics.stringWidth(clsMethodNoArgs) < maxWidth) {
            return clsMethodNoArgs;
        }
        String methodNoArgs = this.buildString("", "", node.getMethodName(), "");
        if ((double)fontMetrics.stringWidth(methodNoArgs) < maxWidth) {
            return methodNoArgs;
        }
        if ((double)fontMetrics.stringWidth("...") < maxWidth) {
            return "...";
        }
        return "";
    }

    private final String buildString(String pkg, String cls, String method, String args) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        CharSequence charSequence = pkg;
        boolean bl6 = false;
        if (charSequence.length() > 0) {
            StringsKt.append((StringBuilder)$this$buildString, (String[])new String[]{pkg, "."});
        }
        charSequence = cls;
        bl6 = false;
        if (charSequence.length() > 0) {
            StringsKt.append((StringBuilder)$this$buildString, (String[])new String[]{cls, "."});
        }
        $this$buildString.append(method);
        $this$buildString.append(args);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    protected JavaCallStackElementRenderer() {
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new JavaCallStackElementRenderer();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer$KERNEL;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "()V", "produce", "Lcom/intellij/ui/JBColor;", "type", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "intellij.profiler.ultimate"})
    private static final class KERNEL
    extends FlameChartColors.ChartColor2ColorScheme {
        public static final KERNEL INSTANCE;

        @NotNull
        protected JBColor produce(@NotNull ColorType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            JBColor base = FlameChartColors.NATIVE.INSTANCE.color(type);
            float[] hsb = Color.RGBtoHSB(base.getRed(), base.getGreen(), base.getBlue(), null);
            int color = Color.HSBtoRGB(0.63f, hsb[1], hsb[2]);
            return new JBColor(color, color);
        }

        private KERNEL() {
            super("Kernel");
        }

        static {
            KERNEL kERNEL;
            INSTANCE = kERNEL = new KERNEL();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer$CPP;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "()V", "produce", "Lcom/intellij/ui/JBColor;", "type", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "intellij.profiler.ultimate"})
    private static final class CPP
    extends FlameChartColors.ChartColor2ColorScheme {
        public static final CPP INSTANCE;

        @NotNull
        protected JBColor produce(@NotNull ColorType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return FlameChartColors.NATIVE.INSTANCE.color(type);
        }

        private CPP() {
            super("Cpp");
        }

        static {
            CPP cPP;
            INSTANCE = cPP = new CPP();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer$Companion;", "", "()V", "INSTANCE", "Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer;", "getINSTANCE", "()Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer;", "intellij.profiler.ultimate"})
    public static final class Companion {
        @NotNull
        public final JavaCallStackElementRenderer getINSTANCE() {
            return INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

