/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javaee.appServers.ex.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.execution.J2EEProcess;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.deployment.JavaeeDeploymentListener;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.J2EEServerEvent;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerStateListener;
import com.intellij.javaee.view.ArtifactSyncTracker;
import com.intellij.javaee.view.ServerProcessState;
import com.intellij.javaee.view.ServersConfigManagerListener;
import com.intellij.javaee.view.ServersStateListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServersConfigManager
implements Disposable {
    private final Project myProject;
    private final ArtifactSyncTracker myArtifactSyncTracker;
    private final Map<CommonModel, ServerData> myServer2Data;
    private final List<ServersConfigManagerListener> myListeners;

    public static ServersConfigManager getInstance(@NotNull Project project) {
        if (project == null) {
            ServersConfigManager.$$$reportNull$$$0(0);
        }
        return (ServersConfigManager)project.getService(ServersConfigManager.class);
    }

    public ServersConfigManager(@NotNull Project project) {
        if (project == null) {
            ServersConfigManager.$$$reportNull$$$0(1);
        }
        this.myServer2Data = new HashMap<CommonModel, ServerData>();
        this.myListeners = ContainerUtil.createConcurrentList();
        this.myProject = project;
        this.myArtifactSyncTracker = new ArtifactSyncTracker(project);
        Disposer.register((Disposable)this, (Disposable)this.myArtifactSyncTracker);
        this.addListener(new ServersStateListener(){

            @Override
            public void serverStateChanged(@NotNull CommonStrategy server) {
                if (server == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((RunDashboardListener)ServersConfigManager.this.myProject.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).configurationChanged((RunConfiguration)server, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/view/ServersConfigManager$1", "serverStateChanged"));
            }
        });
    }

    private void notifyListeners(Consumer<? super ServersConfigManagerListener> notifyOne) {
        for (ServersConfigManagerListener next : this.myListeners) {
            notifyOne.accept(next);
        }
    }

    private void startListeningServer(final CommonStrategy server, J2EEServerInstance serverInstance, ServerData serverData) {
        serverData.instance = serverInstance;
        serverData.serverStateListener = new J2EEServerStateListener(){

            public void serverStateChanged(J2EEServerEvent event) {
                ServersConfigManager.this.updateServerData(server, serverData -> {
                    serverData.connected = event.isStateRunning();
                    ServersConfigManager.this.notifyListeners(listener -> listener.serverConnectStateChanged(server));
                });
            }
        };
        serverInstance.addServerListener(serverData.serverStateListener);
        serverData.deploymentListener = new JavaeeDeploymentListener(){

            public void deploymentStatusChanged(DeploymentModel model, DeploymentStatus newStatus, CommonModel runConfiguration) {
                CommonStrategy serverConfiguration = (CommonStrategy)runConfiguration;
                ServersConfigManager.this.updateServerData(serverConfiguration, serverData -> {
                    ServersConfigManager.this.myArtifactSyncTracker.updateDeploymentSync(serverConfiguration, model, newStatus);
                    ServersConfigManager.this.notifyListeners(listener -> listener.deploymentStatusChangeNotified(serverConfiguration, model));
                });
            }
        };
        DeploymentManagerEx.getInstanceEx((Project)this.myProject).addDeploymentListener(serverInstance, serverData.deploymentListener);
    }

    public void addListener(ServersConfigManagerListener listener) {
        this.myListeners.add(listener);
    }

    @NotNull
    public ServerProcessState getServerProcessState(@NotNull CommonStrategy server) {
        ServerData serverData;
        if (server == null) {
            ServersConfigManager.$$$reportNull$$$0(2);
        }
        ServerProcessState serverProcessState = (serverData = this.myServer2Data.get(server)) == null ? ServerProcessState.STOPPED : serverData.processState;
        if (serverProcessState == null) {
            ServersConfigManager.$$$reportNull$$$0(3);
        }
        return serverProcessState;
    }

    public boolean isConnectedAndRunning(@NotNull CommonStrategy server) {
        ServerData serverData;
        if (server == null) {
            ServersConfigManager.$$$reportNull$$$0(4);
        }
        return (serverData = this.myServer2Data.get(server)) != null && serverData.connected && serverData.processState == ServerProcessState.RUNNING;
    }

    @Nullable
    public J2EEServerInstance getServerInstance(@NotNull CommonStrategy server) {
        ServerData serverData;
        if (server == null) {
            ServersConfigManager.$$$reportNull$$$0(5);
        }
        return (serverData = this.myServer2Data.get(server)) == null ? null : serverData.instance;
    }

    public void onDeploymentSettingsChanged(@NotNull CommonStrategy server) {
        if (server == null) {
            ServersConfigManager.$$$reportNull$$$0(6);
        }
        this.notifyListeners(listener -> listener.serverDeploymentSettingsChanged(server));
    }

    public boolean isArtifactSynced(@NotNull CommonStrategy server, @Nullable Artifact artifact) {
        if (server == null) {
            ServersConfigManager.$$$reportNull$$$0(7);
        }
        return this.myArtifactSyncTracker.isArtifactSynced(server, artifact);
    }

    public void dispose() {
    }

    void updateServersList() {
        this.myArtifactSyncTracker.updateServersList();
    }

    void updateNotSyncedServers(@NotNull CompileContext compileContext) {
        if (compileContext == null) {
            ServersConfigManager.$$$reportNull$$$0(8);
        }
        List<CommonStrategy> notSyncedServers = this.myArtifactSyncTracker.updateNotSyncedServers(compileContext);
        for (CommonStrategy server : notSyncedServers) {
            this.notifyListeners(listener -> listener.serverDeploymentsUnsynced(server));
        }
    }

    void setServerState(@NotNull ExecutionEnvironment env, @NotNull ServerProcessState state) {
        if (env == null) {
            ServersConfigManager.$$$reportNull$$$0(9);
        }
        if (state == null) {
            ServersConfigManager.$$$reportNull$$$0(10);
        }
        this.setServerState(env, state, null);
    }

    void setRunningServerState(@NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
        if (env == null) {
            ServersConfigManager.$$$reportNull$$$0(11);
        }
        if (handler == null) {
            ServersConfigManager.$$$reportNull$$$0(12);
        }
        this.setServerState(env, ServerProcessState.RUNNING, (PairConsumer<CommonStrategy, ServerData>)((PairConsumer)(server, serverData) -> {
            if (handler instanceof J2EEProcess) {
                J2EEServerInstance serverInstance = ((J2EEProcess)handler).getServerInstance();
                this.startListeningServer((CommonStrategy)server, serverInstance, (ServerData)serverData);
            }
        }));
    }

    private void setServerState(@NotNull ExecutionEnvironment env, @NotNull ServerProcessState state, @Nullable PairConsumer<CommonStrategy, ServerData> onSet) {
        RunProfile runProfile;
        if (env == null) {
            ServersConfigManager.$$$reportNull$$$0(13);
        }
        if (state == null) {
            ServersConfigManager.$$$reportNull$$$0(14);
        }
        if (!((runProfile = env.getRunProfile()) instanceof CommonStrategy)) {
            return;
        }
        CommonStrategy server = (CommonStrategy)runProfile;
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
            if (state == ServerProcessState.STOPPED) {
                ServerData serverData = this.myServer2Data.remove(server);
                if (serverData != null && serverData.instance != null) {
                    serverData.instance.removeServerListener(serverData.serverStateListener);
                    DeploymentManagerEx.getInstanceEx((Project)this.myProject).removeDeploymentListener(serverData.instance, serverData.deploymentListener);
                }
            } else {
                ServerData serverData = this.myServer2Data.get(server);
                if (serverData == null) {
                    serverData = new ServerData();
                    this.myServer2Data.put((CommonModel)server, serverData);
                }
                serverData.processState = state;
                if (onSet != null) {
                    onSet.consume((Object)server, (Object)serverData);
                }
            }
            this.notifyListeners(listener -> listener.serverProcessStateChanged(server));
        });
    }

    private void updateServerData(@NotNull CommonStrategy server, @NotNull Consumer<ServerData> updater) {
        if (server == null) {
            ServersConfigManager.$$$reportNull$$$0(15);
        }
        if (updater == null) {
            ServersConfigManager.$$$reportNull$$$0(16);
        }
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
            ServerData serverData = this.myServer2Data.get(server);
            if (serverData != null) {
                updater.accept(serverData);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/view/ServersConfigManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileContext";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/view/ServersConfigManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerProcessState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getServerProcessState";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isConnectedAndRunning";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getServerInstance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onDeploymentSettingsChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isArtifactSynced";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateNotSyncedServers";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setServerState";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setRunningServerState";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateServerData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ServerData {
        ServerProcessState processState = ServerProcessState.STOPPED;
        boolean connected;
        J2EEServerInstance instance;
        J2EEServerStateListener serverStateListener;
        JavaeeDeploymentListener deploymentListener;

        private ServerData() {
        }
    }
}

