/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Couple;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;

public class GrMapTypeImpl
extends GrMapType {
    @NotNull
    private final LinkedHashMap<String, PsiType> myStringEntries;
    @NotNull
    private final List<Couple<PsiType>> myOtherEntries;

    GrMapTypeImpl(JavaPsiFacade facade, GlobalSearchScope scope, @NotNull LinkedHashMap<String, PsiType> stringEntries, @NotNull List<Couple<PsiType>> otherEntries, @NotNull LanguageLevel languageLevel) {
        if (stringEntries == null) {
            GrMapTypeImpl.$$$reportNull$$$0(0);
        }
        if (otherEntries == null) {
            GrMapTypeImpl.$$$reportNull$$$0(1);
        }
        if (languageLevel == null) {
            GrMapTypeImpl.$$$reportNull$$$0(2);
        }
        super(facade, scope, languageLevel);
        this.myStringEntries = stringEntries;
        this.myOtherEntries = otherEntries;
    }

    @Override
    @Nullable
    public PsiType getTypeByStringKey(String key) {
        return this.myStringEntries.get(key);
    }

    @Override
    @NotNull
    public Set<String> getStringKeys() {
        Set<String> set = this.myStringEntries.keySet();
        if (set == null) {
            GrMapTypeImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    protected List<Couple<PsiType>> getOtherEntries() {
        List<Couple<PsiType>> list = this.myOtherEntries;
        if (list == null) {
            GrMapTypeImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    protected LinkedHashMap<String, PsiType> getStringEntries() {
        LinkedHashMap<String, PsiType> linkedHashMap = this.myStringEntries;
        if (linkedHashMap == null) {
            GrMapTypeImpl.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    public boolean isValid() {
        for (PsiType psiType : this.myStringEntries.values()) {
            if (psiType == null || psiType.isValid()) continue;
            return false;
        }
        for (Couple couple : this.myOtherEntries) {
            if (couple.first != null && !((PsiType)couple.first).isValid()) {
                return false;
            }
            if (couple.second == null || ((PsiType)couple.second).isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.myStringEntries.isEmpty() && this.myOtherEntries.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GrMapTypeImpl type2 = (GrMapTypeImpl)((Object)o);
        if (!this.myStringEntries.equals(type2.myStringEntries)) {
            return false;
        }
        return this.myOtherEntries.equals(type2.myOtherEntries);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myStringEntries.hashCode();
        result2 = 31 * result2 + this.myOtherEntries.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringEntries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherEntries";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringKeys";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherEntries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

