/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dgm.GdkMethodHolder;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyCommonClassNames;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public final class DGMMemberContributor {
    public static boolean processDgmMethods(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        GlobalSearchScope scope;
        if (qualifierType == null) {
            DGMMemberContributor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            DGMMemberContributor.$$$reportNull$$$0(1);
        }
        if (place == null) {
            DGMMemberContributor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            DGMMemberContributor.$$$reportNull$$$0(3);
        }
        if (!ResolveUtil.shouldProcessMethods((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            return true;
        }
        Project project = place.getProject();
        ConcurrentMap map2 = (ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap value = ContainerUtil.createConcurrentSoftValueMap();
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        List<GdkMethodHolder> gdkMethods = (List<GdkMethodHolder>)map2.get(scope = place.getResolveScope());
        if (gdkMethods == null) {
            gdkMethods = DGMMemberContributor.calcGdkMethods(project, scope);
            map2.put(scope, gdkMethods);
        }
        for (GdkMethodHolder holder : gdkMethods) {
            if (holder.processMethods(processor, state, qualifierType, project)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<GdkMethodHolder> calcGdkMethods(Project project, GlobalSearchScope resolveScope) {
        PsiClass clazz;
        ArrayList<GdkMethodHolder> gdkMethods = new ArrayList<GdkMethodHolder>();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        Couple<List<String>> extensions = DGMMemberContributor.collectExtensions(project, resolveScope);
        for (String category : (List)extensions.getFirst()) {
            clazz = facade.findClass(category, resolveScope);
            if (clazz == null) continue;
            gdkMethods.add(GdkMethodHolder.getHolderForClass(clazz, false));
        }
        for (String category : (List)extensions.getSecond()) {
            clazz = facade.findClass(category, resolveScope);
            if (clazz == null) continue;
            gdkMethods.add(GdkMethodHolder.getHolderForClass(clazz, true));
        }
        ArrayList<GdkMethodHolder> arrayList = gdkMethods;
        if (arrayList == null) {
            DGMMemberContributor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static Couple<List<String>> collectExtensions(@NotNull Project project, @NotNull GlobalSearchScope resolveScope) {
        if (project == null) {
            DGMMemberContributor.$$$reportNull$$$0(5);
        }
        if (resolveScope == null) {
            DGMMemberContributor.$$$reportNull$$$0(6);
        }
        ArrayList<String> instanceClasses = new ArrayList<String>(GroovyCommonClassNames.DEFAULT_INSTANCE_EXTENSIONS);
        ArrayList<String> staticClasses = new ArrayList<String>(GroovyCommonClassNames.DEFAULT_STATIC_EXTENSIONS);
        DGMMemberContributor.doCollectExtensions(project, resolveScope, instanceClasses, staticClasses, "META-INF.groovy");
        DGMMemberContributor.doCollectExtensions(project, resolveScope, instanceClasses, staticClasses, "META-INF.services");
        Couple couple = Couple.of(instanceClasses, staticClasses);
        if (couple == null) {
            DGMMemberContributor.$$$reportNull$$$0(7);
        }
        return couple;
    }

    private static void doCollectExtensions(@NotNull Project project, @NotNull GlobalSearchScope resolveScope, @NotNull List<String> instanceClasses, @NotNull List<String> staticClasses, @NlsSafe @NotNull String packageName) {
        PsiPackage aPackage;
        if (project == null) {
            DGMMemberContributor.$$$reportNull$$$0(8);
        }
        if (resolveScope == null) {
            DGMMemberContributor.$$$reportNull$$$0(9);
        }
        if (instanceClasses == null) {
            DGMMemberContributor.$$$reportNull$$$0(10);
        }
        if (staticClasses == null) {
            DGMMemberContributor.$$$reportNull$$$0(11);
        }
        if (packageName == null) {
            DGMMemberContributor.$$$reportNull$$$0(12);
        }
        if ((aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName)) == null) {
            return;
        }
        for (PsiDirectory directory : aPackage.getDirectories(resolveScope)) {
            PsiFile file = directory.findFile("org.codehaus.groovy.runtime.ExtensionModule");
            if (!(file instanceof PropertiesFile)) continue;
            AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> {
                IProperty inst = ((PropertiesFile)file).findPropertyByKey("extensionClasses");
                IProperty stat = ((PropertiesFile)file).findPropertyByKey("staticExtensionClasses");
                if (inst != null) {
                    DGMMemberContributor.collectClasses(inst, instanceClasses);
                }
                if (stat != null) {
                    DGMMemberContributor.collectClasses(stat, staticClasses);
                }
            });
        }
    }

    private static void collectClasses(@NotNull IProperty pr, @NotNull List<String> classes2) {
        String value;
        if (pr == null) {
            DGMMemberContributor.$$$reportNull$$$0(13);
        }
        if (classes2 == null) {
            DGMMemberContributor.$$$reportNull$$$0(14);
        }
        if ((value = pr.getUnescapedValue()) == null) {
            return;
        }
        value = value.trim();
        Object[] qnames = value.split("\\s*,\\s*");
        ContainerUtil.addAll(classes2, (Object[])qnames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceClasses";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticClasses";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pr";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcGdkMethods";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDgmMethods";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectExtensions";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doCollectExtensions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

