/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringWebFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        if (module == null) {
            SpringWebFileReferenceHelper.$$$reportNull$$$0(0);
        }
        Collection<PsiFileSystemItem> collection = SpringWebFileReferenceHelper.getWebRoots(module);
        if (collection == null) {
            SpringWebFileReferenceHelper.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            SpringWebFileReferenceHelper.$$$reportNull$$$0(2);
        }
        if (!this.isMine(project, file)) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                SpringWebFileReferenceHelper.$$$reportNull$$$0(3);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                SpringWebFileReferenceHelper.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection<PsiFileSystemItem> collection = SpringWebFileReferenceHelper.getWebRoots(module);
        if (collection == null) {
            SpringWebFileReferenceHelper.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            SpringWebFileReferenceHelper.$$$reportNull$$$0(6);
        }
        if (!DumbService.isDumb((Project)project) && !SpringLibraryUtil.hasSpringLibrary((Project)project)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile)) {
            return SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile));
        }
        if (!(psiFile instanceof PsiClassOwner)) {
            return false;
        }
        if (JspPsiUtil.isInJspFile((PsiElement)psiFile)) {
            return false;
        }
        PsiClassOwner psiClassOwner = (PsiClassOwner)psiFile;
        for (PsiClass psiClass : psiClassOwner.getClasses()) {
            if (!SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass)) continue;
            return true;
        }
        return false;
    }

    private static Collection<PsiFileSystemItem> getWebRoots(Module module) {
        Collection webFacets = WebFacet.getInstances((Module)module);
        if (webFacets.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<PsiFileSystemItem> webRoots = new LinkedHashSet<PsiFileSystemItem>();
        for (WebFacet facet : webFacets) {
            for (WebRoot root : facet.getWebRoots()) {
                VirtualFile rootFile = root.getFile();
                if (rootFile == null) continue;
                WebDirectoryElement webDirectory = WebUtil.getWebUtil().findWebDirectoryByFile(rootFile, facet);
                ContainerUtil.addIfNotNull(webRoots, (Object)webDirectory);
            }
        }
        return webRoots;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/SpringWebFileReferenceHelper";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/SpringWebFileReferenceHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

