/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.project;

import com.intellij.indexing.shared.generate.ConsoleLog;
import com.intellij.indexing.shared.generate.DumpSharedIndexCommand;
import com.intellij.indexing.shared.generate.IndexesExporter;
import com.intellij.indexing.shared.generate.IndexesExporterRequest;
import com.intellij.indexing.shared.license.SharedIndexesLicenseChecker;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.project.DumpProjectArgs;
import com.intellij.indexing.shared.project.ProjectIndexChunk;
import com.intellij.indexing.shared.project.ProjectUtilKt;
import com.intellij.indexing.shared.util.ArgsParser;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/project/DumpProjectIndexesStarter;", "Lcom/intellij/indexing/shared/generate/DumpSharedIndexCommand;", "Lcom/intellij/indexing/shared/project/DumpProjectArgs;", "()V", "commandDescription", "", "getCommandDescription", "()Ljava/lang/String;", "commandName", "getCommandName", "executeCommand", "", "args", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "parseArgs", "parser", "Lcom/intellij/indexing/shared/util/ArgsParser;", "intellij.indexing.shared"})
public final class DumpProjectIndexesStarter
implements DumpSharedIndexCommand<DumpProjectArgs> {
    @NotNull
    private final String commandName;
    @NotNull
    private final String commandDescription;

    @Override
    @NotNull
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public String getCommandDescription() {
        return this.commandDescription;
    }

    @Override
    @NotNull
    public DumpProjectArgs parseArgs(@NotNull ArgsParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        return new DumpProjectArgs(parser);
    }

    @Override
    public void executeCommand(@NotNull DumpProjectArgs args2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!SharedIndexesLicenseChecker.isLicensed()) {
            String string2 = "\n\n" + SharedIndexesBundle.message("console.project.shared.indexes.in.trial.mode", new Object[0]) + "\n\n";
            boolean bl = false;
            System.out.println((Object)string2);
        }
        Project project2 = ProjectUtilKt.importOrOpenProject(args2, indicator);
        ConsoleLog.INSTANCE.info("Collecting files to index...");
        ProjectIndexChunk chunk2 = (ProjectIndexChunk)UtilKt.runAndCatchNotNull("Collecting Project Sources", (Function0)new Function0<ProjectIndexChunk>(project2){
            final /* synthetic */ Project $project;

            @Nullable
            public final ProjectIndexChunk invoke() {
                return new ProjectIndexChunk(this.$project);
            }
            {
                this.$project = project2;
                super(0);
            }
        });
        ConsoleLog.INSTANCE.info("Indexing " + chunk2 + "...");
        IndexesExporterRequest indexesExporterRequest = args2.indexesExporterRequest(chunk2);
        ProgressIndicator progressIndicator = indicator;
        IndexesExporter.exportIndexesChunk(project2, indexesExporterRequest, progressIndicator);
    }

    public DumpProjectIndexesStarter() {
        this.commandName = "project";
        this.commandDescription = "Generates shared index for a given project";
    }
}

