/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.IndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StubSharedIndexExtension
implements SharedIndexExtension<Integer, SerializedStubTree> {
    private static final Logger LOG = Logger.getInstance(StubSharedIndexExtension.class);
    private volatile StubUpdatingIndex myStubUpdatingIndex;
    private volatile SerializationManagerImpl mySerializationManager;
    private volatile SimpleStringPersistentEnumerator myIndexIdEnumerator;
    private volatile StubBuilderVersionFilter myStubBuilderVersionFilter;

    @Override
    public void openResources(@NotNull Path indexRoot, boolean readOnly, @NotNull IndexInfrastructureVersion chunkVersion) {
        if (indexRoot == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(0);
        }
        if (chunkVersion == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(1);
        }
        this.mySerializationManager = new SerializationManagerImpl(StubSharedIndexExtension.getStubSerializerNamesStorageFile(indexRoot), readOnly);
        this.myIndexIdEnumerator = new SimpleStringPersistentEnumerator(indexRoot.resolve("stubIndexIds.txt"));
        this.myStubUpdatingIndex = new StubUpdatingIndex((StubForwardIndexExternalizer)new StubForwardIndexExternalizer<Void>(){

            protected Void createStubIndexKeySerializationState(@NotNull DataOutput out, @NotNull Set<StubIndexKey<?, ?>> set) {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (set == null) {
                    1.$$$reportNull$$$0(1);
                }
                return null;
            }

            protected void writeStubIndexKey(@NotNull DataOutput out, @NotNull StubIndexKey key, Void unused) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (key == null) {
                    1.$$$reportNull$$$0(3);
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)StubSharedIndexExtension.this.myIndexIdEnumerator.enumerate(key.getName()));
            }

            protected Void createStubIndexKeySerializationState(@NotNull DataInput input, int stubIndexKeyCount) {
                if (input == null) {
                    1.$$$reportNull$$$0(4);
                }
                return null;
            }

            protected ID<?, ?> readStubIndexKey(@NotNull DataInput input, Void unused) throws IOException {
                int indexId2;
                if (input == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((indexId2 = DataInputOutputUtil.readINT((DataInput)input)) > Short.MAX_VALUE) {
                    throw new IOException("invalid index id");
                }
                String name = StubSharedIndexExtension.this.myIndexIdEnumerator.valueOf((short)indexId2);
                if (name == null) {
                    throw new IOException("name can't be found for id");
                }
                ID id = ID.findByName((String)name);
                if (!(id instanceof StubIndexKey)) {
                    LOG.warn("id with name `" + name + "`, enumerated id " + indexId2 + " is not " + (id == null ? "found" : "a StubIndexKey"));
                    return null;
                }
                return id;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "set";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "input";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createStubIndexKeySerializationState";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "writeStubIndexKey";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "readStubIndexKey";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (SerializationManagerEx)this.mySerializationManager);
        this.myStubBuilderVersionFilter = readOnly ? new StubBuilderVersionFilter(chunkVersion) : null;
    }

    @Override
    public boolean acceptsInputFile(@NotNull IndexedFile file2) {
        if (file2 == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(2);
        }
        return this.myStubBuilderVersionFilter.acceptsFileType(file2.getFileType());
    }

    @Override
    public void closeResources() {
        Disposer.dispose((Disposable)this.mySerializationManager);
    }

    @Override
    @NotNull
    public FileBasedIndexExtension<Integer, SerializedStubTree> getFileBasedIndexExtension() {
        StubUpdatingIndex stubUpdatingIndex = this.myStubUpdatingIndex;
        if (stubUpdatingIndex == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(3);
        }
        return stubUpdatingIndex;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @NotNull
    private static Path getStubSerializerNamesStorageFile(@NotNull Path stubIndexesRoot) {
        if (stubIndexesRoot == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(4);
        }
        Path path = stubIndexesRoot.resolve("serializerNames").resolve("names");
        if (path == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(5);
        }
        return path;
    }

    @NotNull
    public static String getStubFileElementTypeKey(@NotNull IFileElementType fileNodeType) {
        if (fileNodeType == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(6);
        }
        String externalId = ((IStubFileElementType)fileNodeType).getExternalId();
        String string2 = externalId + ":" + fileNodeType.getLanguage().getID();
        if (string2 == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(7);
        }
        return string2;
    }

    public static int getStubFileElementBaseVersion(@NotNull IStubFileElementType<?> fileNodeType) {
        if (fileNodeType == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(8);
        }
        int stubVersion = fileNodeType.getStubVersion();
        return fileNodeType.getLanguage() instanceof TemplateLanguage ? stubVersion - IStubFileElementType.getTemplateStubBaseVersion() : stubVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexesRoot";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNodeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubSerializerNamesStorageFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubFileElementTypeKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openResources";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInputFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStubSerializerNamesStorageFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStubFileElementTypeKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStubFileElementBaseVersion";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StubBuilderVersionFilter {
        @NotNull
        private final Map<String, String> myVersions;
        @NotNull
        private final Map<FileType, Boolean> myResolutionMap;

        private StubBuilderVersionFilter(@NotNull IndexInfrastructureVersion chunkVersion) {
            if (chunkVersion == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(0);
            }
            this.myVersions = chunkVersion.getStubFileElementTypeVersions();
            this.myResolutionMap = ConcurrentFactoryMap.createMap(fileType -> {
                if (!(fileType instanceof LanguageFileType)) {
                    return Boolean.TRUE;
                }
                Language language = ((LanguageFileType)fileType).getLanguage();
                if (StubBuilderVersionFilter.isJsOrDialect(language)) {
                    return true;
                }
                ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
                if (parserDefinition == null) {
                    return Boolean.TRUE;
                }
                IFileElementType fileNodeType = parserDefinition.getFileNodeType();
                if (!(fileNodeType instanceof IStubFileElementType)) {
                    return Boolean.TRUE;
                }
                String key = StubSharedIndexExtension.getStubFileElementTypeKey(fileNodeType);
                int version = StubSharedIndexExtension.getStubFileElementBaseVersion((IStubFileElementType)fileNodeType);
                return String.valueOf(version).equals(this.myVersions.get(key));
            });
        }

        boolean acceptsFileType(@NotNull FileType fileType) {
            if (fileType == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(1);
            }
            return this.myResolutionMap.get(fileType);
        }

        private static boolean isJsOrDialect(@NotNull Language language) {
            Language baseLanguage;
            if (language == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(2);
            }
            if ((baseLanguage = language.getBaseLanguage()) != null) {
                language = baseLanguage;
            }
            return language.getID().equals("JavaScript");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunkVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension$StubBuilderVersionFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptsFileType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isJsOrDialect";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

