/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.IdeIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.api.SharedIndexStorage;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SingleChunkReadonlyZipStorage;", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStorage;", "chunkId", "", "storagePath", "Ljava/nio/file/Path;", "storageId", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;)V", "getChunkId", "()Ljava/lang/String;", "chunkRoot", "Lorg/jetbrains/annotations/NotNull;", "getChunkRoot", "()Ljava/nio/file/Path;", "metadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "readSystem", "Lcom/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystem;", "getStorageId", "close", "", "getSharedIndexStats", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "isCompatibleChunk", "", "toString", "intellij.indexing.shared"})
public final class SingleChunkReadonlyZipStorage
implements SharedIndexStorage {
    private final UncompressedZipFileSystem readSystem;
    private final SharedIndexMetadata metadata;
    @NotNull
    private final String chunkId;
    private final Path storagePath;
    @NotNull
    private final String storageId;

    private final Path getChunkRoot() {
        Path path = this.readSystem.getRootDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"readSystem.rootDirectory");
        return path;
    }

    @Override
    @NotNull
    public SharedIndexStats getSharedIndexStats() {
        return new SharedIndexStats(Files.size(this.storagePath), 1);
    }

    @Override
    public boolean isCompatibleChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return Intrinsics.areEqual((Object)chunkId, (Object)this.chunkId) && this.metadata != null && IdeIndexInfrastructureVersion.getIdeVersion().isSuitableVersion(this.metadata.getIndexInfrastructureVersion());
    }

    @Override
    @Nullable
    public Path getChunkRoot(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return Intrinsics.areEqual((Object)chunkId, (Object)this.chunkId) ? this.getChunkRoot() : null;
    }

    @Override
    public void close() {
        this.readSystem.close();
    }

    @NotNull
    public String toString() {
        return "SingleChunkReadonlyZipStorage(chunkId='" + this.chunkId + "', storagePath=" + this.storagePath + ')';
    }

    @NotNull
    public final String getChunkId() {
        return this.chunkId;
    }

    @Override
    @NotNull
    public String getStorageId() {
        return this.storageId;
    }

    public SingleChunkReadonlyZipStorage(@NotNull String chunkId, @NotNull Path storagePath, @NotNull String storageId2) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
        Intrinsics.checkNotNullParameter((Object)storageId2, (String)"storageId");
        this.chunkId = chunkId;
        this.storagePath = storagePath;
        this.storageId = storageId2;
        UncompressedZipFileSystem uncompressedZipFileSystem = UncompressedZipFileSystem.create(this.storagePath);
        Intrinsics.checkNotNullExpressionValue((Object)uncompressedZipFileSystem, (String)"UncompressedZipFileSystem.create(storagePath)");
        this.readSystem = uncompressedZipFileSystem;
        this.metadata = SharedIndexMetadata.Companion.readIndexesVersion(this.getChunkRoot());
    }

    @Override
    public boolean containsChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return SharedIndexStorage.DefaultImpls.containsChunk(this, chunkId);
    }
}

