/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.MutableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexStorageProvider;
import com.intellij.indexing.shared.platform.impl.BundledSharedIndexesResolver;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.indexing.shared.platform.impl.SharedIndexZipCompositeStorage;
import com.intellij.indexing.shared.platform.impl.SharedIndexZipStorage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexZipStorageProvider;", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStorageProvider;", "Lcom/intellij/indexing/shared/platform/api/MutableSharedIndexStorage;", "()V", "tryOpenOrResetIfFailed", "corruptionHandler", "Ljava/lang/Runnable;", "intellij.indexing.shared"})
public final class SharedIndexZipStorageProvider
implements SharedIndexStorageProvider<MutableSharedIndexStorage> {
    public static final SharedIndexZipStorageProvider INSTANCE;

    @Override
    @NotNull
    public MutableSharedIndexStorage tryOpenOrResetIfFailed(@NotNull Runnable corruptionHandler) throws IOException {
        Intrinsics.checkNotNullParameter((Object)corruptionHandler, (String)"corruptionHandler");
        Path storagePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve("chunks.zip");
        SharedIndexZipStorage mutableStorage2 = (SharedIndexZipStorage)IOUtil.openCleanOrResetBroken((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<SharedIndexZipStorage, IOException>(storagePath){
            final /* synthetic */ Path $storagePath;

            public final SharedIndexZipStorage compute() {
                Path path = this.$storagePath;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"storagePath");
                return new SharedIndexZipStorage(path, "shared index central storage");
            }
            {
                this.$storagePath = path;
            }
        }), (Runnable)new Runnable(corruptionHandler, storagePath){
            final /* synthetic */ Runnable $corruptionHandler;
            final /* synthetic */ Path $storagePath;

            public final void run() {
                this.$corruptionHandler.run();
                FileUtil.delete((Path)this.$storagePath);
            }
            {
                this.$corruptionHandler = runnable;
                this.$storagePath = path;
            }
        });
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(BundledSharedIndexesResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        List<SharedIndexStorage> bundledIndexes = ((BundledSharedIndexesResolver)object).openBundledStorages();
        if (bundledIndexes.isEmpty()) {
            SharedIndexZipStorage sharedIndexZipStorage = mutableStorage2;
            Intrinsics.checkNotNullExpressionValue((Object)sharedIndexZipStorage, (String)"mutableStorage");
            return sharedIndexZipStorage;
        }
        SharedIndexZipStorage sharedIndexZipStorage = mutableStorage2;
        Intrinsics.checkNotNullExpressionValue((Object)sharedIndexZipStorage, (String)"mutableStorage");
        return new SharedIndexZipCompositeStorage(sharedIndexZipStorage, bundledIndexes);
    }

    private SharedIndexZipStorageProvider() {
    }

    static {
        SharedIndexZipStorageProvider sharedIndexZipStorageProvider;
        INSTANCE = sharedIndexZipStorageProvider = new SharedIndexZipStorageProvider();
    }
}

