/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexProjectIndexingHistoryListener;", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener;", "()V", "onFinishedIndexing", "", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "intellij.indexing.shared"})
public final class SharedIndexProjectIndexingHistoryListener
implements IndexDiagnosticDumper.ProjectIndexingHistoryListener {
    /*
     * WARNING - void declaration
     */
    public void onFinishedIndexing(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        JsonFileProviderIndexStatistics it;
        Iterable $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        if (projectIndexingHistory.getTimes().getWasInterrupted()) {
            return;
        }
        Iterable $this$map$iv = projectIndexingHistory.getScanningStatistics();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            JsonScanningStatistics jsonScanningStatistics = (JsonScanningStatistics)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it2.getNumberOfScannedFiles() + it2.getNumberOfFilesFullyIndexedByInfrastructureExtensions() - it2.getNumberOfUpToDateFiles();
            collection.add(object);
        }
        int totalNumberOfIndexedFiles = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
        if (totalNumberOfIndexedFiles < 100) {
            return;
        }
        Duration duration = projectIndexingHistory.getTimes().getIndexingDuration();
        if (duration == null) {
            return;
        }
        Duration indexingDuration = duration;
        if (indexingDuration.compareTo(Duration.ofSeconds(20L)) <= 0) {
            return;
        }
        Iterable $this$map$iv2 = projectIndexingHistory.getScanningStatistics();
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsonScanningStatistics jsonScanningStatistics = (JsonScanningStatistics)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.getNumberOfFilesFullyIndexedByInfrastructureExtensions();
            collection.add(object);
        }
        $this$map$iv2 = projectIndexingHistory.getProviderStatistics();
        int n = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv2));
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (JsonFileProviderIndexStatistics)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Integer n2 = it.getTotalNumberOfFilesFullyIndexedByExtensions();
            object.add(n2);
        }
        object = (List)destination$iv$iv2;
        int totalNumberOfFilesFullyIndexedByInfrastructureExtensions = n + CollectionsKt.sumOfInt((Iterable)((Iterable)object));
        if (totalNumberOfFilesFullyIndexedByInfrastructureExtensions < 100) {
            return;
        }
        String string2 = SharedIndexesBundle.message("eventLog.indexing.completed", NlsMessages.formatDurationApproximate((long)(indexingDuration.toMillis() / (long)1000 * (long)1000)), totalNumberOfFilesFullyIndexedByInfrastructureExtensions, totalNumberOfIndexedFiles, (int)((double)totalNumberOfFilesFullyIndexedByInfrastructureExtensions / (double)totalNumberOfIndexedFiles * (double)100));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SharedIndexesBundle.mess\u2026iles * 100).toInt()\n    )");
        String messageText2 = string2;
        NotificationGroupManager.getInstance().getNotificationGroup("Shared Indexing Log").createNotification(NotificationType.INFORMATION).setContent(messageText2).notify(projectIndexingHistory.getProject());
    }
}

