/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.MergedInvertedIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.UpdatableIndex;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SharedIndexInfrastructure
implements FileBasedIndexInfrastructureExtension {
    static final int SHARED_INDEX_INFRASTRUCTURE_VERSION = 4;
    private static final String SHARED_INDEX_INFRASTRUCTURE_VERSION_PROP = "shared.index.infrastructure.prop";
    private static final boolean SHARED_INDEX_USES_METADATA_HASHES = SystemProperties.getBooleanProperty((String)"shared.index.uses.metadata.hashes", (boolean)true);
    private static final Logger LOG = Logger.getInstance(SharedIndexInfrastructure.class);

    public FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor createFileIndexingStatusProcessor(final @NotNull Project project2) {
        if (project2 == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(0);
        }
        return new FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor(){
            private final IntSet myAttachedChunks = new IntOpenHashSet();
            private final Set<IndexChunk> myInvalidatedChunkIndexes = new HashSet<IndexChunk>();
            private final FileBasedIndexImpl myFileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();

            public boolean hasIndexForFile(@NotNull VirtualFile file2, int inputId, @NotNull FileBasedIndexExtension<?, ?> extension2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (extension2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!extension2.dependsOnFileContent()) {
                    return false;
                }
                int chunkId = FileContentHashIndex.getFileContentHashIndex(extension2.getName()).getAssociatedChunkId(inputId, file2);
                return chunkId != -1 && SharedIndexChunkConfiguration.getInstance().hasSharedIndex(extension2.getName(), chunkId);
            }

            public boolean shouldProcessUpToDateFiles() {
                return SharedIndexChunkConfiguration.getInstance().hasAnyChunk();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean processUpToDateFile(@NotNull IndexedFile file2, int inputId, @NotNull ID<?, ?> indexId2) {
                boolean isInvalidatedChunk;
                Set<IndexChunk> set;
                boolean shouldAttach;
                int chunkId;
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (indexId2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((chunkId = FileContentHashIndex.getFileContentHashIndex(indexId2).getAssociatedChunkId(inputId, file2.getFile())) == -1) {
                    return true;
                }
                IntSet intSet = this.myAttachedChunks;
                synchronized (intSet) {
                    shouldAttach = this.myAttachedChunks.add(chunkId);
                }
                if (shouldAttach) {
                    Collection<ID<?, ?>> attachedChunkIndexIds = SharedIndexChunkConfiguration.getInstance().attachExistingChunk(chunkId, project2);
                    Collection allContentDependentIndexes = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getContentDependentIndexes();
                    set = this.myInvalidatedChunkIndexes;
                    synchronized (set) {
                        for (ID id : allContentDependentIndexes) {
                            if (attachedChunkIndexIds.contains(id)) continue;
                            this.myInvalidatedChunkIndexes.add(new IndexChunk(chunkId, id));
                        }
                    }
                }
                IndexChunk chunk2 = new IndexChunk(chunkId, indexId2);
                set = this.myInvalidatedChunkIndexes;
                synchronized (set) {
                    isInvalidatedChunk = this.myInvalidatedChunkIndexes.contains(chunk2);
                }
                boolean isSharedIndexAcceptable = SharedIndexChunkConfiguration.getInstance().isSharedIndexAcceptable(indexId2, chunkId, file2);
                if (isInvalidatedChunk || !isSharedIndexAcceptable) {
                    FileContentHashIndex.getFileContentHashIndex(indexId2).mapInputAndPrepareUpdate(inputId, null).compute();
                    this.myFileBasedIndex.dropNontrivialIndexedStates(inputId, indexId2);
                    return false;
                }
                return true;
            }

            public boolean tryIndexFileWithoutContent(@NotNull IndexedFile file2, int inputId, @NotNull ID<?, ?> indexId2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (indexId2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                return SHARED_INDEX_USES_METADATA_HASHES && ((MergedInvertedIndex)this.myFileBasedIndex.getIndex(indexId2)).tryIndexWithoutContent(inputId, file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indexId";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/SharedIndexInfrastructure$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasIndexForFile";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processUpToDateFile";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "tryIndexFileWithoutContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public <K, V> UpdatableIndex<K, V, FileContent> combineIndex(@NotNull FileBasedIndexExtension<K, V> indexExtension, @NotNull UpdatableIndex<K, V, FileContent> baseIndex) throws IOException {
        if (indexExtension == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(1);
        }
        if (baseIndex == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(2);
        }
        return indexExtension.dependsOnFileContent() ? new MergedInvertedIndex<K, V>(indexExtension.getName(), baseIndex) : null;
    }

    public void onFileBasedIndexVersionChanged(@NotNull ID<?, ?> indexId2) {
        if (indexId2 == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(3);
        }
    }

    public void onStubIndexVersionChanged(@NotNull StubIndexKey<?, ?> indexId2) {
        if (indexId2 == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public synchronized FileBasedIndexInfrastructureExtension.InitializationResult initialize() {
        FileBasedIndexInfrastructureExtension.InitializationResult result2 = SharedIndexChunkConfiguration.getInstance().initialize();
        int version = PropertiesComponent.getInstance().getInt(SHARED_INDEX_INFRASTRUCTURE_VERSION_PROP, 0);
        if (version != 4) {
            LOG.info("Shared index version updated from " + version + " to 4");
            PropertiesComponent.getInstance().setValue(SHARED_INDEX_INFRASTRUCTURE_VERSION_PROP, String.valueOf(4));
            if (result2 != FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED) {
                result2 = FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED;
            }
        }
        FileBasedIndexInfrastructureExtension.InitializationResult initializationResult = result2;
        if (initializationResult == null) {
            SharedIndexInfrastructure.$$$reportNull$$$0(5);
        }
        return initializationResult;
    }

    public void clearPersistentData() {
        FileUtil.deleteWithRenaming((File)SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().toFile());
        LOG.info("Shared index persistent data has been cleared");
    }

    public synchronized void shutdown() {
        SharedIndexInfrastructure.runSafe(() -> SharedIndexChunkConfiguration.getInstance().shutdown());
    }

    public int getVersion() {
        return 4;
    }

    private static void runSafe(Runnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndex";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/SharedIndexInfrastructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/SharedIndexInfrastructure";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileIndexingStatusProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "combineIndex";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onFileBasedIndexVersionChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onStubIndexVersionChanged";
                break;
            }
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IndexChunk {
        private final int myChunkId;
        private final ID<?, ?> myIndexId;

        private IndexChunk(int id, ID<?, ?> indexId2) {
            this.myChunkId = id;
            this.myIndexId = indexId2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexChunk chunk2 = (IndexChunk)o;
            if (this.myChunkId != chunk2.myChunkId) {
                return false;
            }
            return Objects.equals(this.myIndexId, chunk2.myIndexId);
        }

        public int hashCode() {
            int result2 = this.myChunkId;
            result2 = 31 * result2 + (this.myIndexId != null ? this.myIndexId.hashCode() : 0);
            return result2;
        }
    }
}

