/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.AttachChunkResult;
import com.intellij.indexing.shared.platform.api.ChunkDescriptor;
import com.intellij.indexing.shared.platform.api.ChunkDownloader;
import com.intellij.indexing.shared.platform.api.MutableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.impl.BundledSharedIndexesResolver;
import com.intellij.indexing.shared.platform.impl.ChunkManager;
import com.intellij.indexing.shared.platform.impl.DownloadIndexResult;
import com.intellij.indexing.shared.platform.impl.EmptyIndex;
import com.intellij.indexing.shared.platform.impl.ExcludedChunkList;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.HashBasedMapReduceIndex;
import com.intellij.indexing.shared.platform.impl.HashSuppliedIndexedFile;
import com.intellij.indexing.shared.platform.impl.SharedIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.indexing.shared.platform.impl.SharedIndexStorageUtil;
import com.intellij.indexing.shared.platform.impl.SharedIndexZipStorageProvider;
import com.intellij.indexing.shared.platform.impl.SharedIndexesFusCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SharedIndexChunkConfigurationImpl
implements SharedIndexChunkConfiguration,
Disposable {
    private static final Logger LOG = Logger.getInstance(SharedIndexChunkConfigurationImpl.class);
    private final ReadWriteLock myConfigurationLock = new ReentrantReadWriteLock();
    @Nullable
    private FileBasedIndexInfrastructureExtension.InitializationResult myInitialized;
    private ChunkManager myChunkManager;
    private SimpleStringPersistentEnumerator myChunkDescriptorEnumerator;
    private Map<ID<?, ?>, Map<Integer, SharedIndex<?, ?>>> myChunkMap;
    private MutableSharedIndexStorage mySharedIndexStorage;
    private final Map<Project, Long> myProjectStructureStamps = Collections.synchronizedMap(new WeakHashMap());
    private final ExcludedChunkList myExcludedChunkList = new ExcludedChunkList(SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot());

    public SharedIndexChunkConfigurationImpl() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosed(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                SharedIndexChunkConfigurationImpl.this.myConfigurationLock.writeLock().lock();
                try {
                    if (SharedIndexChunkConfigurationImpl.this.myInitialized != null) {
                        List<Integer> closedChunkIds = SharedIndexChunkConfigurationImpl.this.myChunkManager.disposeChunks(project2);
                        for (Map<Integer, SharedIndex<?, ?>> sharedIndexes : SharedIndexChunkConfigurationImpl.this.myChunkMap.values()) {
                            for (int id : closedChunkIds) {
                                IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{sharedIndexes.remove(id)});
                            }
                        }
                    }
                }
                finally {
                    SharedIndexChunkConfigurationImpl.this.myConfigurationLock.writeLock().unlock();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/indexing/shared/platform/impl/SharedIndexChunkConfigurationImpl$1", "projectClosed"));
            }
        });
    }

    public void dispose() {
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull FileBasedIndexInfrastructureExtension.InitializationResult initialize() {
        this.myConfigurationLock.writeLock().lock();
        if (this.myInitialized == null) {
            Ref result2 = Ref.create((Object)FileBasedIndexInfrastructureExtension.InitializationResult.SUCCESSFULLY);
            this.myChunkManager = new ChunkManager();
            this.myChunkMap = new HashMap();
            this.myChunkDescriptorEnumerator = new SimpleStringPersistentEnumerator(SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve("descriptors"));
            try {
                this.mySharedIndexStorage = SharedIndexZipStorageProvider.INSTANCE.tryOpenOrResetIfFailed(() -> result2.set((Object)FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED));
            }
            catch (IOException e) {
                LOG.error("Failed to initialize shared indexes infrastructure", (Throwable)e);
                result2.set((Object)FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED);
                this.shutdown();
            }
            this.myInitialized = (FileBasedIndexInfrastructureExtension.InitializationResult)result2.get();
        }
        FileBasedIndexInfrastructureExtension.InitializationResult initializationResult = this.myInitialized;
        FileBasedIndexInfrastructureExtension.InitializationResult initializationResult2 = initializationResult;
        if (initializationResult2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(0);
        }
        return initializationResult2;
        finally {
            this.myConfigurationLock.writeLock().unlock();
        }
    }

    @Override
    public void shutdown() {
        this.myConfigurationLock.writeLock().lock();
        try {
            if (this.myInitialized != null) {
                Set<Integer> disposedChunkIds = this.myChunkManager.disposeChunks();
                this.myChunkManager = null;
                this.myChunkDescriptorEnumerator = null;
                SharedIndexChunkConfigurationImpl.shutDownChunks(this.myChunkMap, disposedChunkIds);
                this.myChunkMap = null;
                this.myProjectStructureStamps.clear();
                this.myInitialized = null;
                IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySharedIndexStorage});
                this.mySharedIndexStorage = null;
            }
        }
        finally {
            this.myConfigurationLock.writeLock().unlock();
        }
        LOG.info("Shared index chunks shutdown was performed successful");
    }

    @Override
    public boolean hasAnyChunk() {
        this.myConfigurationLock.readLock().lock();
        try {
            if (this.myInitialized == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mySharedIndexStorage.getSharedIndexStats().getChunks() > 0 || !this.myChunkDescriptorEnumerator.isEmpty() || this.myChunkManager.getOpenChunkIds().size() > 0;
            return bl;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    @Override
    public boolean isSharedIndexAcceptable(@NotNull ID<?, ?> indexId2, int chunkId, @NotNull IndexedFile indexedFile) {
        if (indexId2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(1);
        }
        if (indexedFile == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(2);
        }
        Boolean result2 = this.querySharedIndex(indexId2, chunkId, index2 -> {
            if (index2 instanceof HashBasedMapReduceIndex) {
                return ((HashBasedMapReduceIndex)index2).acceptsFile(indexedFile);
            }
            if (index2 instanceof EmptyIndex) {
                return true;
            }
            return false;
        });
        return Boolean.TRUE.equals(result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Key, Value> boolean hasSharedIndex(@NotNull ID<Key, Value> indexId2, int chunkId) {
        if (indexId2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(3);
        }
        this.myConfigurationLock.readLock().lock();
        try {
            if (this.myInitialized == null) {
                boolean bl = false;
                return bl;
            }
            Map<Integer, SharedIndex<?, ?>> map2 = this.myChunkMap.get(indexId2);
            boolean bl = map2 != null && map2.containsKey(chunkId);
            return bl;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Key, Value, E extends Exception> boolean processSharedIndexes(@NotNull ID<Key, Value> indexId2, @NotNull SharedIndexChunkConfiguration.SharedIndexProcessor<Key, Value, E> processor) throws E {
        if (indexId2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(5);
        }
        this.myConfigurationLock.readLock().lock();
        try {
            if (this.myInitialized == null) {
                boolean bl = true;
                return bl;
            }
            Map<Integer, SharedIndex<?, ?>> map2 = this.myChunkMap.get(indexId2);
            if (map2 == null) {
                boolean bl = true;
                return bl;
            }
            for (SharedIndex<?, ?> sharedIndex : map2.values()) {
                if (processor.process(sharedIndex.getIndex())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <Key, Value, Result, E extends Exception> Result querySharedIndex(@NotNull ID<Key, Value> indexId2, int chunkId, @NotNull SharedIndexChunkConfiguration.SharedIndexQuery<Key, Value, Result, E> query) throws E {
        if (indexId2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(6);
        }
        if (query == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(7);
        }
        this.myConfigurationLock.readLock().lock();
        try {
            if (this.myInitialized == null) {
                Result Result = null;
                return Result;
            }
            Map<Integer, SharedIndex<?, ?>> chunkToIndex = this.myChunkMap.get(indexId2);
            if (chunkToIndex == null) {
                Result Result = null;
                return Result;
            }
            SharedIndex<?, ?> sharedIndex = chunkToIndex.get(chunkId);
            if (sharedIndex == null) {
                Result Result = null;
                return Result;
            }
            Result Result = query.calculate(sharedIndex.getIndex());
            return Result;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tryEnumerateContentHash(@NotNull IndexedFile indexedFile) {
        if (indexedFile == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(8);
        }
        if (indexedFile instanceof HashSuppliedIndexedFile) {
            return ((HashSuppliedIndexedFile)indexedFile).getHashId();
        }
        this.myConfigurationLock.readLock().lock();
        try {
            if (this.myInitialized == null) {
                long l = FileContentHashIndexExtension.NULL_HASH_ID;
                return l;
            }
            long l = this.myChunkManager.tryEnumerateContentHash(indexedFile);
            return l;
        }
        catch (IOException t) {
            LOG.debug("Failed to compute hash for " + indexedFile + ". " + t.getMessage(), (Throwable)t);
            long l = FileContentHashIndexExtension.NULL_HASH_ID;
            return l;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public DownloadIndexResult downloadIndex(@NotNull ChunkDescriptor descriptor, @Nullable Project project2, @NotNull ProgressIndicator indicator) {
        DownloadIndexResult outcome;
        if (descriptor == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(10);
        }
        this.initialize();
        String chunkUniqueId = descriptor.getChunkUniqueId();
        Boolean isDownloadNeeded = this.isDownloadNeeded(chunkUniqueId);
        if (isDownloadNeeded == null) {
            DownloadIndexResult downloadIndexResult = DownloadIndexResult.FAILED;
            if (downloadIndexResult == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(11);
            }
            return downloadIndexResult;
        }
        if (isDownloadNeeded.booleanValue()) {
            indicator.pushState();
            try {
                indicator.setIndeterminate(true);
                if (!this.doDownloadIndex(chunkUniqueId, descriptor, indicator, project2)) {
                    DownloadIndexResult downloadIndexResult = DownloadIndexResult.FAILED;
                    DownloadIndexResult downloadIndexResult2 = downloadIndexResult;
                    if (downloadIndexResult2 == null) {
                        SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(12);
                    }
                    return downloadIndexResult2;
                }
                outcome = DownloadIndexResult.JUST_DOWNLOADED;
            }
            finally {
                indicator.popState();
            }
        } else {
            outcome = DownloadIndexResult.ALREADY_EXISTS;
        }
        if (project2 != null) {
            AttachChunkResult attachResult = this.openChunkForProject(chunkUniqueId, project2, indicator);
            String kind2 = descriptor.getKind();
            if (attachResult != null) {
                SharedIndexesFusCollector.INSTANCE.reportIndexAttached(project2, kind2, chunkUniqueId, attachResult);
            }
            if (attachResult == null || !attachResult.isSuccess()) {
                DownloadIndexResult downloadIndexResult = DownloadIndexResult.FAILED;
                if (downloadIndexResult == null) {
                    SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(13);
                }
                return downloadIndexResult;
            }
        }
        DownloadIndexResult downloadIndexResult = outcome;
        if (downloadIndexResult == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(14);
        }
        return downloadIndexResult;
    }

    @Nullable
    private Boolean isDownloadNeeded(@NotNull String chunkUniqueId) {
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(15);
        }
        try {
            this.myConfigurationLock.readLock().lock();
            if (this.myInitialized == null) {
                Boolean bl = null;
                return bl;
            }
            Boolean bl = !this.mySharedIndexStorage.containsChunk(chunkUniqueId);
            return bl;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDownloadIndex(@NotNull String chunkUniqueId, @NotNull ChunkDownloader descriptor, @NotNull ProgressIndicator indicator, @Nullable Project project2) {
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(16);
        }
        if (descriptor == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(18);
        }
        Path chunkTempFile = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve("downloading").resolve(chunkUniqueId + "_" + System.currentTimeMillis() + "_temp.zip");
        try {
            long startTime;
            block22: {
                startTime = System.currentTimeMillis();
                File parentChunkFile = chunkTempFile.toFile().getParentFile();
                if (parentChunkFile != null) {
                    parentChunkFile.mkdirs();
                }
                if (!descriptor.downloadChunk(chunkTempFile, project2, indicator)) {
                    LOG.debug("Failed to download shared index " + descriptor + ".");
                    boolean bl = false;
                    return bl;
                }
                try {
                    LOG.info("Chunk " + chunkUniqueId + " is downloaded in " + (System.currentTimeMillis() - startTime) + " ms");
                }
                catch (Throwable e) {
                    if (e instanceof ControlFlowException) {
                        ExceptionUtil.rethrow((Throwable)e);
                    }
                    LOG.warn("Failed to download shared index " + descriptor + ". " + e.getMessage(), e);
                    boolean bl = false;
                    return bl;
                }
                indicator.setText(SharedIndexesBundle.message("configuring.shared.indexes", new Object[0]));
                this.myConfigurationLock.writeLock().lock();
                if (this.myInitialized != null) break block22;
                boolean e = false;
                this.myConfigurationLock.writeLock().unlock();
                return e;
            }
            try {
                startTime = System.currentTimeMillis();
                this.mySharedIndexStorage.appendChunk(chunkTempFile, chunkUniqueId);
                LOG.info("Chunk " + chunkUniqueId + " is appended into the store in " + (System.currentTimeMillis() - startTime) + " ms");
                this.myConfigurationLock.writeLock().unlock();
            }
            catch (Throwable e) {
                boolean bl;
                try {
                    if (e instanceof ControlFlowException) {
                        ExceptionUtil.rethrow((Throwable)e);
                    }
                    LOG.error("Failed to attach shared index " + descriptor + ". " + e.getMessage(), e);
                    bl = false;
                    FileUtil.delete((File)chunkTempFile.toFile());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.myConfigurationLock.writeLock().unlock();
                }
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            FileUtil.delete((File)chunkTempFile.toFile());
        }
    }

    @Override
    public boolean attachExistingChunk(@NotNull Project project2, @NotNull String chunkUniqueId) {
        AttachChunkResult result2;
        if (project2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(19);
        }
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(20);
        }
        return (result2 = this.openChunkForProject(chunkUniqueId, project2, null)) != null && result2.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AttachChunkResult openChunkForProject(@NotNull String chunkUniqueId, @NotNull Project project2, @Nullable ProgressIndicator indicator) {
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(21);
        }
        if (project2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(22);
        }
        ((FileBasedIndexEx)FileBasedIndex.getInstance()).waitUntilIndicesAreInitialized();
        this.myConfigurationLock.writeLock().lock();
        try {
            if (this.myInitialized == null) {
                AttachChunkResult attachChunkResult = null;
                return attachChunkResult;
            }
            short chunkEnumeratedId = this.myChunkDescriptorEnumerator.enumerate(chunkUniqueId);
            if (indicator != null) {
                indicator.setText(SharedIndexesBundle.message("configuring.shared.indexes", new Object[0]));
                indicator.setIndeterminate(true);
            }
            AttachChunkResult attachChunkResult = this.registerChunk(chunkEnumeratedId, chunkUniqueId, project2);
            return attachChunkResult;
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            LOG.error("Failed to register shared indexes chunk: " + chunkUniqueId + ". " + e.getMessage(), e);
            AttachChunkResult attachChunkResult = null;
            return attachChunkResult;
        }
        finally {
            this.myConfigurationLock.writeLock().unlock();
        }
    }

    @Override
    @Nullable
    public String getChunkDebugName(int chunkId) {
        return this.getChunkUniqueId(chunkId);
    }

    @Nullable
    private String getChunkUniqueId(int chunkId) {
        return this.myChunkDescriptorEnumerator.valueOf((short)chunkId);
    }

    @Override
    @NotNull
    public Collection<ID<?, ?>> attachExistingChunk(int chunkId, @NotNull Project project2) {
        if (project2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(23);
        }
        LOG.assertTrue(chunkId != -1);
        String chunkUniqueId = this.getChunkUniqueId(chunkId);
        return chunkUniqueId == null ? Collections.emptyList() : this.attachExistingIndex(chunkUniqueId, chunkId, project2);
    }

    @NotNull
    private List<ID<?, ?>> attachExistingIndex(@NotNull String chunkUniqueId, int chunkId, @NotNull Project project2) {
        List<Object> list;
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(24);
        }
        if (project2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(25);
        }
        try {
            AttachChunkResult result2 = this.registerChunk(chunkId, chunkUniqueId, project2);
            list = result2 == null ? Collections.emptyList() : result2.getMatchingFbIndexes();
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            SharedIndexStorageUtil.logAttachError("Failed to attach a known chunkId = " + chunkId + ". " + e.getMessage(), e);
            List<ID<?, ?>> list2 = Collections.emptyList();
            if (list2 == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(27);
            }
            return list2;
        }
        if (list == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Override
    public boolean isAvailableChunk(@NotNull String chunkUniqueId) {
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(28);
        }
        this.initialize();
        this.myConfigurationLock.readLock().lock();
        try {
            if (this.myInitialized == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mySharedIndexStorage.isCompatibleChunk(chunkUniqueId);
            return bl;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    @Override
    public void markOpenChunksAsExcluded(boolean keepBundledIndexes) {
        List<String> chunkNames;
        this.myConfigurationLock.readLock().lock();
        try {
            chunkNames = this.myChunkManager.getOpenChunkIds().stream().map(chunkId -> {
                try {
                    return this.getChunkUniqueId((int)chunkId);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
        if (keepBundledIndexes) {
            List<String> bundledChunkIds = ((BundledSharedIndexesResolver)ServiceManager.getService(BundledSharedIndexesResolver.class)).listChunkIds();
            chunkNames.removeAll(bundledChunkIds);
        }
        this.myExcludedChunkList.markChunksAsExcluded(chunkNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AttachChunkResult registerChunk(int chunkId, @NotNull String chunkUniqueId, @NotNull Project project2) throws IOException {
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(29);
        }
        if (project2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(30);
        }
        if (this.myExcludedChunkList.isChunkExcluded(chunkUniqueId)) {
            return null;
        }
        this.myConfigurationLock.writeLock().lock();
        try {
            if (this.myInitialized == null) {
                AttachChunkResult attachChunkResult = null;
                return attachChunkResult;
            }
            if (this.myChunkManager.isInvalidChunk(chunkId)) {
                AttachChunkResult.Incompatible incompatible = AttachChunkResult.Incompatible.INSTANCE;
                return incompatible;
            }
            if (this.myChunkManager.isChunkAttached(chunkId)) {
                if (!this.myChunkManager.isProjectAttachedToChunk(chunkId, project2)) {
                    this.myChunkManager.attachProjectToChunk(chunkId, project2);
                }
                AttachChunkResult attachChunkResult = this.myChunkManager.getIndexAttachResult(chunkId);
                return attachChunkResult;
            }
            AttachChunkResult indexAttachChunkResult = this.openFileBasedIndexChunk(chunkId, chunkUniqueId);
            if (!(indexAttachChunkResult instanceof AttachChunkResult.Success)) {
                this.myChunkManager.markInvalidChunk(chunkId);
                LOG.warn("Chunk " + chunkUniqueId + " is incompatible and is not registered for project '" + project2.getName() + "'");
                AttachChunkResult attachChunkResult = indexAttachChunkResult;
                return attachChunkResult;
            }
            AttachChunkResult.Success successResult = (AttachChunkResult.Success)indexAttachChunkResult;
            this.myChunkManager.attachChunk(chunkId, successResult.getChunkRoot(), indexAttachChunkResult);
            this.myChunkManager.attachProjectToChunk(chunkId, project2);
            for (SharedIndex<?, ?> index2 : successResult.getAllMatchingIndexes()) {
                this.myChunkMap.computeIfAbsent(index2.getIndexName(), __ -> new HashMap()).putIfAbsent(index2.getChunkId(), index2);
            }
            LOG.info("Chunk " + chunkUniqueId + " is registered for project '" + project2.getName() + ": " + indexAttachChunkResult.toLogMessage());
            AttachChunkResult attachChunkResult = indexAttachChunkResult;
            return attachChunkResult;
        }
        finally {
            this.myConfigurationLock.writeLock().unlock();
        }
    }

    @NotNull
    private AttachChunkResult openFileBasedIndexChunk(int chunkId, @NotNull String chunkUniqueId) throws IOException {
        Path chunkRoot;
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(31);
        }
        if ((chunkRoot = this.mySharedIndexStorage.getChunkRoot(chunkUniqueId)) == null) {
            AttachChunkResult.Incompatible incompatible = AttachChunkResult.Incompatible.INSTANCE;
            if (incompatible == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(32);
            }
            return incompatible;
        }
        SharedIndexStats sharedIndexStats = this.mySharedIndexStorage.getSharedIndexStats();
        AttachChunkResult attachChunkResult = SharedIndexStorageUtil.openFileBasedIndexChunks(chunkId, chunkRoot, sharedIndexStats);
        if (attachChunkResult == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(33);
        }
        return attachChunkResult;
    }

    @NotNull
    static Path getSharedIndexConfigurationRoot() {
        Path root = PathManager.getIndexRoot().toPath().resolve("shared_indexes");
        if (!Files.exists(root, new LinkOption[0])) {
            try {
                Files.createDirectories(root, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Path path = root;
        if (path == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(34);
        }
        return path;
    }

    private static void shutDownChunks(@NotNull Map<ID<?, ?>, Map<Integer, SharedIndex<?, ?>>> myChunkMap, @NotNull Set<Integer> expectedChunkIds) {
        if (myChunkMap == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(35);
        }
        if (expectedChunkIds == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(36);
        }
        for (Map<Integer, SharedIndex<?, ?>> chunksForId : myChunkMap.values()) {
            for (Map.Entry<Integer, SharedIndex<?, ?>> entry : chunksForId.entrySet()) {
                Integer chunkId = entry.getKey();
                if (!expectedChunkIds.contains(chunkId)) {
                    LOG.error("Inconsistent shared index chunk configuration: chunkId " + chunkId + " can't be found among " + expectedChunkIds);
                }
                SharedIndex<?, ?> index2 = entry.getValue();
                IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{index2});
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 36: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 36: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/SharedIndexChunkConfigurationImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkUniqueId";
                break;
            }
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myChunkMap";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedChunkIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initialize";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/SharedIndexChunkConfigurationImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadIndex";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "attachExistingIndex";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileBasedIndexChunk";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedIndexConfigurationRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSharedIndexAcceptable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasSharedIndex";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processSharedIndexes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "querySharedIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryEnumerateContentHash";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "downloadIndex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDownloadNeeded";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadIndex";
                break;
            }
            case 19: 
            case 20: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "attachExistingChunk";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "openChunkForProject";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "attachExistingIndex";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableChunk";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "registerChunk";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "openFileBasedIndexChunk";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "shutDownChunks";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 36: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

