/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.AttachChunkResult;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashEnumerator;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorages;
import com.intellij.indexing.shared.platform.impl.ChunkManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.indexing.IndexedFile;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eJ\b\u0010\u0019\u001a\u00020\u0017H\u0016J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\bJ\f\u0010%\u001a\u00020\u0012*\u00020\u001fH\u0002R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexChunk;", "Ljava/io/Closeable;", "chunkRootPath", "Ljava/nio/file/Path;", "indexAttachChunkResult", "Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "hashProviders", "", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "lifetime", "Lcom/intellij/openapi/Disposable;", "(Ljava/nio/file/Path;Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;[Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;Lcom/intellij/openapi/Disposable;)V", "attachedProjects", "Ljava/util/HashSet;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/collections/HashSet;", "hashEnumerators", "", "", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashEnumerator;", "getIndexAttachChunkResult", "()Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "attachProject", "", "project", "close", "detachProject", "getAttachedProjects", "", "getHashEnumeratorFor", "hash", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "tryEnumerate", "", "fileContent", "Lcom/intellij/util/indexing/IndexedFile;", "hashProvider", "toIndexKey", "intellij.indexing.shared"})
public final class SharedIndexChunk
implements Closeable {
    private final Map<String, SharedIndexContentHashEnumerator> hashEnumerators;
    private final HashSet<Project> attachedProjects;
    @NotNull
    private final AttachChunkResult indexAttachChunkResult;
    private final Disposable lifetime;

    @Nullable
    public final SharedIndexContentHashEnumerator getHashEnumeratorFor(@NotNull SharedIndexContentHash hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.hashEnumerators.get(this.toIndexKey(hash));
    }

    public final int tryEnumerate(@NotNull IndexedFile fileContent, @NotNull SharedIndexContentHashProvider hashProvider) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Intrinsics.checkNotNullParameter((Object)hashProvider, (String)"hashProvider");
        SharedIndexContentHashEnumerator sharedIndexContentHashEnumerator = this.getHashEnumeratorFor(hashProvider.getInfo());
        if (sharedIndexContentHashEnumerator == null) {
            return 0;
        }
        SharedIndexContentHashEnumerator hashEnumerator = sharedIndexContentHashEnumerator;
        byte[] byArray = hashProvider.computeHash(fileContent);
        if (byArray == null) {
            return 0;
        }
        byte[] hash = byArray;
        return hashEnumerator.tryEnumerate(hash);
    }

    private final String toIndexKey(SharedIndexContentHash $this$toIndexKey) {
        return $this$toIndexKey.getProviderId() + "@" + $this$toIndexKey.getVersion();
    }

    public final void attachProject(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.attachedProjects.add(project2);
    }

    @NotNull
    public final Set<Project> getAttachedProjects() {
        return this.attachedProjects;
    }

    public final void detachProject(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.attachedProjects.remove(project2);
    }

    @Override
    public void close() {
        Disposer.dispose((Disposable)this.lifetime);
    }

    @NotNull
    public final AttachChunkResult getIndexAttachChunkResult() {
        return this.indexAttachChunkResult;
    }

    /*
     * WARNING - void declaration
     */
    public SharedIndexChunk(@NotNull Path chunkRootPath, @NotNull AttachChunkResult indexAttachChunkResult, @NotNull SharedIndexContentHashProvider[] hashProviders, @NotNull Disposable lifetime) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        Intrinsics.checkNotNullParameter((Object)indexAttachChunkResult, (String)"indexAttachChunkResult");
        Intrinsics.checkNotNullParameter((Object)hashProviders, (String)"hashProviders");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.indexAttachChunkResult = indexAttachChunkResult;
        this.lifetime = lifetime;
        SharedIndexContentHashProvider[] sharedIndexContentHashProviderArray = hashProviders;
        SharedIndexChunk sharedIndexChunk = this;
        boolean $i$f$mapNotNull = false;
        void var7_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var12_18 = $this$forEach$iv$iv$iv;
        int n = ((void)var12_18).length;
        for (int i = 0; i < n; ++i) {
            SharedIndexContentHashEnumerator sharedIndexContentHashEnumerator;
            SharedIndexContentHashEnumerator sharedIndexContentHashEnumerator2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var12_18[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            try {
                boolean $i$f$service = false;
                Object object = ApplicationManager.getApplication().getService(SharedIndexHashStorages.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
                sharedIndexContentHashEnumerator2 = ((SharedIndexHashStorages)object).openHashEnumerator(chunkRootPath, it.getInfo(), this.lifetime);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                ChunkManagerKt.access$getLOG$p().warn("Failed to open enumerator for " + it.getInfo().getProviderId() + " from " + chunkRootPath + ". " + t.getMessage(), t);
                sharedIndexContentHashEnumerator2 = null;
            }
            if (sharedIndexContentHashEnumerator2 == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            SharedIndexContentHashEnumerator it$iv$iv = sharedIndexContentHashEnumerator;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        $this$mapNotNull$iv = (Iterable)object;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SharedIndexContentHashEnumerator sharedIndexContentHashEnumerator = (SharedIndexContentHashEnumerator)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            String string2 = this.toIndexKey(it.getInfo());
            object.put(string2, element$iv$iv);
        }
        object = destination$iv$iv2;
        sharedIndexChunk.hashEnumerators = MapsKt.toMap((Map)object);
        boolean bl = false;
        this.attachedProjects = new HashSet();
    }

    public /* synthetic */ SharedIndexChunk(Path path, AttachChunkResult attachChunkResult, SharedIndexContentHashProvider[] sharedIndexContentHashProviderArray, Disposable disposable2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Collection $this$toTypedArray$iv = SharedIndexHashProviders.getSortedSharedIndexHashingProviders();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            SharedIndexContentHashProvider[] sharedIndexContentHashProviderArray2 = thisCollection$iv.toArray(new SharedIndexContentHashProvider[0]);
            if (sharedIndexContentHashProviderArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            sharedIndexContentHashProviderArray = sharedIndexContentHashProviderArray2;
        }
        if ((n & 8) != 0) {
            Disposable disposable3 = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"Disposer.newDisposable()");
            disposable2 = disposable3;
        }
        this(path, attachChunkResult, sharedIndexContentHashProviderArray, disposable2);
    }
}

