/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.platform.impl.EmptyIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.HashBasedMapReduceIndex;
import com.intellij.indexing.shared.platform.impl.HashSuppliedIndexedFile;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtensionUpdatableIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructureExtensionUpdateComputation;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.MergedValueContainer;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.storage.VfsAwareMapIndexStorage;
import com.intellij.util.io.DataExternalizer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class MergedInvertedIndex<Key, Value>
implements FileBasedIndexInfrastructureExtensionUpdatableIndex<Key, Value, FileContent> {
    private static final Key<Ref<@Nullable FileContent>> INDEXED_HASH_KEY = Key.create((String)"indexed.file.shared.index.metadata.hash");
    private static final Logger LOG = Logger.getInstance(MergedInvertedIndex.class);
    @NotNull
    private final SharedIndexChunkConfiguration mySharedIndexChunkConfiguration;
    @NotNull
    private final FileContentHashIndex myHashIndex;
    @NotNull
    public final UpdatableIndex<Key, Value, FileContent> myBaseIndex;
    private final ID<Key, Value> myId;

    public MergedInvertedIndex(@NotNull ID<Key, Value> id, @NotNull UpdatableIndex<Key, Value, FileContent> baseIndex) throws IOException {
        if (id == null) {
            MergedInvertedIndex.$$$reportNull$$$0(0);
        }
        if (baseIndex == null) {
            MergedInvertedIndex.$$$reportNull$$$0(1);
        }
        this.myId = id;
        this.mySharedIndexChunkConfiguration = SharedIndexChunkConfiguration.getInstance();
        FileContentHashIndex hashIndex = id instanceof StubIndexKey ? FileContentHashIndex.getFileContentHashIndex(StubUpdatingIndex.INDEX_ID) : MergedInvertedIndex.createFileContentHashIndex(this.myId);
        this.myHashIndex = hashIndex;
        this.myBaseIndex = baseIndex;
    }

    public boolean tryIndexWithoutContent(int inputId, @NotNull IndexedFile indexedFile) {
        FileContent hashSuppliedIndexedFile;
        Ref hashSuppliedIndexedFileRef;
        if (indexedFile == null) {
            MergedInvertedIndex.$$$reportNull$$$0(2);
        }
        if ((hashSuppliedIndexedFileRef = (Ref)indexedFile.getUserData(INDEXED_HASH_KEY)) == null) {
            long hashId = this.mySharedIndexChunkConfiguration.tryEnumerateContentHash(indexedFile);
            hashSuppliedIndexedFileRef = new Ref();
            if (hashId != FileContentHashIndexExtension.NULL_HASH_ID) {
                hashSuppliedIndexedFileRef.set((Object)new HashSuppliedIndexedFile(indexedFile, hashId));
            }
            indexedFile.putUserData(INDEXED_HASH_KEY, (Object)hashSuppliedIndexedFileRef);
        }
        if ((hashSuppliedIndexedFile = (FileContent)hashSuppliedIndexedFileRef.get()) == null) {
            return false;
        }
        Computable sharedIndexUpdate = this.myHashIndex.mapInputAndPrepareUpdate(inputId, hashSuppliedIndexedFile);
        long hashId = MergedInvertedIndex.getHashId((MapReduceIndex.IndexUpdateComputable)sharedIndexUpdate);
        return hashId != FileContentHashIndexExtension.NULL_HASH_ID && LOG.assertTrue(((Boolean)this.updateBaseIndex(inputId, null).compute()).booleanValue()) && LOG.assertTrue(((Boolean)sharedIndexUpdate.compute()).booleanValue());
    }

    @NotNull
    public IndexInfrastructureExtensionUpdateComputation mapInputAndPrepareUpdate(int inputId, @Nullable FileContent content) {
        Computable<Boolean> baseIndexUpdate;
        boolean hasSharedIndex;
        Computable sharedIndexUpdate;
        if (content != null && !IndexingDataKeys.REBUILD_REQUESTED.isIn((UserDataHolder)content.getFile())) {
            sharedIndexUpdate = this.myHashIndex.mapInputAndPrepareUpdate(inputId, content);
            long hashId = MergedInvertedIndex.getHashId((MapReduceIndex.IndexUpdateComputable)sharedIndexUpdate);
            int chunkId = FileContentHashIndexExtension.getChunkId(hashId);
            hasSharedIndex = this.mySharedIndexChunkConfiguration.hasSharedIndex(this.myId, chunkId);
            if (LOG.isTraceEnabled() && this.myId.equals((Object)StubUpdatingIndex.INDEX_ID)) {
                if (hasSharedIndex) {
                    LOG.trace("Shared stub index is found for " + content.getFileName() + " in chunk " + chunkId);
                } else {
                    LOG.trace("Shared stub index is not found for " + content.getFileName());
                }
            }
            baseIndexUpdate = hashId != FileContentHashIndexExtension.NULL_HASH_ID && hasSharedIndex ? this.updateBaseIndex(inputId, null) : this.updateBaseIndex(inputId, content);
        } else {
            sharedIndexUpdate = this.myHashIndex.mapInputAndPrepareUpdate(inputId, null);
            baseIndexUpdate = this.updateBaseIndex(inputId, content);
            hasSharedIndex = false;
        }
        return new IndexInfrastructureExtensionUpdateComputation(() -> Boolean.TRUE.equals(sharedIndexUpdate.get()) && Boolean.TRUE.equals(baseIndexUpdate.get()), hasSharedIndex);
    }

    private static long getHashId(MapReduceIndex.IndexUpdateComputable sharedIndexUpdate) {
        Map map2 = sharedIndexUpdate.getInputData().getKeyValues();
        return FileContentHashIndexExtension.getHashId(map2);
    }

    public void updateWithMap(@NotNull AbstractUpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            MergedInvertedIndex.$$$reportNull$$$0(3);
        }
        this.myBaseIndex.updateWithMap(updateData);
    }

    public void setBufferingEnabled(boolean enabled) {
        this.myBaseIndex.setBufferingEnabled(enabled);
    }

    public void cleanupMemoryStorage() {
        this.myBaseIndex.cleanupMemoryStorage();
    }

    @TestOnly
    public void cleanupForNextTest() {
        this.myBaseIndex.cleanupForNextTest();
    }

    public void dumpStatistics() {
        this.myBaseIndex.dumpStatistics();
    }

    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        if (key == null) {
            MergedInvertedIndex.$$$reportNull$$$0(4);
        }
        SmartList data = new SmartList();
        data.add(this.myBaseIndex.getData(key));
        this.mySharedIndexChunkConfiguration.processSharedIndexes(this.myId, arg_0 -> MergedInvertedIndex.lambda$getData$1((List)data, key, arg_0));
        return new MergedValueContainer((List)data);
    }

    public boolean processAllKeys(@NotNull Processor<? super Key> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor == null) {
            MergedInvertedIndex.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            MergedInvertedIndex.$$$reportNull$$$0(6);
        }
        if (!this.myBaseIndex.processAllKeys(processor, scope, idFilter)) {
            return false;
        }
        return this.mySharedIndexChunkConfiguration.processSharedIndexes(this.myId, index2 -> index2.processAllKeys(processor, scope, idFilter));
    }

    @NotNull
    public ReadWriteLock getLock() {
        ReadWriteLock readWriteLock = this.myBaseIndex.getLock();
        if (readWriteLock == null) {
            MergedInvertedIndex.$$$reportNull$$$0(7);
        }
        return readWriteLock;
    }

    @NotNull
    public Map<Key, Value> getIndexedFileData(int fileId) throws StorageException {
        VirtualFile indexingFile = FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed();
        if (indexingFile != null) {
            int indexingFileId = FileBasedIndex.getFileId((VirtualFile)indexingFile);
            Map data = this.myBaseIndex.getIndexedFileData(fileId);
            if (indexingFileId != fileId) {
                String message = "Indexing process should not rely on non-indexed file data.\nIndexing file = " + indexingFile.getPath() + ", file id = " + indexingFileId + ", queried file id = " + fileId;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    FileBasedIndexImpl.LOG.warn(message);
                } else {
                    FileBasedIndexImpl.LOG.error(message);
                }
            }
            Map map2 = data;
            if (map2 == null) {
                MergedInvertedIndex.$$$reportNull$$$0(8);
            }
            return map2;
        }
        long hashId = this.myHashIndex.getHashId(fileId);
        int chunkId = FileContentHashIndexExtension.getChunkId(hashId);
        if (hashId == FileContentHashIndexExtension.NULL_HASH_ID || !this.mySharedIndexChunkConfiguration.hasSharedIndex(this.myId, chunkId)) {
            Map map3 = this.myBaseIndex.getIndexedFileData(fileId);
            if (map3 == null) {
                MergedInvertedIndex.$$$reportNull$$$0(9);
            }
            return map3;
        }
        int internalHashId = FileContentHashIndexExtension.getInternalHashId(hashId);
        Map sharedFileData = this.mySharedIndexChunkConfiguration.querySharedIndex(this.myId, chunkId, index2 -> {
            if (!MergedInvertedIndex.doesSharedIndexHaveForwardIndex(index2)) {
                NewVirtualFile vFile = PersistentFS.getInstance().findFileByIdIfCached(fileId);
                if (vFile != null) {
                    FileBasedIndex.getInstance().requestReindex((VirtualFile)vFile);
                }
                LOG.error("Shared index chunk for " + this.getExtension().getName() + " doesn't have forward index. Index data might be incomplete");
                return Collections.emptyMap();
            }
            return index2.getIndexedFileData(internalHashId);
        });
        if (sharedFileData != null) {
            Map map4 = sharedFileData;
            if (map4 == null) {
                MergedInvertedIndex.$$$reportNull$$$0(10);
            }
            return map4;
        }
        throw new StorageException(String.format("File data for %d hasn't been found although chunk %d is attached with index %s", fileId, chunkId, this.myId.getName()));
    }

    public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2, boolean isProvidedByInfrastructureExtension) {
        if (file2 == null) {
            MergedInvertedIndex.$$$reportNull$$$0(11);
        }
        if (isProvidedByInfrastructureExtension) {
            this.myBaseIndex.setUnindexedStateForFile(fileId);
            IndexingStamp.setFileIndexedStateCurrent((int)fileId, this.myId);
        } else {
            this.myBaseIndex.setIndexedStateForFile(fileId, file2);
        }
    }

    public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            MergedInvertedIndex.$$$reportNull$$$0(12);
        }
        this.myBaseIndex.setIndexedStateForFile(fileId, file2);
    }

    public void invalidateIndexedStateForFile(int fileId) {
        this.myBaseIndex.invalidateIndexedStateForFile(fileId);
    }

    public void setUnindexedStateForFile(int fileId) {
        this.myBaseIndex.setUnindexedStateForFile(fileId);
    }

    @NotNull
    public FileIndexingState getIndexingStateForFile(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            MergedInvertedIndex.$$$reportNull$$$0(13);
        }
        FileIndexingState fileIndexingState = this.myBaseIndex.getIndexingStateForFile(fileId, file2);
        if (fileIndexingState == null) {
            MergedInvertedIndex.$$$reportNull$$$0(14);
        }
        return fileIndexingState;
    }

    public long getModificationStamp() {
        return this.myBaseIndex.getModificationStamp();
    }

    public void removeTransientDataForFile(int inputId) {
        this.myBaseIndex.removeTransientDataForFile(inputId);
    }

    public void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<Key, Value> diffBuilder) {
        if (diffBuilder == null) {
            MergedInvertedIndex.$$$reportNull$$$0(15);
        }
        this.myBaseIndex.removeTransientDataForKeys(inputId, diffBuilder);
    }

    @NotNull
    public IndexExtension<Key, Value, FileContent> getExtension() {
        IndexExtension indexExtension = this.myBaseIndex.getExtension();
        if (indexExtension == null) {
            MergedInvertedIndex.$$$reportNull$$$0(16);
        }
        return indexExtension;
    }

    public void clear() throws StorageException {
        try {
            this.myHashIndex.clear();
        }
        finally {
            this.myBaseIndex.clear();
        }
    }

    public void dispose() {
        try {
            if (!(this.myId instanceof StubIndexKey)) {
                this.myHashIndex.dispose();
            }
        }
        finally {
            this.myBaseIndex.dispose();
        }
    }

    public void flush() throws StorageException {
        try {
            this.myBaseIndex.flush();
        }
        finally {
            this.myHashIndex.flush();
        }
    }

    @NotNull
    private Computable<Boolean> updateBaseIndex(int inputId, @Nullable FileContent content) {
        Computable computable = MergedInvertedIndex.mustUseOnlySharedIndex() ? () -> Boolean.TRUE : this.myBaseIndex.mapInputAndPrepareUpdate(inputId, (Object)content);
        if (computable == null) {
            MergedInvertedIndex.$$$reportNull$$$0(17);
        }
        return computable;
    }

    @NotNull
    public FileContentHashIndex getHashIndex() {
        FileContentHashIndex fileContentHashIndex = this.myHashIndex;
        if (fileContentHashIndex == null) {
            MergedInvertedIndex.$$$reportNull$$$0(18);
        }
        return fileContentHashIndex;
    }

    private static boolean mustUseOnlySharedIndex() {
        return SystemProperties.getBooleanProperty((String)"idea.use.only.shared.index", (boolean)false);
    }

    @VisibleForTesting
    @NotNull
    public UpdatableIndex<Key, Value, FileContent> getBaseIndex() {
        UpdatableIndex<Key, Value, FileContent> updatableIndex = this.myBaseIndex;
        if (updatableIndex == null) {
            MergedInvertedIndex.$$$reportNull$$$0(19);
        }
        return updatableIndex;
    }

    @NotNull
    private static FileContentHashIndex createFileContentHashIndex(@NotNull ID<?, ?> index2) throws IOException {
        if (index2 == null) {
            MergedInvertedIndex.$$$reportNull$$$0(20);
        }
        FileContentHashIndexExtension extension2 = new FileContentHashIndexExtension(index2);
        Path sharedIndexRoot = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot();
        String name = extension2.getName().getName();
        Path indexDir = sharedIndexRoot.resolve(name);
        try {
            VfsAwareMapIndexStorage storage2 = new VfsAwareMapIndexStorage(indexDir.resolve(name + "_storage"), extension2.getKeyDescriptor(), extension2.getValueExternalizer(), extension2.getCacheSize(), extension2.keyIsUniqueForIndexedFile(), extension2.traceKeyHashToVirtualFileMapping());
            PersistentMapBasedForwardIndex map2 = new PersistentMapBasedForwardIndex(indexDir.resolve(name + "_inputs"), false);
            MapForwardIndexAccessor accessor = new MapForwardIndexAccessor((DataExternalizer)new InputMapExternalizer((IndexExtension)extension2));
            return new FileContentHashIndex(extension2, (IndexStorage<Long, Void>)storage2, (ForwardIndex)map2, (ForwardIndexAccessor<Long, Void>)accessor);
        }
        catch (IOException e) {
            try {
                FileUtil.delete((Path)indexDir);
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
            throw e;
        }
    }

    private static boolean doesSharedIndexHaveForwardIndex(@NotNull UpdatableIndex<?, ?, FileContent> index2) {
        if (index2 == null) {
            MergedInvertedIndex.$$$reportNull$$$0(21);
        }
        if (index2 instanceof EmptyIndex || index2.getExtension() instanceof SingleEntryFileBasedIndexExtension) {
            return true;
        }
        return ((HashBasedMapReduceIndex)index2).hasForwardIndex();
    }

    private static /* synthetic */ boolean lambda$getData$1(List data, Object key, UpdatableIndex index2) throws StorageException {
        data.add(index2.getData(key));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/MergedInvertedIndex";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/MergedInvertedIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingStateForFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "updateBaseIndex";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashIndex";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryIndexWithoutContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStateForFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFileContentHashIndex";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doesSharedIndexHaveForwardIndex";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

