/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.generate.HashBasedIndexGenerator;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.ValueContainerInputRemapping;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.LongSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class HashBasedMapReduceIndex<Key, Value>
extends VfsAwareMapReduceIndex<Key, Value> {
    @NotNull
    private final SharedIndexExtension<Key, Value> mySharedExtension;
    @NotNull
    private final LongSupplier myHashIndexStampSupplier;
    private volatile long myLastFileContentIndexStamp;

    @VisibleForTesting
    public HashBasedMapReduceIndex(@NotNull Path chunkPath, @NotNull SharedIndexExtension<Key, Value> sharedExtension, @NotNull ValueContainerInputRemapping hashIdRemapping, @NotNull LongSupplier hashIndexStampSupplier) throws IOException {
        if (chunkPath == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(0);
        }
        if (sharedExtension == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(1);
        }
        if (hashIdRemapping == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(2);
        }
        if (hashIndexStampSupplier == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(3);
        }
        super(HashBasedMapReduceIndex.assertIndexerNotUsed(sharedExtension.getFileBasedIndexExtension()), HashBasedMapReduceIndex.createStorage(chunkPath, sharedExtension, hashIdRemapping), (ForwardIndex)(HashBasedIndexGenerator.shouldCreateForwardIndex(sharedExtension) ? HashBasedIndexGenerator.createForwardIndex(HashBasedMapReduceIndex.getStorageFileName(chunkPath, sharedExtension), true) : null), HashBasedIndexGenerator.shouldCreateForwardIndex(sharedExtension) ? HashBasedIndexGenerator.createForwardIndexAccessor(sharedExtension, hashId -> {
            throw new AssertionError();
        }) : null, null, null);
        this.myLastFileContentIndexStamp = -1L;
        this.mySharedExtension = sharedExtension;
        this.myHashIndexStampSupplier = hashIndexStampSupplier;
    }

    public boolean acceptsFile(@NotNull IndexedFile file2) {
        if (file2 == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(4);
        }
        return this.mySharedExtension.acceptsInputFile(file2);
    }

    @NotNull
    public Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable FileContent content) throws MapReduceIndex.MapInputException, ProcessCanceledException {
        Computable computable = super.mapInputAndPrepareUpdate(inputId, (Object)content);
        if (computable == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(5);
        }
        return computable;
    }

    @NotNull
    public Map<Key, Value> getIndexedFileData(int hashId) throws StorageException {
        this.ensureCachesUpToDate();
        if (this.getExtension() instanceof SingleEntryFileBasedIndexExtension || this.hasForwardIndex()) {
            Map map2 = super.getIndexedFileData(hashId);
            if (map2 == null) {
                HashBasedMapReduceIndex.$$$reportNull$$$0(6);
            }
            return map2;
        }
        throw new AssertionError();
    }

    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        if (key == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(7);
        }
        this.ensureCachesUpToDate();
        ValueContainer valueContainer = super.getData(key);
        if (valueContainer == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(8);
        }
        return valueContainer;
    }

    protected void doDispose() throws StorageException {
        try {
            super.doDispose();
        }
        finally {
            this.mySharedExtension.closeResources();
        }
    }

    boolean hasForwardIndex() {
        return this.getForwardIndex() != null;
    }

    private static <Key, Value> IndexStorage<Key, Value> createStorage(@NotNull Path baseFile, @NotNull SharedIndexExtension<Key, Value> sharedExtension, @NotNull ValueContainerInputRemapping hashToFileId) throws IOException {
        if (baseFile == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(9);
        }
        if (sharedExtension == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(10);
        }
        if (hashToFileId == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(11);
        }
        return new MyMapIndexStorage<Key, Value>(HashBasedMapReduceIndex.getStorageFileName(baseFile, sharedExtension), sharedExtension, hashToFileId);
    }

    @NotNull
    private static <Key, Value> Path getStorageFileName(@NotNull Path baseFile, @NotNull SharedIndexExtension<Key, Value> extension2) {
        if (baseFile == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(12);
        }
        if (extension2 == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(13);
        }
        Path path = baseFile.resolve(extension2.getFileBasedIndexExtension().getName().getName());
        if (path == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(14);
        }
        return path;
    }

    private void ensureCachesUpToDate() {
        long currentStamp = this.myHashIndexStampSupplier.getAsLong();
        if (this.myLastFileContentIndexStamp != currentStamp) {
            ((MapIndexStorage)this.myStorage).clearCachedMappings();
            this.myLastFileContentIndexStamp = currentStamp;
        }
    }

    @NotNull
    private static <K, V> FileBasedIndexExtension<K, V> assertIndexerNotUsed(final FileBasedIndexExtension<K, V> extension2) {
        if (extension2 instanceof SingleEntryFileBasedIndexExtension) {
            return new SingleEntryFileBasedIndexExtension<V>(){

                @NotNull
                public ID<Integer, V> getName() {
                    ID iD = extension2.getName();
                    if (iD == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return iD;
                }

                public // Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull FileBasedIndex.InputFilter getInputFilter() {
                    throw HashBasedMapReduceIndex.error();
                }

                @NotNull
                public SingleEntryIndexer<V> getIndexer() {
                    return new SingleEntryIndexer<V>(false){

                        @Nullable
                        protected V computeValue(@NotNull FileContent inputData) {
                            if (inputData == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            throw HashBasedMapReduceIndex.error();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$1$1", "computeValue"));
                        }
                    };
                }

                @NotNull
                public DataExternalizer<V> getValueExternalizer() {
                    return new MyKeyDescriptor();
                }

                public int getVersion() {
                    throw HashBasedMapReduceIndex.error();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$1", "getName"));
                }
            };
        }
        return new FileBasedIndexExtension<K, V>(){

            @NotNull
            public ID<K, V> getName() {
                ID iD = extension2.getName();
                if (iD == null) {
                    2.$$$reportNull$$$0(0);
                }
                return iD;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull FileBasedIndex.InputFilter getInputFilter() {
                throw HashBasedMapReduceIndex.error();
            }

            public boolean dependsOnFileContent() {
                return extension2.dependsOnFileContent();
            }

            @NotNull
            public DataIndexer<K, V, FileContent> getIndexer() {
                DataIndexer dataIndexer = fc -> {
                    throw HashBasedMapReduceIndex.error();
                };
                if (dataIndexer == null) {
                    2.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<K> getKeyDescriptor() {
                return new MyKeyDescriptor();
            }

            @NotNull
            public DataExternalizer<V> getValueExternalizer() {
                return new MyKeyDescriptor();
            }

            public int getVersion() {
                throw HashBasedMapReduceIndex.error();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static AssertionError error() {
        return new AssertionError((Object)"Should not be called for shared index");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkPath";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashIdRemapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashIndexStampSupplier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashToFileId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInputAndPrepareUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createStorage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStorageFileName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyKeyDescriptor<K>
    implements KeyDescriptor<K> {
        private MyKeyDescriptor() {
        }

        public int getHashCode(K value) {
            throw HashBasedMapReduceIndex.error();
        }

        public boolean isEqual(K val1, K val2) {
            throw HashBasedMapReduceIndex.error();
        }

        public void save(@NotNull DataOutput out, K value) {
            if (out == null) {
                MyKeyDescriptor.$$$reportNull$$$0(0);
            }
            throw HashBasedMapReduceIndex.error();
        }

        public K read(@NotNull DataInput in) {
            if (in == null) {
                MyKeyDescriptor.$$$reportNull$$$0(1);
            }
            throw HashBasedMapReduceIndex.error();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$MyKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyMapIndexStorage<Key, Value>
    extends MapIndexStorage<Key, Value>
    implements VfsAwareIndexStorage<Key, Value> {
        private MyMapIndexStorage(Path baseFile, SharedIndexExtension<Key, Value> sharedExtension, ValueContainerInputRemapping hashToFileIds) throws IOException {
            super(baseFile, sharedExtension.getFileBasedIndexExtension().getKeyDescriptor(), sharedExtension.getFileBasedIndexExtension().getValueExternalizer(), sharedExtension.getFileBasedIndexExtension().getCacheSize(), sharedExtension.getFileBasedIndexExtension().keyIsUniqueForIndexedFile(), true, true, hashToFileIds);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean processKeys(@NotNull Processor<? super Key> processor, GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
            if (processor == null) {
                MyMapIndexStorage.$$$reportNull$$$0(0);
            }
            this.l.lock();
            try {
                this.myCache.clear();
                boolean bl = this.doProcessKeys(processor);
                return bl;
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
            catch (RuntimeException e) {
                boolean bl = (Boolean)MyMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
                return bl;
            }
            finally {
                this.l.unlock();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$MyMapIndexStorage", "processKeys"));
        }
    }
}

