/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.platform.impl.HashIndexKey;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileContentHashIndexExtension
extends FileBasedIndexExtension<Long, Void>
implements CustomInputsIndexFileBasedIndexExtension<Long> {
    @NotNull
    private final SharedIndexChunkConfiguration myIndexChunkConfiguration;
    @NotNull
    private final HashIndexKey myIndexId;
    public static final int NULL_CHUNK_ID = -1;
    public static final long NULL_HASH_ID = FileContentHashIndexExtension.getHashId(0, -1);
    private static final long NOT_YET_CALCULATED = FileContentHashIndexExtension.getHashId(0, -2);
    private static final Key<Long> HASH_ID_KEY = Key.create((String)"file.content.hash.id");

    public FileContentHashIndexExtension(@NotNull ID<?, ?> baseIndexId) {
        if (baseIndexId == null) {
            FileContentHashIndexExtension.$$$reportNull$$$0(0);
        }
        this(SharedIndexChunkConfiguration.getInstance(), baseIndexId);
    }

    @VisibleForTesting
    public FileContentHashIndexExtension(@NotNull SharedIndexChunkConfiguration configuration, @NotNull ID<?, ?> baseIndexId) {
        if (configuration == null) {
            FileContentHashIndexExtension.$$$reportNull$$$0(1);
        }
        if (baseIndexId == null) {
            FileContentHashIndexExtension.$$$reportNull$$$0(2);
        }
        this.myIndexChunkConfiguration = configuration;
        this.myIndexId = HashIndexKey.createHashIndexKey(baseIndexId);
    }

    @NotNull
    public HashIndexKey getName() {
        HashIndexKey hashIndexKey = this.myIndexId;
        if (hashIndexKey == null) {
            FileContentHashIndexExtension.$$$reportNull$$$0(3);
        }
        return hashIndexKey;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = file2 -> !file2.isDirectory();
        if (inputFilter == null) {
            FileContentHashIndexExtension.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public DataIndexer<Long, Void, FileContent> getIndexer() {
        return new DataIndexer<Long, Void, FileContent>(){

            @NotNull
            public Map<Long, Void> map(@NotNull FileContent fc) {
                if (fc == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.isPhysical(fc)) {
                    Map<Long, Void> map2 = Collections.emptyMap();
                    if (map2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map2;
                }
                long hashId = FileContentHashIndexExtension.getHashId(fc);
                if (hashId == NOT_YET_CALCULATED) {
                    hashId = FileContentHashIndexExtension.this.myIndexChunkConfiguration.tryEnumerateContentHash((IndexedFile)fc);
                }
                int chunkId = FileContentHashIndexExtension.getChunkId(hashId);
                if (hashId != NULL_HASH_ID) {
                    if (FileContentHashIndexExtension.this.myIndexChunkConfiguration.isSharedIndexAcceptable(FileContentHashIndexExtension.this.myIndexId.getBaseIndexId(), chunkId, (IndexedFile)fc)) {
                        FileContentHashIndexExtension.setHashId(fc, hashId);
                    } else {
                        hashId = NULL_HASH_ID;
                    }
                }
                return this.asMap(hashId);
            }

            @NotNull
            private Map<Long, Void> asMap(long hashId) {
                Map<Long, Void> map2 = hashId == NULL_HASH_ID ? Collections.emptyMap() : Collections.singletonMap(hashId, null);
                if (map2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return map2;
            }

            private boolean isPhysical(@NotNull FileContent fc) {
                if (fc == null) {
                    1.$$$reportNull$$$0(3);
                }
                return !(fc instanceof FileContentImpl) || ((FileContentImpl)fc).isPhysicalContent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fc";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndexExtension$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndexExtension$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "asMap";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isPhysical";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public KeyDescriptor<Long> getKeyDescriptor() {
        return new KeyDescriptor<Long>(){

            public int getHashCode(Long value) {
                return value.hashCode();
            }

            public boolean isEqual(Long val1, Long val2) {
                return val1.longValue() == val2.longValue();
            }

            public void save(@NotNull DataOutput out, Long value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                DataInputOutputUtil.writeLONG((DataOutput)out, (long)value);
            }

            public Long read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                return DataInputOutputUtil.readLONG((DataInput)in);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndexExtension$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
        if (voidDataExternalizer == null) {
            FileContentHashIndexExtension.$$$reportNull$$$0(5);
        }
        return voidDataExternalizer;
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public DataExternalizer<Collection<Long>> createExternalizer() {
        return new DataExternalizer<Collection<Long>>(){

            public void save(@NotNull DataOutput out, Collection<Long> value) throws IOException {
                if (out == null) {
                    3.$$$reportNull$$$0(0);
                }
                assert (value.isEmpty() || value.size() == 1);
                DataInputOutputUtil.writeLONG((DataOutput)out, (long)(value.isEmpty() ? 0L : value.iterator().next()));
            }

            public Collection<Long> read(@NotNull DataInput in) throws IOException {
                long id;
                if (in == null) {
                    3.$$$reportNull$$$0(1);
                }
                return (id = DataInputOutputUtil.readLONG((DataInput)in)) == 0L ? Collections.emptyList() : Collections.singleton(id);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndexExtension$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static long getHashId(@NotNull Map<Long, Void> inputData) {
        if (inputData == null) {
            FileContentHashIndexExtension.$$$reportNull$$$0(6);
        }
        return inputData.isEmpty() ? NULL_HASH_ID : inputData.keySet().iterator().next();
    }

    public static int getChunkId(long hashId) {
        return (int)(hashId >> 32);
    }

    public static int getInternalHashId(long hashId) {
        return (int)hashId;
    }

    public static long getHashId(int internalHashId, int chunkId) {
        return (long)chunkId << 32 | (long)internalHashId & 0xFFFFFFFFL;
    }

    private static long getHashId(@NotNull FileContent content) {
        Long value;
        if (content == null) {
            FileContentHashIndexExtension.$$$reportNull$$$0(7);
        }
        return (value = (Long)HASH_ID_KEY.get((UserDataHolder)content)) == null ? NOT_YET_CALCULATED : value;
    }

    private static void setHashId(@NotNull FileContent content, long hashId) {
        if (content == null) {
            FileContentHashIndexExtension.$$$reportNull$$$0(8);
        }
        HASH_ID_KEY.set((UserDataHolder)content, (Object)hashId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndexId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndexExtension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndexExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHashId";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setHashId";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

