/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.HashIndexKey;
import com.intellij.indexing.shared.platform.impl.MergedInvertedIndex;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.ValueContainerInputRemapping;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileContentHashIndex
extends VfsAwareMapReduceIndex<Long, Void> {
    private static final Logger LOG = Logger.getInstance(FileContentHashIndex.class);

    public FileContentHashIndex(@NotNull FileContentHashIndexExtension extension2, @NotNull IndexStorage<Long, Void> storage2, @NotNull ForwardIndex forwardIndex, @NotNull ForwardIndexAccessor<Long, Void> forwardIndexAccessor) {
        if (extension2 == null) {
            FileContentHashIndex.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            FileContentHashIndex.$$$reportNull$$$0(1);
        }
        if (forwardIndex == null) {
            FileContentHashIndex.$$$reportNull$$$0(2);
        }
        if (forwardIndexAccessor == null) {
            FileContentHashIndex.$$$reportNull$$$0(3);
        }
        super((IndexExtension)extension2, storage2, forwardIndex, forwardIndexAccessor, null, null);
    }

    protected void requestRebuild(@NotNull Throwable ex) {
        if (ex == null) {
            FileContentHashIndex.$$$reportNull$$$0(4);
        }
        FileContentHashIndexExtension extension2 = this.getExtension();
        FileBasedIndex.getInstance().requestRebuild(extension2.getName().getBaseIndexId());
    }

    @NotNull
    public FileContentHashIndexExtension getExtension() {
        FileContentHashIndexExtension fileContentHashIndexExtension = (FileContentHashIndexExtension)super.getExtension();
        if (fileContentHashIndexExtension == null) {
            FileContentHashIndex.$$$reportNull$$$0(5);
        }
        return fileContentHashIndexExtension;
    }

    public int getAssociatedChunkId(int fileId, VirtualFile file2) {
        try {
            return FileContentHashIndexExtension.getChunkId(this.getHashId(fileId));
        }
        catch (StorageException e) {
            LOG.error((Throwable)e);
            FileBasedIndex.getInstance().requestReindex(file2);
            return -1;
        }
    }

    public long getHashId(int fileId) throws StorageException {
        Map data = this.getIndexedFileData(fileId);
        if (data.isEmpty()) {
            return FileContentHashIndexExtension.NULL_HASH_ID;
        }
        return (Long)data.keySet().iterator().next();
    }

    @NotNull
    public ValueContainerInputRemapping getHashIdToFileIdsFunction(int chunkId) {
        ValueContainerInputRemapping valueContainerInputRemapping = hash -> {
            try {
                ValueContainer data = this.getData(FileContentHashIndexExtension.getHashId(hash, chunkId));
                if (data.size() == 0) {
                    return ArrayUtil.EMPTY_INT_ARRAY;
                }
                return FileContentHashIndex.collect(data.getValueIterator().getInputIdsIterator());
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        };
        if (valueContainerInputRemapping == null) {
            FileContentHashIndex.$$$reportNull$$$0(6);
        }
        return valueContainerInputRemapping;
    }

    public void dispose() {
        FileContentHashIndexExtension extension2 = this.getExtension();
        HashIndexKey key = extension2.getName();
        try {
            super.dispose();
        }
        finally {
            ID.unloadId((ID)key);
        }
    }

    private static int[] collect(@NotNull ValueContainer.IntIterator intIterator) {
        if (intIterator == null) {
            FileContentHashIndex.$$$reportNull$$$0(7);
        }
        int[] result2 = new int[intIterator.size()];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = intIterator.next();
        }
        return result2;
    }

    @NotNull
    public static FileContentHashIndex getFileContentHashIndex(@NotNull ID<?, ?> indexId2) {
        FileBasedIndexImpl fileBasedIndex;
        UpdatableIndex index2;
        if (indexId2 == null) {
            FileContentHashIndex.$$$reportNull$$$0(8);
        }
        if (indexId2 instanceof StubIndexKey) {
            indexId2 = StubUpdatingIndex.INDEX_ID;
        }
        if (!((index2 = (fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(indexId2)) instanceof MergedInvertedIndex)) {
            throw new IllegalArgumentException(indexId2.getName() + " is not supported by shared index");
        }
        FileContentHashIndex fileContentHashIndex = ((MergedInvertedIndex)index2).getHashIndex();
        if (fileContentHashIndex == null) {
            FileContentHashIndex.$$$reportNull$$$0(9);
        }
        return fileContentHashIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndexAccessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndex";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intIterator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashIdToFileIdsFunction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileContentHashIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileContentHashIndex";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

