/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
public class EmptyIndexEnumerator {
    public static void writeEmptyIndexes(@NotNull Path chunkRoot, @NotNull Set<String> names) throws IOException {
        if (chunkRoot == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(0);
        }
        if (names == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(1);
        }
        EmptyIndexEnumerator.writeEmptyIndexesToFile(EmptyIndexEnumerator.getEmptyIndexFile(chunkRoot), names);
    }

    @NotNull
    public static Set<String> readEmptyIndexes(@NotNull Path chunkRoot) throws IOException {
        if (chunkRoot == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(2);
        }
        return EmptyIndexEnumerator.readEmptyIndexesFile(EmptyIndexEnumerator.getEmptyIndexFile(chunkRoot));
    }

    public static void writeEmptyStubIndexes(@NotNull Path chunkRoot, @NotNull Set<String> names) throws IOException {
        if (chunkRoot == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(3);
        }
        if (names == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(4);
        }
        EmptyIndexEnumerator.writeEmptyIndexesToFile(EmptyIndexEnumerator.getEmptyStubIndexFile(chunkRoot), names);
    }

    @NotNull
    public static Set<String> readEmptyStubIndexes(@NotNull Path chunkRoot) throws IOException {
        if (chunkRoot == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(5);
        }
        return EmptyIndexEnumerator.readEmptyIndexesFile(EmptyIndexEnumerator.getEmptyStubIndexFile(chunkRoot));
    }

    private static void writeEmptyIndexesToFile(@NotNull Path path, @NotNull Set<String> names) {
        if (path == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(6);
        }
        if (names == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(7);
        }
        if (!names.isEmpty()) {
            PathKt.write((Path)path, (CharSequence)names.stream().sorted().collect(Collectors.joining("\n")));
        }
    }

    @NotNull
    private static Set<String> readEmptyIndexesFile(@NotNull Path path) throws IOException {
        if (path == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(8);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                EmptyIndexEnumerator.$$$reportNull$$$0(9);
            }
            return set;
        }
        return new LinkedHashSet<String>(Files.readAllLines(path));
    }

    @NotNull
    private static Path getEmptyStubIndexFile(@NotNull Path chunkRoot) {
        if (chunkRoot == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(10);
        }
        Path path = chunkRoot.resolve("empty-stub-indices.txt");
        if (path == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(11);
        }
        return path;
    }

    @NotNull
    private static Path getEmptyIndexFile(@NotNull Path chunkRoot) {
        if (chunkRoot == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(12);
        }
        Path path = chunkRoot.resolve("empty-indices.txt");
        if (path == null) {
            EmptyIndexEnumerator.$$$reportNull$$$0(13);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkRoot";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/EmptyIndexEnumerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/EmptyIndexEnumerator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readEmptyIndexesFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyStubIndexFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyIndexFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeEmptyIndexes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readEmptyIndexes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeEmptyStubIndexes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readEmptyStubIndexes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeEmptyIndexesToFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readEmptyIndexesFile";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyStubIndexFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyIndexFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

