/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.AttachChunkResult;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.indexing.shared.platform.impl.ChunkManagerKt;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunk;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0005J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\"\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u000ej\b\u0012\u0004\u0012\u00020\u0005`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/indexing/shared/platform/impl/ChunkManager;", "", "()V", "myChunkEnumerators", "Ljava/util/HashMap;", "", "Lcom/intellij/indexing/shared/platform/impl/SharedIndexChunk;", "Lkotlin/collections/HashMap;", "myHashProviders", "", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "kotlin.jvm.PlatformType", "[Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "myInvalidChunks", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "attachChunk", "", "chunkId", "chunkRootPath", "Ljava/nio/file/Path;", "indexAttachChunkResult", "Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "attachProjectToChunk", "project", "Lcom/intellij/openapi/project/Project;", "disposeChunks", "", "", "getIndexAttachResult", "getOpenChunkIds", "isChunkAttached", "", "isInvalidChunk", "isProjectAttachedToChunk", "markInvalidChunk", "tryEnumerateContentHash", "", "fileContent", "Lcom/intellij/util/indexing/IndexedFile;", "intellij.indexing.shared"})
public final class ChunkManager {
    private final HashMap<Integer, SharedIndexChunk> myChunkEnumerators;
    private final HashSet<Integer> myInvalidChunks;
    private final SharedIndexContentHashProvider[] myHashProviders;

    /*
     * WARNING - void declaration
     */
    public final long tryEnumerateContentHash(@NotNull IndexedFile fileContent) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Map map2 = this.myChunkEnumerators;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            int n = 0;
            int n2 = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            n = 0;
            SharedIndexChunk chunk2 = (SharedIndexChunk)entry2.getValue();
            SharedIndexContentHashProvider[] sharedIndexContentHashProviderArray = this.myHashProviders;
            int n3 = sharedIndexContentHashProviderArray.length;
            for (n = 0; n < n3; ++n) {
                void chunkId;
                SharedIndexContentHashProvider hashProvider;
                SharedIndexContentHashProvider sharedIndexContentHashProvider = hashProvider = sharedIndexContentHashProviderArray[n];
                Intrinsics.checkNotNullExpressionValue((Object)sharedIndexContentHashProvider, (String)"hashProvider");
                int internalHashId = chunk2.tryEnumerate(fileContent, sharedIndexContentHashProvider);
                if (internalHashId == 0) continue;
                return FileContentHashIndexExtension.getHashId(internalHashId, (int)chunkId);
            }
        }
        return FileContentHashIndexExtension.NULL_HASH_ID;
    }

    @NotNull
    public final Set<Integer> getOpenChunkIds() {
        Set<Integer> set = this.myChunkEnumerators.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"myChunkEnumerators.keys");
        return set;
    }

    public final void attachChunk(int chunkId, @NotNull Path chunkRootPath, @NotNull AttachChunkResult indexAttachChunkResult) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        Intrinsics.checkNotNullParameter((Object)indexAttachChunkResult, (String)"indexAttachChunkResult");
        ((Map)this.myChunkEnumerators).put(chunkId, new SharedIndexChunk(chunkRootPath, indexAttachChunkResult, this.myHashProviders, null, 8, null));
    }

    public final void attachProjectToChunk(int chunkId, @NotNull Project project2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            SharedIndexChunk sharedIndexChunk = this.myChunkEnumerators.get(chunkId);
            if (sharedIndexChunk == null) break block0;
            sharedIndexChunk.attachProject(project2);
        }
    }

    @Nullable
    public final AttachChunkResult getIndexAttachResult(int chunkId) {
        SharedIndexChunk sharedIndexChunk = this.myChunkEnumerators.get(chunkId);
        return sharedIndexChunk != null ? sharedIndexChunk.getIndexAttachChunkResult() : null;
    }

    public final boolean isInvalidChunk(int chunkId) {
        return this.myInvalidChunks.contains(chunkId);
    }

    public final void markInvalidChunk(int chunkId) {
        this.myInvalidChunks.add(chunkId);
    }

    public final boolean isChunkAttached(int chunkId) {
        return this.myChunkEnumerators.containsKey(chunkId);
    }

    public final boolean isProjectAttachedToChunk(int chunkId, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = this.myChunkEnumerators.get(chunkId);
        return object != null && (object = ((SharedIndexChunk)object).getAttachedProjects()) != null ? object.contains(project2) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> disposeChunks(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean bl = false;
        ArrayList closedChunkIds = new ArrayList();
        Map map2 = this.myChunkEnumerators;
        boolean bl2 = false;
        for (Map.Entry entry : map2.entrySet()) {
            void chunkId;
            Object object = entry;
            boolean bl3 = false;
            int n = ((Number)object.getKey()).intValue();
            object = entry;
            bl3 = false;
            SharedIndexChunk enumerator = (SharedIndexChunk)object.getValue();
            enumerator.detachProject(project2);
            if (!enumerator.getAttachedProjects().isEmpty()) continue;
            IOUtil.closeSafe((Logger)ChunkManagerKt.access$getLOG$p(), (Closeable[])new Closeable[]{enumerator});
            object = closedChunkIds;
            Integer n2 = (int)chunkId;
            boolean bl4 = false;
            object.add(n2);
        }
        Iterable $this$forEach$iv = closedChunkIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl5 = false;
            this.myChunkEnumerators.remove(it);
        }
        return closedChunkIds;
    }

    @NotNull
    public final Set<Integer> disposeChunks() {
        for (SharedIndexChunk enumerator : this.myChunkEnumerators.values()) {
            IOUtil.closeSafe((Logger)ChunkManagerKt.access$getLOG$p(), (Closeable[])new Closeable[]{enumerator});
        }
        Set<Integer> set = this.myChunkEnumerators.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"myChunkEnumerators.keys");
        HashSet chunkIds = CollectionsKt.toHashSet((Iterable)set);
        this.myChunkEnumerators.clear();
        return chunkIds;
    }

    public ChunkManager() {
        boolean bl = false;
        this.myChunkEnumerators = new HashMap();
        bl = false;
        this.myInvalidChunks = new HashSet();
        Collection $this$toTypedArray$iv = SharedIndexHashProviders.getSortedSharedIndexHashingProviders();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SharedIndexContentHashProvider[] sharedIndexContentHashProviderArray = thisCollection$iv.toArray(new SharedIndexContentHashProvider[0]);
        if (sharedIndexContentHashProviderArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.myHashProviders = sharedIndexContentHashProviderArray;
    }
}

