/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.hash;

import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.hash.SharedIndexCrcArchiveHash;
import com.intellij.openapi.vfs.IntegrityCheckCapableFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedHashesSupport;
import com.intellij.util.text.StringKt;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/platform/hash/SharedIndexCrcArchiveHashProvider;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "()V", "info", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "getInfo", "()Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "calculateStamp", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "computeHash", "", "content", "Lcom/intellij/util/indexing/IndexedFile;", "getArchiveFile", "archiveEntry", "isUtf8", "", "intellij.indexing.shared"})
public final class SharedIndexCrcArchiveHashProvider
implements SharedIndexContentHashProvider {
    @Override
    @NotNull
    public SharedIndexContentHash getInfo() {
        return SharedIndexCrcArchiveHash.INSTANCE;
    }

    @Override
    @Nullable
    public byte[] computeHash(@NotNull IndexedFile content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VirtualFile virtualFile = content.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"content.file");
        VirtualFile file2 = virtualFile;
        VirtualFile virtualFile2 = this.getArchiveFile(file2);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile archiveFile = virtualFile2;
        String string2 = archiveFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"archiveFile.name");
        String string3 = StringKt.nullize$default((String)StringsKt.substringBefore$default((String)string2, (String)"-", null, (int)2, null), (boolean)false, (int)1, null);
        if (string3 == null) {
            return null;
        }
        String archiveId = string3;
        long stamp = this.calculateStamp(file2);
        String string4 = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.name");
        String fileKey = string4;
        String string5 = archiveId + "=[:||:]=" + fileKey + "=[:||:]=" + stamp;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string6 = string5;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string6.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] message = byArray;
        return IndexedHashesSupport.calculateIndexedHash((IndexedFile)content, (byte[])message, (boolean)this.isUtf8(file2));
    }

    private final boolean isUtf8(VirtualFile $this$isUtf8) {
        return Intrinsics.areEqual((Object)$this$isUtf8.getCharset(), (Object)StandardCharsets.UTF_8);
    }

    private final VirtualFile getArchiveFile(VirtualFile archiveEntry) {
        VirtualFileSystem virtualFileSystem = archiveEntry.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"archiveEntry.fileSystem");
        VirtualFileSystem fileSystem = virtualFileSystem;
        if (!(fileSystem instanceof ArchiveFileSystem)) {
            return null;
        }
        VirtualFile virtualFile = ((ArchiveFileSystem)fileSystem).getLocalByEntry(archiveEntry);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"fileSystem.getLocalByEnt\u2026hiveEntry) ?: return null");
        VirtualFile localFile = virtualFile;
        boolean bl = localFile.isInLocalFileSystem();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Check failed.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return localFile;
    }

    private final long calculateStamp(VirtualFile file2) {
        VirtualFileSystem virtualFileSystem = file2.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"file.fileSystem");
        VirtualFileSystem fs = virtualFileSystem;
        return fs instanceof IntegrityCheckCapableFileSystem ? ((IntegrityCheckCapableFileSystem)fs).getEntryCrc(file2) : file2.getLength();
    }
}

