/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.api;

import com.intellij.openapi.util.SystemInfo;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum IndexInfrastructureOs implements Comparable<IndexInfrastructureOs>
{
    windows,
    mac,
    linux;


    @NotNull
    public static Set<String> textValues() {
        TreeSet<String> result2 = new TreeSet<String>();
        for (IndexInfrastructureOs os : IndexInfrastructureOs.values()) {
            result2.add(os.getOsName());
        }
        TreeSet<String> treeSet = result2;
        if (treeSet == null) {
            IndexInfrastructureOs.$$$reportNull$$$0(0);
        }
        return treeSet;
    }

    @NotNull
    public String getOsName() {
        if (this == windows) {
            return "windows";
        }
        if (this == mac) {
            return "mac";
        }
        if (this == linux) {
            return "linux";
        }
        throw new RuntimeException("Unknown OS: " + this);
    }

    @NotNull
    public static IndexInfrastructureOs getOs() {
        if (SystemInfo.isWindows) {
            IndexInfrastructureOs indexInfrastructureOs = windows;
            if (indexInfrastructureOs == null) {
                IndexInfrastructureOs.$$$reportNull$$$0(1);
            }
            return indexInfrastructureOs;
        }
        if (SystemInfo.isMac) {
            IndexInfrastructureOs indexInfrastructureOs = mac;
            if (indexInfrastructureOs == null) {
                IndexInfrastructureOs.$$$reportNull$$$0(2);
            }
            return indexInfrastructureOs;
        }
        if (SystemInfo.isLinux) {
            IndexInfrastructureOs indexInfrastructureOs = linux;
            if (indexInfrastructureOs == null) {
                IndexInfrastructureOs.$$$reportNull$$$0(3);
            }
            return indexInfrastructureOs;
        }
        throw new Error("Unknown OS. " + SystemInfo.getOsNameAndVersion());
    }

    @Nullable
    public static IndexInfrastructureOs find(@NotNull String capabilityName) {
        if (capabilityName == null) {
            IndexInfrastructureOs.$$$reportNull$$$0(4);
        }
        for (IndexInfrastructureOs value : IndexInfrastructureOs.values()) {
            if (!value.getOsName().equalsIgnoreCase(capabilityName)) continue;
            return value;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/api/IndexInfrastructureOs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capabilityName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "textValues";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/api/IndexInfrastructureOs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

