/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.indexing.shared.generate.IndexesExporterState;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class IdeIndexInfrastructureVersion {
    private final IndexInfrastructureVersion myVersion;

    private IdeIndexInfrastructureVersion(@NotNull IndexInfrastructureVersion version) {
        if (version == null) {
            IdeIndexInfrastructureVersion.$$$reportNull$$$0(0);
        }
        this.myVersion = version;
    }

    @NotNull
    public static IdeIndexInfrastructureVersion getIdeVersion() {
        return new IdeIndexInfrastructureVersion(new IndexesExporterState().getIndexVersion());
    }

    @NotNull
    @TestOnly
    public static IdeIndexInfrastructureVersion forTests(@NotNull IndexInfrastructureVersion version) {
        if (version == null) {
            IdeIndexInfrastructureVersion.$$$reportNull$$$0(1);
        }
        Logger.getInstance(IdeIndexInfrastructureVersion.class).assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        Logger.getInstance(IdeIndexInfrastructureVersion.class).assertTrue(version.getSupportedOs().size() == 1);
        return new IdeIndexInfrastructureVersion(version);
    }

    public String toString() {
        return "IdeIndexInfrastructureVersion{" + this.myVersion + "}";
    }

    @NotNull
    public IndexInfrastructureVersion getVersion() {
        IndexInfrastructureVersion indexInfrastructureVersion = this.myVersion;
        if (indexInfrastructureVersion == null) {
            IdeIndexInfrastructureVersion.$$$reportNull$$$0(2);
        }
        return indexInfrastructureVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeIndexInfrastructureVersion)) {
            return false;
        }
        IdeIndexInfrastructureVersion version = (IdeIndexInfrastructureVersion)o;
        return this.myVersion.equals(version.myVersion);
    }

    public int hashCode() {
        return Objects.hash(this.myVersion);
    }

    public boolean isSuitableVersion(@NotNull IndexInfrastructureVersion version) {
        if (version == null) {
            IdeIndexInfrastructureVersion.$$$reportNull$$$0(3);
        }
        return this.pickBestSuitableVersion(Collections.singletonList(version)) == version;
    }

    @Nullable
    public IndexInfrastructureVersion pickBestSuitableVersion(@NotNull Collection<IndexInfrastructureVersion> versions) {
        if (versions == null) {
            IdeIndexInfrastructureVersion.$$$reportNull$$$0(4);
        }
        IndexInfrastructureVersion ideVersion = this.getVersion();
        Integer bestScore = null;
        IndexInfrastructureVersion bestVersion = null;
        for (IndexInfrastructureVersion version : versions) {
            int commonFileBasedIndexesCount;
            if (!version.getSupportedOs().containsAll(ideVersion.getSupportedOs()) || !version.getBaseIndexes().equals(ideVersion.getBaseIndexes()) || (commonFileBasedIndexesCount = Sets.intersection(version.getFileBasedIndexVersions().entrySet(), ideVersion.getFileBasedIndexVersions().entrySet()).size()) < 3) continue;
            int fileBasedIndexMiss = Sets.difference(ideVersion.getFileBasedIndexVersions().entrySet(), version.getFileBasedIndexVersions().entrySet()).size();
            int stubFileElementsMiss = Sets.difference(ideVersion.getStubFileElementTypeVersions().entrySet(), version.getStubFileElementTypeVersions().entrySet()).size();
            int negativeScope = fileBasedIndexMiss + stubFileElementsMiss;
            if (bestScore != null && bestScore <= negativeScope) continue;
            bestScore = negativeScope;
            bestVersion = version;
        }
        return bestVersion;
    }

    public boolean isStubIndexVersionMatch(@NotNull IndexInfrastructureVersion version) {
        boolean hasMismatchingStubIndexVersions;
        if (version == null) {
            IdeIndexInfrastructureVersion.$$$reportNull$$$0(5);
        }
        boolean bl = hasMismatchingStubIndexVersions = !Maps.difference(version.getStubIndexVersions(), this.getVersion().getStubIndexVersions()).entriesDiffering().isEmpty();
        return !hasMismatchingStubIndexVersions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/api/IdeIndexInfrastructureVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/api/IdeIndexInfrastructureVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forTests";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pickBestSuitableVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStubIndexVersionMatch";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

