/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSortedMap;
import com.intellij.indexing.shared.download.SharedIndexBaseId;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.IdeIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureCapability;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureFileBasedIndexVersionInfo;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureVersion;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.text.StringKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "", "indexName", "", "indexKind", "sharedIndexInfo", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;", "indexInfrastructureVersion", "Lcom/intellij/indexing/shared/platform/api/IndexInfrastructureVersion;", "generationTime", "Ljava/time/ZonedDateTime;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;Lcom/intellij/indexing/shared/platform/api/IndexInfrastructureVersion;Ljava/time/ZonedDateTime;)V", "getGenerationTime", "()Ljava/time/ZonedDateTime;", "getIndexInfrastructureVersion", "()Lcom/intellij/indexing/shared/platform/api/IndexInfrastructureVersion;", "getIndexKind", "()Ljava/lang/String;", "getIndexName", "getSharedIndexInfo", "()Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.indexing.shared"})
public final class SharedIndexMetadata {
    @NotNull
    private final String indexName;
    @NotNull
    private final String indexKind;
    @NotNull
    private final SharedIndexMetadataInfo sharedIndexInfo;
    @NotNull
    private final IndexInfrastructureVersion indexInfrastructureVersion;
    @NotNull
    private final ZonedDateTime generationTime;
    private static final String METADATA_VERSION = "4";
    private static final Companion.TextValue.1 TextValue;
    private static final Companion.BooleanValue.1 BooleanValue;
    private static final Companion.FiledBasedIndexInfoValue.1 FiledBasedIndexInfoValue;
    public static final Companion Companion;

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SharedIndexMetadata)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.indexName, (Object)((SharedIndexMetadata)other).indexName) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.indexKind, (Object)((SharedIndexMetadata)other).indexKind) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.sharedIndexInfo, (Object)((SharedIndexMetadata)other).sharedIndexInfo) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.indexInfrastructureVersion, (Object)((SharedIndexMetadata)other).indexInfrastructureVersion) ^ true);
    }

    public int hashCode() {
        int result2 = this.indexName.hashCode();
        result2 = 31 * result2 + this.indexKind.hashCode();
        result2 = 31 * result2 + this.sharedIndexInfo.hashCode();
        result2 = 31 * result2 + this.indexInfrastructureVersion.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "SharedIndexMetadata(" + this.indexName + ", " + this.indexKind + "', indexInfrastructureVersion, " + this.sharedIndexInfo + ')';
    }

    @NotNull
    public final String getIndexName() {
        return this.indexName;
    }

    @NotNull
    public final String getIndexKind() {
        return this.indexKind;
    }

    @NotNull
    public final SharedIndexMetadataInfo getSharedIndexInfo() {
        return this.sharedIndexInfo;
    }

    @NotNull
    public final IndexInfrastructureVersion getIndexInfrastructureVersion() {
        return this.indexInfrastructureVersion;
    }

    @NotNull
    public final ZonedDateTime getGenerationTime() {
        return this.generationTime;
    }

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexMetadataInfo sharedIndexInfo, @NotNull IndexInfrastructureVersion indexInfrastructureVersion, @NotNull ZonedDateTime generationTime) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)indexKind, (String)"indexKind");
        Intrinsics.checkNotNullParameter((Object)sharedIndexInfo, (String)"sharedIndexInfo");
        Intrinsics.checkNotNullParameter((Object)indexInfrastructureVersion, (String)"indexInfrastructureVersion");
        Intrinsics.checkNotNullParameter((Object)generationTime, (String)"generationTime");
        this.indexName = indexName;
        this.indexKind = indexKind;
        this.sharedIndexInfo = sharedIndexInfo;
        this.indexInfrastructureVersion = indexInfrastructureVersion;
        this.generationTime = generationTime;
    }

    public /* synthetic */ SharedIndexMetadata(String string2, String string3, SharedIndexMetadataInfo sharedIndexMetadataInfo, IndexInfrastructureVersion indexInfrastructureVersion, ZonedDateTime zonedDateTime, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"ZonedDateTime.now()");
            zonedDateTime = zonedDateTime2;
        }
        this(string2, string3, sharedIndexMetadataInfo, indexInfrastructureVersion, zonedDateTime);
    }

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexMetadataInfo sharedIndexInfo, @NotNull IndexInfrastructureVersion indexInfrastructureVersion) {
        this(indexName, indexKind, sharedIndexInfo, indexInfrastructureVersion, null, 16, null);
    }

    static {
        Companion = new Companion(null);
        TextValue = new Companion.LoadSaveValue<String>(){

            @Nullable
            public String loadValue(@Nullable JsonNode node) {
                JsonNode jsonNode = node;
                return jsonNode != null ? jsonNode.asText() : null;
            }

            public void saveValue(@NotNull ObjectNode node, @NotNull String key, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                node.put(key, value);
            }
        };
        BooleanValue = new Companion.LoadSaveValue<Boolean>(){

            @Nullable
            public Boolean loadValue(@Nullable JsonNode node) {
                JsonNode jsonNode = node;
                return jsonNode != null ? Boolean.valueOf(jsonNode.asBoolean()) : null;
            }

            public void saveValue(@NotNull ObjectNode node, @NotNull String key, boolean value) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                node.put(key, value);
            }
        };
        FiledBasedIndexInfoValue = new Companion.LoadSaveValue<IndexInfrastructureFileBasedIndexVersionInfo>(){

            @Nullable
            public IndexInfrastructureFileBasedIndexVersionInfo loadValue(@Nullable JsonNode node) {
                if (!(node instanceof ObjectNode)) {
                    return null;
                }
                String string2 = SharedIndexMetadata.access$getTextValue$cp().loadValue(node.get("version"));
                if (string2 == null) {
                    return null;
                }
                String version = string2;
                Boolean bl = SharedIndexMetadata.access$getBooleanValue$cp().loadValue(node.get("needs_forward_index"));
                if (bl == null) {
                    return null;
                }
                boolean needsForwardIndex = bl;
                return new IndexInfrastructureFileBasedIndexVersionInfo(version, needsForwardIndex);
            }

            public void saveValue(@NotNull ObjectNode node, @NotNull String key, @NotNull IndexInfrastructureFileBasedIndexVersionInfo value) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ObjectNode objectNode = node.putObject(key);
                boolean bl = false;
                boolean bl2 = false;
                ObjectNode $this$apply = objectNode;
                boolean bl3 = false;
                Companion.TextValue.1 v0 = SharedIndexMetadata.access$getTextValue$cp();
                ObjectNode objectNode2 = $this$apply;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"this");
                v0.saveValue(objectNode2, "version", value.getVersion());
                SharedIndexMetadata.access$getBooleanValue$cp().saveValue($this$apply, "needs_forward_index", value.getNeedsForwardIndex());
            }
        };
    }

    public static final /* synthetic */ Companion.BooleanValue.1 access$getBooleanValue$cp() {
        return BooleanValue;
    }

    @JvmStatic
    @NotNull
    public static final Path getMetadataPath(@NotNull Path chunkRootPath) {
        return Companion.getMetadataPath(chunkRootPath);
    }

    @JvmStatic
    @NotNull
    public static final String getMetadataPath() {
        return Companion.getMetadataPath();
    }

    @JvmStatic
    @NotNull
    public static final byte[] writeIndexMetadata(@NotNull SharedIndexMetadata metadata) {
        return Companion.writeIndexMetadata(metadata);
    }

    @JvmStatic
    @Nullable
    public static final SharedIndexMetadata readIndexesVersion(@NotNull Path chunkRoot) throws IOException {
        return Companion.readIndexesVersion(chunkRoot);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008b\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003*\u0003\u0004\u0007\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001>B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0007J\u001d\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00170\"H\u0082\bJ\u001e\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020$0(J\u0010\u0010)\u001a\u0004\u0018\u00010\u001d2\u0006\u0010*\u001a\u00020\u0019J\u0012\u0010)\u001a\u0004\u0018\u00010\u001d2\b\u0010+\u001a\u0004\u0018\u00010 J\u0010\u0010,\u001a\u0004\u0018\u00010\u001b2\u0006\u0010*\u001a\u00020\u0019J\u0010\u0010-\u001a\u00020 2\u0006\u0010+\u001a\u00020\u001dH\u0007J\u000e\u0010.\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bJK\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H1\u0018\u000100\"\b\b\u0000\u00101*\u00020\u0001*\u00020\u00192\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f05\"\u00020\u000fH\u0002\u00a2\u0006\u0002\u00106J3\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u000100*\u00020\u00192\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f05\"\u00020\u000fH\u0002\u00a2\u0006\u0002\u00107J@\u00108\u001a\u00020\u0017\"\b\b\u0000\u00101*\u00020\u0001*\u00020\u00192\f\u00109\u001a\b\u0012\u0004\u0012\u0002H1032\u0006\u0010:\u001a\u00020\u000f2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H10<H\u0002J(\u00108\u001a\u00020\u0017*\u00020\u00192\u0006\u0010:\u001a\u00020\u000f2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0<H\u0003J\u001a\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u000100*\u00020\u0019H\u0002J2\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H1\u0018\u000100\"\b\b\u0000\u00101*\u00020\u0001*\u00020\u00192\f\u00102\u001a\b\u0012\u0004\u0012\u0002H103H\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006?"}, d2={"Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion;", "", "()V", "BooleanValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$BooleanValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$BooleanValue$1;", "FiledBasedIndexInfoValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$FiledBasedIndexInfoValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$FiledBasedIndexInfoValue$1;", "METADATA_DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getMETADATA_DATE_FORMAT", "()Ljava/time/format/DateTimeFormatter;", "METADATA_VERSION", "", "TextValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$TextValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$TextValue$1;", "getMetadataPath", "Ljava/nio/file/Path;", "chunkRootPath", "putIndexesVersion", "", "root", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "infrastructureVersion", "Lcom/intellij/indexing/shared/platform/api/IndexInfrastructureVersion;", "readIndexesVersion", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "chunkRoot", "renderJson", "", "builder", "Lkotlin/Function1;", "selectBestSuitableIndex", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/IdeIndexInfrastructureVersion;", "candidates", "", "tryReadIndexesVersion", "node", "metadata", "tryReadInfrastructureVersionOnly", "writeIndexMetadata", "writeVersionInfo", "mapFromPath", "Ljava/util/SortedMap;", "Y", "loadValue", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$LoadSaveValue;", "path", "", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$LoadSaveValue;[Ljava/lang/String;)Ljava/util/SortedMap;", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;[Ljava/lang/String;)Ljava/util/SortedMap;", "putObjectFromMap", "saveValue", "name", "map", "", "toMap", "LoadSaveValue", "intellij.indexing.shared"})
    public static final class Companion {
        private final DateTimeFormatter getMETADATA_DATE_FORMAT() {
            return DateTimeFormatter.ISO_DATE_TIME.withLocale(Locale.US);
        }

        @Nullable
        public final IndexInfrastructureVersion tryReadInfrastructureVersionOnly(@NotNull ObjectNode node) {
            Object object;
            SortedMap<String, String> hashProviderVersions;
            SortedMap<String, String> fileElementTypeVersions;
            SortedMap<String, String> stubIndexVersions;
            SortedMap fileIndexVersions;
            SortedMap<String, String> baseVersions;
            Map caps;
            block20: {
                boolean bl;
                block19: {
                    boolean bl2;
                    Object it$iv$iv;
                    Object object2;
                    boolean bl3;
                    boolean bl4;
                    boolean bl5;
                    Object element$iv$iv;
                    Object element$iv$iv$iv;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Object capName;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    JsonNode jsonNode = node.get("indexes");
                    if (!(jsonNode instanceof ObjectNode)) {
                        jsonNode = null;
                    }
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    if (objectNode == null) {
                        return null;
                    }
                    ObjectNode indexesNode = objectNode;
                    boolean bl6 = false;
                    caps = new LinkedHashMap();
                    JsonNode jsonNode2 = indexesNode.get("capabilities");
                    if (!(jsonNode2 instanceof ObjectNode)) {
                        jsonNode2 = null;
                    }
                    ObjectNode objectNode2 = (ObjectNode)jsonNode2;
                    if (objectNode2 != null) {
                        ObjectNode objectNode3 = objectNode2;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        ObjectNode capabilitiesNode = objectNode3;
                        boolean bl9 = false;
                        Iterator iterator = capabilitiesNode.fieldNames();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"capabilitiesNode.fieldNames()");
                        Iterator iterator2 = iterator;
                        bl = false;
                        Iterator iterator3 = iterator2;
                        while (iterator3.hasNext()) {
                            Object object3;
                            IndexInfrastructureCapability cap;
                            capName = (String)iterator3.next();
                            if (IndexInfrastructureCapability.find((String)capName) == null) {
                                continue;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)cap, (String)"IndexInfrastructureCapab\u2026find(capName) ?: continue");
                            JsonNode jsonNode3 = capabilitiesNode.get((String)capName);
                            if (!(jsonNode3 instanceof ObjectNode)) {
                                jsonNode3 = null;
                            }
                            if ((object3 = (ObjectNode)jsonNode3) == null || (object3 = Companion.toMap((ObjectNode)object3)) == null) {
                                continue;
                            }
                            Object data = object3;
                            caps.put(cap, data);
                        }
                    }
                    SortedMap<String, String> sortedMap = this.mapFromPath(indexesNode, "base_versions");
                    if (sortedMap == null) {
                        return null;
                    }
                    baseVersions = sortedMap;
                    SortedMap sortedMap2 = this.mapFromPath(indexesNode, FiledBasedIndexInfoValue, "file_index_versions");
                    if (sortedMap2 == null) {
                        return null;
                    }
                    fileIndexVersions = sortedMap2;
                    SortedMap<String, String> sortedMap3 = this.mapFromPath(indexesNode, "stub_index_versions");
                    if (sortedMap3 == null) {
                        return null;
                    }
                    stubIndexVersions = sortedMap3;
                    SortedMap<String, String> sortedMap4 = this.mapFromPath(indexesNode, "stub_file_element_type_versions");
                    if (sortedMap4 == null) {
                        return null;
                    }
                    fileElementTypeVersions = sortedMap4;
                    SortedMap<String, String> sortedMap5 = this.mapFromPath(indexesNode, "hash_provider_versions");
                    if (sortedMap5 == null) {
                        return null;
                    }
                    hashProviderVersions = sortedMap5;
                    JsonNode jsonNode4 = indexesNode.get("os");
                    if (!(jsonNode4 instanceof ArrayNode)) {
                        jsonNode4 = null;
                    }
                    if ((object = (ArrayNode)jsonNode4) == null) break block19;
                    Iterable $this$mapNotNull$iv = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    capName = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = iterator.next();
                        bl5 = false;
                        JsonNode it = (JsonNode)element$iv$iv;
                        boolean bl10 = false;
                        if (it.asText() == null) continue;
                        bl4 = false;
                        bl3 = false;
                        it$iv$iv = object2;
                        bl2 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    object = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
                    if (object == null) break block19;
                    $this$mapNotNull$iv = (Iterable)object;
                    $i$f$mapNotNull = false;
                    $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = iterator.next();
                        bl5 = false;
                        String p1 = (String)element$iv$iv;
                        boolean bl11 = false;
                        if (IndexInfrastructureOs.find(p1) == null) continue;
                        bl4 = false;
                        bl3 = false;
                        it$iv$iv = object2;
                        bl2 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    if (object != null) break block20;
                }
                bl = false;
                object = SetsKt.emptySet();
            }
            Object osNames = object;
            return new IndexInfrastructureVersion(caps, (Set<IndexInfrastructureOs>)osNames, (Map<String, String>)baseVersions, fileIndexVersions, (Map<String, String>)stubIndexVersions, (Map<String, String>)fileElementTypeVersions, (Map<String, String>)hashProviderVersions);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SharedIndexMetadata tryReadIndexesVersion(@NotNull ObjectNode node) {
            Object object;
            String string2;
            String string3;
            String string4;
            Object object2;
            String string5;
            Object bases;
            ZonedDateTime generated;
            Object indexName;
            Object indexKind;
            block32: {
                block31: {
                    Object object3;
                    List list;
                    boolean bl;
                    Object element$iv$iv$iv;
                    String string6;
                    boolean bl2;
                    ObjectNode sources;
                    block30: {
                        block29: {
                            void $this$mapNotNullTo$iv$iv;
                            void $this$mapNotNull$iv;
                            Object object4;
                            block28: {
                                block27: {
                                    void $this$mapTo$iv$iv;
                                    Iterable $this$mapNotNullTo$iv$iv2;
                                    Iterable $this$filterIsInstanceTo$iv$iv;
                                    Object it;
                                    Object object5;
                                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                                    JsonNode jsonNode = node.get("metadata_version");
                                    if (Intrinsics.areEqual((Object)(jsonNode != null ? jsonNode.asText() : null), (Object)SharedIndexMetadata.METADATA_VERSION) ^ true) {
                                        return null;
                                    }
                                    JsonNode jsonNode2 = node.get("sources");
                                    if (!(jsonNode2 instanceof ObjectNode)) {
                                        jsonNode2 = null;
                                    }
                                    ObjectNode objectNode = (ObjectNode)jsonNode2;
                                    if (objectNode == null) {
                                        return null;
                                    }
                                    sources = objectNode;
                                    Object object6 = sources.get("kind");
                                    if (object6 == null || (object6 = object6.asText()) == null) {
                                        return null;
                                    }
                                    indexKind = object6;
                                    Object object7 = sources.get("name");
                                    if (object7 == null || (object7 = object7.asText()) == null) {
                                        return null;
                                    }
                                    indexName = object7;
                                    Companion companion = this;
                                    boolean bl3 = false;
                                    try {
                                        object5 = Result.Companion;
                                        Object $this$runCatching = companion;
                                        boolean bl4 = false;
                                        Object object8 = sources.get("generated");
                                        if (object8 == null || (object8 = object8.asText()) == null) {
                                            return null;
                                        }
                                        $this$runCatching = ZonedDateTime.parse((CharSequence)object8, ((Companion)$this$runCatching).getMETADATA_DATE_FORMAT());
                                        bl4 = false;
                                        object5 = Result.constructor-impl((Object)$this$runCatching);
                                    }
                                    catch (Throwable $this$runCatching) {
                                        Result.Companion bl4 = Result.Companion;
                                        boolean bl5 = false;
                                        object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
                                    }
                                    companion = object5;
                                    bl3 = false;
                                    boolean bl6 = false;
                                    Throwable throwable = Result.exceptionOrNull-impl((Object)companion);
                                    if (throwable != null) {
                                        it = throwable;
                                        boolean bl7 = false;
                                        return null;
                                    }
                                    generated = (ZonedDateTime)((Object)companion);
                                    JsonNode jsonNode3 = node.get("bases");
                                    if (!(jsonNode3 instanceof ArrayNode)) {
                                        jsonNode3 = null;
                                    }
                                    if ((object4 = (ArrayNode)jsonNode3) == null) break block27;
                                    Iterable $this$filterIsInstance$iv = (Iterable)object4;
                                    boolean $i$f$filterIsInstance = false;
                                    it = $this$filterIsInstance$iv;
                                    Collection destination$iv$iv = new ArrayList();
                                    boolean $i$f$filterIsInstanceTo = false;
                                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                        if (!(element$iv$iv instanceof ObjectNode)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    Iterable $this$mapNotNull$iv2 = (List)destination$iv$iv;
                                    boolean $i$f$mapNotNull = false;
                                    $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv2;
                                    destination$iv$iv = new ArrayList();
                                    boolean $i$f$mapNotNullTo = false;
                                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                                    boolean $i$f$forEach = false;
                                    Object object9 = $this$forEach$iv$iv$iv.iterator();
                                    while (object9.hasNext()) {
                                        String string7;
                                        Object element$iv$iv$iv2;
                                        Object element$iv$iv = element$iv$iv$iv2 = object9.next();
                                        boolean bl8 = false;
                                        ObjectNode it2 = (ObjectNode)element$iv$iv;
                                        boolean bl9 = false;
                                        JsonNode jsonNode4 = it2.get("sha256");
                                        if (StringKt.nullize((String)(jsonNode4 != null ? jsonNode4.asText() : null), (boolean)true) == null) continue;
                                        boolean bl10 = false;
                                        bl2 = false;
                                        String it$iv$iv = string7;
                                        boolean bl11 = false;
                                        destination$iv$iv.add(it$iv$iv);
                                    }
                                    object4 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                                    if (object4 == null) break block27;
                                    Iterable $this$map$iv = (Iterable)object4;
                                    boolean $i$f$map = false;
                                    $this$mapNotNullTo$iv$iv2 = $this$map$iv;
                                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                        void p1;
                                        object9 = (String)item$iv$iv;
                                        Collection collection = destination$iv$iv;
                                        boolean bl12 = false;
                                        SharedIndexBaseId sharedIndexBaseId = new SharedIndexBaseId((String)p1);
                                        collection.add(sharedIndexBaseId);
                                    }
                                    object4 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                                    if (object4 != null) break block28;
                                }
                                boolean $this$map$iv = false;
                                object4 = SetsKt.emptySet();
                            }
                            bases = object4;
                            Object object10 = sources.get("jdk_hash");
                            string5 = object10 != null && (object10 = object10.asText()) != null ? StringKt.nullize$default((String)object10, (boolean)false, (int)1, null) : null;
                            JsonNode jsonNode = sources.get("jdk_aliases");
                            if (!(jsonNode instanceof ArrayNode)) {
                                jsonNode = null;
                            }
                            if ((object2 = (ArrayNode)jsonNode) == null) break block29;
                            Iterable $i$f$map = (Iterable)object2;
                            string6 = string5;
                            boolean $i$f$mapNotNull = false;
                            void destination$iv$iv = $this$mapNotNull$iv;
                            Collection destination$iv$iv2 = new ArrayList();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                String string8;
                                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                                boolean bl13 = false;
                                JsonNode it = (JsonNode)element$iv$iv;
                                boolean bl14 = false;
                                Object object11 = it;
                                if ((object11 != null && (object11 = object11.asText()) != null ? StringKt.nullize$default((String)object11, (boolean)false, (int)1, null) : null) == null) continue;
                                string8 = string8;
                                bl2 = false;
                                boolean bl15 = false;
                                String it$iv$iv = string8;
                                bl = false;
                                destination$iv$iv2.add(it$iv$iv);
                            }
                            list = (List)destination$iv$iv2;
                            string5 = string6;
                            object2 = CollectionsKt.distinct((Iterable)list);
                            if (object2 != null) break block30;
                        }
                        boolean $this$mapNotNull$iv = false;
                        object2 = CollectionsKt.emptyList();
                    }
                    string4 = (object3 = sources.get("project_id")) != null && (object3 = object3.asText()) != null ? StringKt.nullize$default((String)object3, (boolean)false, (int)1, null) : null;
                    Object object12 = sources.get("project_vcs_commit_id");
                    string3 = object12 != null && (object12 = object12.asText()) != null ? StringKt.nullize$default((String)object12, (boolean)false, (int)1, null) : null;
                    Object object13 = sources.get("maven_package");
                    string2 = object13 != null && (object13 = object13.asText()) != null ? StringKt.nullize$default((String)object13, (boolean)false, (int)1, null) : null;
                    JsonNode jsonNode = sources.get("maven_included_packages");
                    if (!(jsonNode instanceof ArrayNode)) {
                        jsonNode = null;
                    }
                    if ((object = (ArrayNode)jsonNode) == null) break block31;
                    Iterable $this$mapNotNull$iv = (Iterable)object;
                    String string9 = string2;
                    String string10 = string3;
                    String string11 = string4;
                    list = object2;
                    string6 = string5;
                    boolean $i$f$mapNotNull = false;
                    Iterable $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String string12;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl16 = false;
                        JsonNode it = (JsonNode)element$iv$iv;
                        boolean bl17 = false;
                        Object object14 = it;
                        if ((object14 != null && (object14 = object14.asText()) != null ? StringKt.nullize$default((String)object14, (boolean)false, (int)1, null) : null) == null) continue;
                        string12 = string12;
                        bl2 = false;
                        boolean bl18 = false;
                        String it$iv$iv = string12;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    string5 = string6;
                    object2 = list;
                    string4 = string11;
                    string3 = string10;
                    string2 = string9;
                    object = CollectionsKt.toSet((Iterable)list2);
                    if (object != null) break block32;
                }
                boolean $this$mapNotNull$iv = false;
                object = SetsKt.emptySet();
            }
            Object $this$mapNotNull$iv = bases;
            Object object15 = object;
            String string13 = string2;
            String string14 = string3;
            String string15 = string4;
            Object object16 = object2;
            String string16 = string5;
            Object object17 = $this$mapNotNull$iv;
            Object object18 = object15;
            String string17 = string13;
            String string18 = string14;
            String string19 = string15;
            String string20 = string16;
            Object object19 = object16;
            SharedIndexMetadataInfo metadataInfo = new SharedIndexMetadataInfo((List<String>)object19, string20, string19, string18, string17, (Set<String>)object18, (Set<SharedIndexBaseId>)object17);
            IndexInfrastructureVersion indexInfrastructureVersion = this.tryReadInfrastructureVersionOnly(node);
            if (indexInfrastructureVersion == null) {
                return null;
            }
            IndexInfrastructureVersion indexVersions = indexInfrastructureVersion;
            ZonedDateTime zonedDateTime = generated;
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"generated");
            return new SharedIndexMetadata((String)indexName, (String)indexKind, metadataInfo, indexVersions, zonedDateTime);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SharedIndexLookupResult selectBestSuitableIndex(@NotNull IdeIndexInfrastructureVersion ideVersion, @NotNull List<SharedIndexLookupResult> candidates) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
            Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
            Iterable $this$groupBy$iv = candidates;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                SharedIndexLookupResult it = (SharedIndexLookupResult)element$iv$iv;
                boolean bl = false;
                IndexInfrastructureVersion key$iv$iv = it.getIndexVersion();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map nodes = destination$iv$iv;
            IndexInfrastructureVersion indexInfrastructureVersion = ideVersion.pickBestSuitableVersion(nodes.keySet());
            if (indexInfrastructureVersion == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)indexInfrastructureVersion, (String)"ideVersion.pickBestSuita\u2026odes.keys) ?: return null");
            IndexInfrastructureVersion best = indexInfrastructureVersion;
            List list = (List)nodes.get(best);
            return list != null ? (SharedIndexLookupResult)CollectionsKt.firstOrNull((List)list) : null;
        }

        private final byte[] renderJson(Function1<? super ObjectNode, Unit> builder) {
            int $i$f$renderJson = 0;
            try {
                ObjectMapper om = new ObjectMapper();
                ObjectNode root = om.createObjectNode();
                root.put("metadata_version", SharedIndexMetadata.METADATA_VERSION);
                ObjectNode objectNode = root;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"root");
                builder.invoke((Object)objectNode);
                byte[] byArray = om.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"om.writerWithDefaultPret\u2026).writeValueAsBytes(root)");
                return byArray;
            }
            catch (Throwable t) {
                throw (Throwable)new RuntimeException("Failed to generate shared index metadata JSON. " + t.getMessage(), t);
            }
        }

        @JvmStatic
        @NotNull
        public final Path getMetadataPath(@NotNull Path chunkRootPath) {
            Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
            Path path = chunkRootPath.resolve(this.getMetadataPath());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"chunkRootPath.resolve(getMetadataPath())");
            return path;
        }

        @JvmStatic
        @NotNull
        public final String getMetadataPath() {
            return "metadata.json";
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final byte[] writeIndexMetadata(@NotNull SharedIndexMetadata metadata) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Companion this_$iv = this;
            boolean $i$f$renderJson = false;
            try {
                Object object;
                Object object2;
                Object it;
                boolean bl;
                boolean bl2;
                Object object3;
                ObjectMapper om$iv = new ObjectMapper();
                ObjectNode root$iv = om$iv.createObjectNode();
                root$iv.put("metadata_version", SharedIndexMetadata.METADATA_VERSION);
                ObjectNode objectNode = root$iv;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"root");
                ObjectNode root = objectNode;
                boolean bl3 = false;
                SharedIndexMetadataInfo addon = metadata.getSharedIndexInfo();
                Object object4 = root.putObject("sources");
                boolean bl4 = false;
                boolean bl5 = false;
                ObjectNode sources = object4;
                boolean bl6 = false;
                sources.put("generated", metadata.getGenerationTime().format(Companion.getMETADATA_DATE_FORMAT()));
                IndexInfrastructureOs indexInfrastructureOs = IndexInfrastructureOs.getOs();
                Intrinsics.checkNotNullExpressionValue((Object)indexInfrastructureOs, (String)"IndexInfrastructureOs.getOs()");
                sources.put("os", indexInfrastructureOs.getOsName());
                sources.put("os_name", SystemInfo.getOsNameAndVersion());
                sources.put("kind", metadata.getIndexKind());
                sources.put("name", metadata.getIndexName());
                String string2 = addon.getJdkHash();
                if (string2 != null) {
                    object3 = string2;
                    bl2 = false;
                    bl = false;
                    it = object3;
                    boolean bl7 = false;
                    sources.put("jdk_hash", (String)it);
                }
                object3 = addon.getJdkAliases();
                bl2 = false;
                if (object3.isEmpty()) {
                    boolean bl8 = false;
                    object2 = null;
                } else {
                    object2 = object3;
                }
                List list = (List)object2;
                if (list != null) {
                    void $this$mapTo$iv$iv;
                    object3 = list;
                    bl2 = false;
                    bl = false;
                    Object aliases = object3;
                    boolean bl9 = false;
                    ArrayNode arrayNode = sources.putArray("jdk_aliases");
                    boolean bl10 = false;
                    boolean bl11 = false;
                    ArrayNode aliasesNode = arrayNode;
                    boolean bl12 = false;
                    Iterable $this$map$iv = (Iterable)aliases;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        String string3 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl13 = false;
                        String string4 = it2;
                        boolean bl14 = false;
                        void v5 = string4;
                        if (v5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = v5.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                        string4 = string5;
                        bl14 = false;
                        String string6 = string4;
                        if (string6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String string7 = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                        collection.add(string7);
                    }
                    Iterable $this$forEach$iv = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String it3 = (String)element$iv;
                        boolean bl15 = false;
                        aliasesNode.add(it3);
                    }
                }
                String string8 = addon.getProjectId();
                if (string8 != null) {
                    object3 = string8;
                    bl2 = false;
                    bl = false;
                    it = object3;
                    boolean bl16 = false;
                    sources.put("project_id", (String)it);
                }
                String string9 = addon.getProjectVcsCommitId();
                if (string9 != null) {
                    object3 = string9;
                    bl2 = false;
                    bl = false;
                    it = object3;
                    boolean bl17 = false;
                    sources.put("project_vcs_commit_id", (String)it);
                }
                String string10 = addon.getMavenPackage();
                if (string10 != null) {
                    object3 = string10;
                    bl2 = false;
                    bl = false;
                    it = object3;
                    boolean bl18 = false;
                    sources.put("maven_package", (String)it);
                }
                object3 = addon.getMavenIncludedPackages();
                bl2 = false;
                if (!object3.isEmpty()) {
                    object3 = sources.putArray("maven_included_packages");
                    bl2 = false;
                    bl = false;
                    it = object3;
                    boolean bl19 = false;
                    Iterable $this$forEach$iv = CollectionsKt.toSortedSet((Iterable)addon.getMavenIncludedPackages());
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String pkg = (String)element$iv;
                        boolean bl20 = false;
                        it.add(pkg);
                    }
                }
                object4 = addon.getBases();
                bl4 = false;
                if (object4.isEmpty()) {
                    boolean bl21 = false;
                    object = null;
                } else {
                    object = object4;
                }
                Set set = (Set)object;
                if (set != null) {
                    object4 = set;
                    bl4 = false;
                    bl5 = false;
                    Object bases = object4;
                    boolean bl22 = false;
                    object3 = root.putArray("bases");
                    bl2 = false;
                    bl = false;
                    it = object3;
                    boolean bl23 = false;
                    for (SharedIndexBaseId baseId : CollectionsKt.distinct((Iterable)((Iterable)bases))) {
                        it.addObject().put("sha256", baseId.getSha256());
                    }
                }
                object4 = root.putObject("environment");
                bl4 = false;
                bl5 = false;
                Object build = object4;
                boolean bl24 = false;
                IndexInfrastructureOs indexInfrastructureOs2 = IndexInfrastructureOs.getOs();
                Intrinsics.checkNotNullExpressionValue((Object)indexInfrastructureOs2, (String)"IndexInfrastructureOs.getOs()");
                build.put("os", indexInfrastructureOs2.getOsName());
                build.put("os_name", SystemInfo.getOsNameAndVersion());
                object3 = build.putObject("intellij");
                bl2 = false;
                bl = false;
                Object ij = object3;
                boolean bl25 = false;
                ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
                BuildNumber buildNumber = applicationInfo.getBuild();
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
                ij.put("product_code", buildNumber.getProductCode());
                ApplicationInfo applicationInfo2 = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo2, (String)"ApplicationInfo.getInstance()");
                ij.put("version", applicationInfo2.getFullVersion());
                ApplicationInfo applicationInfo3 = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo3, (String)"ApplicationInfo.getInstance()");
                ij.put("build", applicationInfo3.getBuild().toString());
                Companion.putIndexesVersion(root, metadata.getIndexInfrastructureVersion());
                byte[] byArray2 = om$iv.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root$iv);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"om.writerWithDefaultPret\u2026).writeValueAsBytes(root)");
            }
            catch (Throwable t$iv) {
                throw (Throwable)new RuntimeException("Failed to generate shared index metadata JSON. " + t$iv.getMessage(), t$iv);
            }
            return byArray;
        }

        @JvmStatic
        @Nullable
        public final SharedIndexMetadata readIndexesVersion(@NotNull Path chunkRoot) throws IOException {
            Intrinsics.checkNotNullParameter((Object)chunkRoot, (String)"chunkRoot");
            Path metadataPath = this.getMetadataPath(chunkRoot);
            byte[] metadataBytes = Files.readAllBytes(metadataPath);
            return this.tryReadIndexesVersion(metadataBytes);
        }

        @Nullable
        public final SharedIndexMetadata tryReadIndexesVersion(@Nullable byte[] metadata) {
            if (metadata == null) {
                return null;
            }
            ObjectMapper om = new ObjectMapper();
            JsonNode jsonNode = om.readTree(metadata);
            if (!(jsonNode instanceof ObjectNode)) {
                jsonNode = null;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode == null) {
                return null;
            }
            ObjectNode root = objectNode;
            return this.tryReadIndexesVersion(root);
        }

        @NotNull
        public final byte[] writeVersionInfo(@NotNull IndexInfrastructureVersion infrastructureVersion) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)infrastructureVersion, (String)"infrastructureVersion");
            Companion this_$iv = this;
            boolean $i$f$renderJson = false;
            try {
                ObjectMapper om$iv = new ObjectMapper();
                ObjectNode root$iv = om$iv.createObjectNode();
                root$iv.put("metadata_version", SharedIndexMetadata.METADATA_VERSION);
                ObjectNode objectNode = root$iv;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"root");
                ObjectNode root = objectNode;
                boolean bl = false;
                Companion.putIndexesVersion(root, infrastructureVersion);
                byte[] byArray2 = om$iv.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root$iv);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"om.writerWithDefaultPret\u2026).writeValueAsBytes(root)");
            }
            catch (Throwable t$iv) {
                throw (Throwable)new RuntimeException("Failed to generate shared index metadata JSON. " + t$iv.getMessage(), t$iv);
            }
            return byArray;
        }

        /*
         * WARNING - void declaration
         */
        private final void putIndexesVersion(ObjectNode root, IndexInfrastructureVersion infrastructureVersion) {
            void $this$mapTo$iv$iv;
            Iterator iterator;
            boolean bl;
            ObjectNode objectNode = root.putObject("indexes");
            boolean bl2 = false;
            boolean bl3 = false;
            ObjectNode indexes = objectNode;
            boolean bl4 = false;
            indexes.put("weak_hash", infrastructureVersion.getWeakVersionHash());
            indexes.put("weak_base_hash", infrastructureVersion.getWeakBaseVersionHash());
            ObjectNode objectNode2 = infrastructureVersion.getCapabilities();
            Intrinsics.checkNotNullExpressionValue(objectNode2, (String)"infrastructureVersion.capabilities");
            ObjectNode objectNode3 = objectNode2;
            boolean bl5 = false;
            if (!objectNode3.isEmpty()) {
                objectNode3 = indexes.putObject("capabilities");
                bl5 = false;
                bl = false;
                ObjectNode caps = objectNode3;
                boolean bl6 = false;
                Map<IndexInfrastructureCapability, Map<String, String>> map2 = infrastructureVersion.getCapabilities();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"infrastructureVersion.capabilities");
                Object object = map2;
                boolean bl7 = false;
                iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    void cap;
                    Map.Entry entry;
                    Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                    boolean bl8 = false;
                    object = (IndexInfrastructureCapability)entry2.getKey();
                    entry2 = entry;
                    bl8 = false;
                    Map versions = (Map)entry2.getValue();
                    ObjectNode objectNode4 = caps;
                    Intrinsics.checkNotNullExpressionValue((Object)objectNode4, (String)"caps");
                    void v3 = cap;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"cap");
                    String string2 = v3.getCapabilityName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cap.capabilityName");
                    Map map3 = versions;
                    Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"versions");
                    Companion.putObjectFromMap(objectNode4, string2, map3);
                }
            }
            objectNode3 = indexes.putArray("os");
            bl5 = false;
            bl = false;
            ObjectNode os = objectNode3;
            boolean bl9 = false;
            Set<IndexInfrastructureOs> set = infrastructureVersion.getSupportedOs();
            Intrinsics.checkNotNullExpressionValue(set, (String)"infrastructureVersion.supportedOs");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IndexInfrastructureOs indexInfrastructureOs = (IndexInfrastructureOs)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl10 = false;
                void v7 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it");
                String string3 = v7.getOsName();
                collection.add(string3);
            }
            Iterable $this$forEach$iv = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl11 = false;
                os.add(it);
            }
            ObjectNode objectNode5 = indexes;
            Intrinsics.checkNotNullExpressionValue((Object)objectNode5, (String)"indexes");
            Map<String, String> map4 = infrastructureVersion.getBaseIndexes();
            Intrinsics.checkNotNullExpressionValue(map4, (String)"infrastructureVersion.baseIndexes");
            Companion.putObjectFromMap(objectNode5, "base_versions", map4);
            LoadSaveValue loadSaveValue = FiledBasedIndexInfoValue;
            Map<String, IndexInfrastructureFileBasedIndexVersionInfo> map5 = infrastructureVersion.getFileBasedIndexVersionInfos();
            Intrinsics.checkNotNullExpressionValue(map5, (String)"infrastructureVersion.fileBasedIndexVersionInfos");
            Companion.putObjectFromMap(indexes, loadSaveValue, "file_index_versions", map5);
            Map<String, String> map6 = infrastructureVersion.getStubIndexVersions();
            Intrinsics.checkNotNullExpressionValue(map6, (String)"infrastructureVersion.stubIndexVersions");
            Companion.putObjectFromMap(indexes, "stub_index_versions", map6);
            Map<String, String> map7 = infrastructureVersion.getStubFileElementTypeVersions();
            Intrinsics.checkNotNullExpressionValue(map7, (String)"infrastructureVersion.stubFileElementTypeVersions");
            Companion.putObjectFromMap(indexes, "stub_file_element_type_versions", map7);
            Map<String, String> map8 = infrastructureVersion.getHashProviderVersions();
            Intrinsics.checkNotNullExpressionValue(map8, (String)"infrastructureVersion.hashProviderVersions");
            Companion.putObjectFromMap(indexes, "hash_provider_versions", map8);
        }

        @JvmName(name="putObjectFromMap")
        private final void putObjectFromMap(ObjectNode $this$putObjectFromMap, String name, Map<String, String> map2) {
            this.putObjectFromMap($this$putObjectFromMap, TextValue, name, map2);
        }

        /*
         * WARNING - void declaration
         */
        private final <Y> void putObjectFromMap(ObjectNode $this$putObjectFromMap, LoadSaveValue<Y> saveValue, String name, Map<String, ? extends Y> map2) {
            ObjectNode objectNode = $this$putObjectFromMap.putObject(name);
            boolean bl = false;
            boolean bl2 = false;
            ObjectNode obj = objectNode;
            boolean bl3 = false;
            Iterable $this$sortedBy$iv = map2.entrySet();
            boolean $i$f$sortedBy = false;
            boolean bl4 = false;
            Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)a;
                    boolean bl2 = false;
                    String string2 = (String)it.getKey();
                    boolean bl3 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                    it = (Map.Entry)b;
                    Comparable comparable = (Comparable)((Object)string4);
                    bl2 = false;
                    string2 = (String)it.getKey();
                    bl3 = false;
                    String string5 = string2;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                    String string7 = string6;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string7)));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void k;
                Map.Entry $dstr$k$v = (Map.Entry)element$iv;
                boolean bl5 = false;
                Map.Entry entry = $dstr$k$v;
                boolean bl6 = false;
                String string2 = (String)entry.getKey();
                entry = $dstr$k$v;
                bl6 = false;
                Object v = entry.getValue();
                ObjectNode objectNode2 = obj;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"obj");
                saveValue.saveValue(objectNode2, (String)k, v);
            }
        }

        private final SortedMap<String, String> mapFromPath(ObjectNode $this$mapFromPath, String ... path) {
            return this.mapFromPath($this$mapFromPath, TextValue, Arrays.copyOf(path, path.length));
        }

        private final SortedMap<String, String> toMap(ObjectNode $this$toMap) {
            return this.toMap($this$toMap, TextValue);
        }

        private final <Y> SortedMap<String, Y> mapFromPath(ObjectNode $this$mapFromPath, LoadSaveValue<Y> loadValue, String ... path) {
            String[] stringArray = path;
            boolean bl = false;
            if (stringArray.length == 0) {
                return this.toMap($this$mapFromPath, loadValue);
            }
            String first = (String)ArraysKt.first((Object[])path);
            JsonNode jsonNode = $this$mapFromPath.get(first);
            if (!(jsonNode instanceof ObjectNode)) {
                jsonNode = null;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode == null) {
                return null;
            }
            ObjectNode child = objectNode;
            Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])path, (int)1);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return this.mapFromPath(child, loadValue, Arrays.copyOf(stringArray2, stringArray2.length));
        }

        private final <Y> SortedMap<String, Y> toMap(ObjectNode $this$toMap, LoadSaveValue<Y> loadValue) {
            HashMap result2 = new HashMap();
            Iterator iterator = $this$toMap.fieldNames();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"this.fieldNames()");
            Iterator iterator2 = iterator;
            boolean bl = false;
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Y value;
                String key = (String)iterator3.next();
                if (loadValue.loadValue($this$toMap.get(key)) == null) {
                    return null;
                }
                Map map2 = result2;
                String string2 = key;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key");
                map2.put(string2, value);
            }
            return (SortedMap)ImmutableSortedMap.copyOf((Map)result2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bb\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002J\u0019\u0010\u0003\u001a\u0004\u0018\u00018\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a2\u0006\u0002\u0010\u0006J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$LoadSaveValue;", "Y", "", "loadValue", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Object;", "saveValue", "", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "key", "", "value", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Ljava/lang/String;Ljava/lang/Object;)V", "intellij.indexing.shared"})
        private static interface LoadSaveValue<Y> {
            @Nullable
            public Y loadValue(@Nullable JsonNode var1);

            public void saveValue(@NotNull ObjectNode var1, @NotNull String var2, @NotNull Y var3);
        }
    }
}

