/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.intellij.indexing.shared.download.SharedIndexBaseId;
import com.intellij.indexing.shared.generate.IndexedFileHash;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001cJ,\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\f0\u001d\"\u0004\b\u0000\u0010\u001e2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\f0\u001dJ\u0014\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u0005H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/intellij/indexing/shared/generate/SharedIndexBase;", "", "sharedIndexPath", "Ljava/nio/file/Path;", "sharedIndexSha256", "", "sharedIndexSize", "", "metadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "knownHashes", "", "Lcom/intellij/indexing/shared/generate/IndexedFileHash;", "(Ljava/nio/file/Path;Ljava/lang/String;JLcom/intellij/indexing/shared/metadata/SharedIndexMetadata;Ljava/util/Set;)V", "getMetadata", "()Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "getSharedIndexPath", "()Ljava/nio/file/Path;", "getSharedIndexSha256", "()Ljava/lang/String;", "getSharedIndexSize", "()J", "includeHash", "", "hash", "keepOnlyUnknownHashes", "", "hashes", "", "", "Y", "matchedIndexesRatio", "", "allIndexes", "toBaseId", "Lcom/intellij/indexing/shared/download/SharedIndexBaseId;", "toString", "intellij.indexing.shared"})
public final class SharedIndexBase {
    @NotNull
    private final Path sharedIndexPath;
    @NotNull
    private final String sharedIndexSha256;
    private final long sharedIndexSize;
    @NotNull
    private final SharedIndexMetadata metadata;
    private final Set<IndexedFileHash> knownHashes;

    @NotNull
    public final List<IndexedFileHash> keepOnlyUnknownHashes(@NotNull Collection<IndexedFileHash> hashes) {
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        return CollectionsKt.minus((Iterable)hashes, (Iterable)this.knownHashes);
    }

    @NotNull
    public final <Y> Map<Y, IndexedFileHash> keepOnlyUnknownHashes(@NotNull Map<Y, IndexedFileHash> hashes) {
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Map<Y, IndexedFileHash> $this$filterValues$iv = hashes;
        boolean $i$f$filterValues = false;
        LinkedHashMap<Y, IndexedFileHash> result$iv = new LinkedHashMap<Y, IndexedFileHash>();
        Map<Y, IndexedFileHash> map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry<Y, IndexedFileHash> entry$iv : map2.entrySet()) {
            IndexedFileHash it = entry$iv.getValue();
            boolean bl2 = false;
            if (!(!this.knownHashes.contains(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    public final boolean includeHash(@NotNull IndexedFileHash hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.knownHashes.contains(hash);
    }

    @NotNull
    public final SharedIndexBaseId toBaseId() {
        String string2 = this.sharedIndexSha256;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        return new SharedIndexBaseId(string4);
    }

    public final double matchedIndexesRatio(@NotNull Set<IndexedFileHash> allIndexes) {
        Intrinsics.checkNotNullParameter(allIndexes, (String)"allIndexes");
        return (double)CollectionsKt.intersect((Iterable)this.knownHashes, (Iterable)allIndexes).size() / (double)this.knownHashes.size();
    }

    @NotNull
    public String toString() {
        return "SharedIndexBase(" + this.sharedIndexSha256 + ": hashes: " + this.knownHashes.size() + ", size " + StringUtil.formatFileSize((long)this.sharedIndexSize) + ", file: " + this.sharedIndexPath + ')';
    }

    @NotNull
    public final Path getSharedIndexPath() {
        return this.sharedIndexPath;
    }

    @NotNull
    public final String getSharedIndexSha256() {
        return this.sharedIndexSha256;
    }

    public final long getSharedIndexSize() {
        return this.sharedIndexSize;
    }

    @NotNull
    public final SharedIndexMetadata getMetadata() {
        return this.metadata;
    }

    public SharedIndexBase(@NotNull Path sharedIndexPath, @NotNull String sharedIndexSha256, long sharedIndexSize, @NotNull SharedIndexMetadata metadata, @NotNull Set<IndexedFileHash> knownHashes2) {
        Intrinsics.checkNotNullParameter((Object)sharedIndexPath, (String)"sharedIndexPath");
        Intrinsics.checkNotNullParameter((Object)sharedIndexSha256, (String)"sharedIndexSha256");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(knownHashes2, (String)"knownHashes");
        this.sharedIndexPath = sharedIndexPath;
        this.sharedIndexSha256 = sharedIndexSha256;
        this.sharedIndexSize = sharedIndexSize;
        this.metadata = metadata;
        this.knownHashes = knownHashes2;
    }
}

