/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.intellij.indexing.shared.generate.EnumeratedHashedIndexedFiles;
import com.intellij.indexing.shared.generate.ErrorsCollector;
import com.intellij.indexing.shared.generate.HashedIndexedFiles;
import com.intellij.indexing.shared.generate.IndexChunk;
import com.intellij.indexing.shared.generate.IndexedFileContentLoader;
import com.intellij.indexing.shared.generate.IndexedFilesCollector;
import com.intellij.indexing.shared.generate.IndexedFilesReporter;
import com.intellij.indexing.shared.generate.IndexesExporterEP;
import com.intellij.indexing.shared.generate.IndexesExporterGenerators;
import com.intellij.indexing.shared.generate.IndexesExporterHashEnumerateTask;
import com.intellij.indexing.shared.generate.IndexesExporterMainIndex;
import com.intellij.indexing.shared.generate.IndexesExporterRequest;
import com.intellij.indexing.shared.generate.IndexesExporterState;
import com.intellij.indexing.shared.generate.IndexesExporterTaskResult;
import com.intellij.indexing.shared.generate.diagnostic.IndexExportStatistics;
import com.intellij.indexing.shared.generate.diagnostic.IndexExportStatisticsDumper;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

class IndexesExporterTask {
    private static final Logger LOG = Logger.getInstance(IndexesExporterTask.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final IndexesExporterState myState;
    @NotNull
    private final ErrorsCollector myErrorsCollector;
    @NotNull
    private final IndexesExporterRequest myRequest;

    IndexesExporterTask(@NotNull Project project2, @NotNull IndexesExporterState state, @NotNull IndexesExporterRequest request, @NotNull ErrorsCollector errorsCollector) {
        if (project2 == null) {
            IndexesExporterTask.$$$reportNull$$$0(0);
        }
        if (state == null) {
            IndexesExporterTask.$$$reportNull$$$0(1);
        }
        if (request == null) {
            IndexesExporterTask.$$$reportNull$$$0(2);
        }
        if (errorsCollector == null) {
            IndexesExporterTask.$$$reportNull$$$0(3);
        }
        this.myProject = project2;
        this.myState = state;
        this.myRequest = request;
        this.myErrorsCollector = errorsCollector;
    }

    @NotNull
    public IndexesExporterTaskResult exportIndexesChunk(@NotNull ProgressIndicator indicator, @NotNull Path chunkRoot) throws Exception {
        if (indicator == null) {
            IndexesExporterTask.$$$reportNull$$$0(4);
        }
        if (chunkRoot == null) {
            IndexesExporterTask.$$$reportNull$$$0(5);
        }
        IndexedFileContentLoader fileContentLoader = new IndexedFileContentLoader(this.myProject, this.myErrorsCollector, this.myState.getNoSizeLimitApplicableFileTypes());
        IndexedFilesReporter reporter = null;
        Path targetForListDump = this.myRequest.getTargetIndexedFilesListDump();
        if (targetForListDump != null) {
            LOG.info("List of indexed files reports will be dumped to " + targetForListDump);
            reporter = new IndexedFilesReporter(targetForListDump);
        }
        HashedIndexedFiles filesToBeIndexedSet = new IndexedFilesCollector(this.myProject, this.myRequest, this.myErrorsCollector, reporter).collectFilesForIndexing(indicator, fileContentLoader);
        EnumeratedHashedIndexedFiles hashEnumeration = new IndexesExporterHashEnumerateTask(this.myErrorsCollector, reporter).enumerateHashes(filesToBeIndexedSet, chunkRoot, indicator);
        SharedIndexMetadataInfo additionalMetadata = this.myRequest.getAdditionalMetadata().includeBases(filesToBeIndexedSet.getUsedBases());
        this.myState.withActualHashGeneratorVersions(filesToBeIndexedSet.getUsedHashes());
        IndexesExporterTaskResult indexesExporterTaskResult = this.generateIndexes(chunkRoot, hashEnumeration, fileContentLoader, additionalMetadata, indicator);
        if (indexesExporterTaskResult == null) {
            IndexesExporterTask.$$$reportNull$$$0(6);
        }
        return indexesExporterTaskResult;
    }

    private IndexesExporterTaskResult generateIndexes(@NotNull Path chunkRoot, @NotNull EnumeratedHashedIndexedFiles files2, @NotNull IndexedFileContentLoader fileContentLoader, @NotNull SharedIndexMetadataInfo additionalMetadata, @NotNull ProgressIndicator indicator) throws Exception {
        if (chunkRoot == null) {
            IndexesExporterTask.$$$reportNull$$$0(7);
        }
        if (files2 == null) {
            IndexesExporterTask.$$$reportNull$$$0(8);
        }
        if (fileContentLoader == null) {
            IndexesExporterTask.$$$reportNull$$$0(9);
        }
        if (additionalMetadata == null) {
            IndexesExporterTask.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            IndexesExporterTask.$$$reportNull$$$0(11);
        }
        IndexExportStatistics exportStatistics = new IndexExportStatistics(this.myRequest.getChunk().getName(), this.myRequest.getChunk().getKind());
        IndexesExporterGenerators generators = new IndexesExporterGenerators(chunkRoot, this.myState, this.myRequest);
        try (AutoCloseable ignored = generators.openAndClose(indicator);){
            new IndexesExporterMainIndex(this.myProject, this.myErrorsCollector, fileContentLoader, this.myRequest).generateMainIndex(generators, files2, indicator, exportStatistics);
            new IndexesExporterEP(this.myProject, this.myRequest, this.myErrorsCollector, chunkRoot, this.myState).executeExtensionPoints(files2, indicator);
        }
        indicator.setIndeterminate(true);
        indicator.setText(SharedIndexesBundle.message("progress.text.finalizing.indexes", new Object[0]));
        generators.deleteEmptyIndexes();
        generators.exportStatistics(exportStatistics);
        IndexChunk chunk2 = this.myRequest.getChunk();
        IndexInfrastructureVersion indexVersion2 = this.myState.getIndexVersion();
        UnaryOperator<IndexInfrastructureVersion> testIndexVersionModifier = this.myRequest.getTestOnlyIndexVersionModifier();
        if (testIndexVersionModifier != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            throw new AssertionError((Object)"index version can be modified only for testing purposes");
        }
        byte[] metadataBytes = SharedIndexMetadata.writeIndexMetadata(new SharedIndexMetadata(chunk2.getName(), chunk2.getKind(), additionalMetadata, testIndexVersionModifier == null ? indexVersion2 : (IndexInfrastructureVersion)testIndexVersionModifier.apply(indexVersion2)));
        Files.write(SharedIndexMetadata.getMetadataPath(chunkRoot), metadataBytes, new OpenOption[0]);
        LOG.info("Statistics\n" + IndexExportStatisticsDumper.INSTANCE.getPresentableStatistics(exportStatistics));
        return new IndexesExporterTaskResult(metadataBytes, indexVersion2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsCollector";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/generate/IndexesExporterTask";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContentLoader";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/generate/IndexesExporterTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "exportIndexesChunk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "exportIndexesChunk";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateIndexes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

