/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.intellij.indexing.shared.generate.ErrorsCollector;
import com.intellij.indexing.shared.generate.IndexedFileHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.util.Computable;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedHashesSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/generate/IndexesExporterHasher;", "", "providers", "", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "errorsCollector", "Lcom/intellij/indexing/shared/generate/ErrorsCollector;", "(Ljava/util/List;Lcom/intellij/indexing/shared/generate/ErrorsCollector;)V", "getErrorsCollector", "()Lcom/intellij/indexing/shared/generate/ErrorsCollector;", "generators", "", "[Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "computeHash", "Lcom/intellij/indexing/shared/generate/IndexedFileHash;", "fileContent", "Lcom/intellij/util/indexing/FileContentImpl;", "computeHashImpl", "intellij.indexing.shared"})
public final class IndexesExporterHasher {
    private final SharedIndexContentHashProvider[] generators;
    @NotNull
    private final ErrorsCollector errorsCollector;

    @Nullable
    public final IndexedFileHash computeHash(@NotNull FileContentImpl fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        boolean $i$f$runReadAction = false;
        return (IndexedFileHash)ApplicationManager.getApplication().runReadAction(new Computable<T>(this, fileContent){
            final /* synthetic */ IndexesExporterHasher this$0;
            final /* synthetic */ FileContentImpl $fileContent$inlined;
            {
                this.this$0 = indexesExporterHasher;
                this.$fileContent$inlined = fileContentImpl;
            }

            public final T compute() {
                boolean bl = false;
                return (T)IndexesExporterHasher.access$computeHashImpl(this.this$0, this.$fileContent$inlined);
            }
        });
    }

    private final IndexedFileHash computeHashImpl(FileContentImpl fileContent) {
        HashMap hashMap = new HashMap();
        for (SharedIndexContentHashProvider generator : this.generators) {
            byte[] byArray;
            try {
                if (generator.computeHash((IndexedFile)fileContent) == null) {
                    continue;
                }
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                this.errorsCollector.fileHashError((FileContent)fileContent, "Failed to compute hash with " + generator.getInfo().getProviderId(), t);
                continue;
            }
            byte[] hash = byArray;
            ((Map)hashMap).put(generator.getInfo(), hash);
        }
        byte[] legacyHash = IndexedHashesSupport.getOrInitIndexedHash((FileContentImpl)fileContent);
        Intrinsics.checkNotNullExpressionValue((Object)legacyHash, (String)"legacyHash");
        return new IndexedFileHash(legacyHash, hashMap);
    }

    @NotNull
    public final ErrorsCollector getErrorsCollector() {
        return this.errorsCollector;
    }

    public IndexesExporterHasher(@NotNull List<? extends SharedIndexContentHashProvider> providers, @NotNull ErrorsCollector errorsCollector) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        this.errorsCollector = errorsCollector;
        Collection $this$toTypedArray$iv = providers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SharedIndexContentHashProvider[] sharedIndexContentHashProviderArray = thisCollection$iv.toArray(new SharedIndexContentHashProvider[0]);
        if (sharedIndexContentHashProviderArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.generators = sharedIndexContentHashProviderArray;
    }

    public static final /* synthetic */ IndexedFileHash access$computeHashImpl(IndexesExporterHasher $this, FileContentImpl fileContent) {
        return $this.computeHashImpl(fileContent);
    }
}

