/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.intellij.indexing.shared.generate.IndexedFileHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentEnumerators;
import com.intellij.util.hash.ContentHashEnumerator;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/indexing/shared/generate/IndexesExporterHashEnumerator;", "Ljava/lang/AutoCloseable;", "chunkRoot", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "hashEnumerator", "Lcom/intellij/util/hash/ContentHashEnumerator;", "close", "", "enumerateHash", "", "hash", "Lcom/intellij/indexing/shared/generate/IndexedFileHash;", "intellij.indexing.shared"})
public final class IndexesExporterHashEnumerator
implements AutoCloseable {
    private final ContentHashEnumerator hashEnumerator;

    @Override
    public void close() throws Exception {
        this.hashEnumerator.close();
    }

    public final int enumerateHash(@NotNull IndexedFileHash hash) {
        int n;
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        try {
            n = this.hashEnumerator.enumerate(hash.getHash());
            boolean bl = false;
            n = Math.abs(n);
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Hash enumerator is corrupted", e);
        }
        return n;
    }

    public IndexesExporterHashEnumerator(@NotNull Path chunkRoot) {
        Intrinsics.checkNotNullParameter((Object)chunkRoot, (String)"chunkRoot");
        this.hashEnumerator = SharedIndexContentEnumerators.INSTANCE.newEnumeratorForGenerator(chunkRoot);
    }
}

