/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.google.common.collect.ImmutableList;
import com.intellij.indexing.shared.generate.HashBasedIndexGenerator;
import com.intellij.indexing.shared.generate.IndexesExporterRequest;
import com.intellij.indexing.shared.generate.IndexesExporterState;
import com.intellij.indexing.shared.generate.SharedIndexNoStubFileTypeBean;
import com.intellij.indexing.shared.generate.StubHashBasedIndexGenerator;
import com.intellij.indexing.shared.generate.diagnostic.IndexExportStatistics;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.impl.EmptyIndexEnumerator;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IndexesExporterGenerators {
    @NotNull
    private final Path myChunkRoot;
    @NotNull
    private final IndexesExporterState myIndexers;
    final StubHashBasedIndexGenerator stubGenerator;
    final List<HashBasedIndexGenerator<?, ?>> fileBasedGenerators;
    final List<HashBasedIndexGenerator<?, ?>> allGenerators;

    IndexesExporterGenerators(@NotNull Path chunkRoot, @NotNull IndexesExporterState indexers, @NotNull IndexesExporterRequest request) {
        if (chunkRoot == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(0);
        }
        if (indexers == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(1);
        }
        if (request == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(2);
        }
        this.myChunkRoot = chunkRoot;
        this.myIndexers = indexers;
        this.stubGenerator = new StubHashBasedIndexGenerator(this.myChunkRoot, indexers.exportableStubIndexExtensions, ContainerUtil.map2SetNotNull((Collection)ContainerUtil.union(request.getNoStubTreeFileType(), SharedIndexNoStubFileTypeBean.getFileTypeNamesWithNoStubFromEp()), ftName -> FileTypeManager.getInstance().findFileTypeByName(ftName)));
        this.fileBasedGenerators = ContainerUtil.map(indexers.exportableFileBasedIndexExtensions, ex -> new HashBasedIndexGenerator(ex, this.myChunkRoot));
        this.allGenerators = ImmutableList.builder().addAll(this.fileBasedGenerators).add((Object)this.stubGenerator).build();
    }

    private void openGenerators() {
        for (HashBasedIndexGenerator<?, ?> generator : this.allGenerators) {
            try {
                generator.openIndex();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open " + generator.getIndexName() + ". " + e.getMessage(), e);
            }
        }
    }

    private void closeGenerators() {
        for (HashBasedIndexGenerator<?, ?> generator : this.allGenerators) {
            try {
                generator.closeIndex();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to close " + generator.getIndexName() + ". " + e.getMessage(), e);
            }
        }
        Set<IFileElementType> fileElementTypes = this.stubGenerator.getIndexedFileTypes().stream().filter(t -> t instanceof LanguageFileType).map(t -> ((LanguageFileType)t).getLanguage()).map(l -> (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l)).filter(Objects::nonNull).map(def -> def.getFileNodeType()).collect(Collectors.toSet());
        this.myIndexers.withStubFileTypeElements(fileElementTypes);
    }

    @NotNull
    public AutoCloseable openAndClose(final @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(3);
        }
        this.openGenerators();
        return new AutoCloseable(){

            @Override
            public void close() {
                indicator.setIndeterminate(true);
                indicator.setText(SharedIndexesBundle.message("progress.text.closing.indexes", new Object[0]));
                IndexesExporterGenerators.this.closeGenerators();
            }
        };
    }

    public void deleteEmptyIndexes() {
        IndexesExporterGenerators.deleteEmptyIndices(this.fileBasedGenerators, this.myChunkRoot, false);
        IndexesExporterGenerators.deleteEmptyIndices(this.stubGenerator.getStubGenerators(), this.myChunkRoot, true);
    }

    public void exportStatistics(@NotNull IndexExportStatistics exportStatistics) {
        if (exportStatistics == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(4);
        }
        for (HashBasedIndexGenerator<?, ?> generator : this.fileBasedGenerators) {
            exportStatistics.getFbiNameToNumberOfIndexedFiles().put(generator.getIndexName(), generator.getIndexedFilesNumber());
            if (generator.isEmpty()) {
                exportStatistics.getEmptyFbiIndexes().add(generator.getIndexName());
                continue;
            }
            exportStatistics.getFbiNameToDirectorySize().put(generator.getIndexName(), UtilKt.getFileOrDirectorySize(generator.getIndexRoot()));
        }
        for (HashBasedIndexGenerator<?, ?> generator : this.stubGenerator.getStubGenerators()) {
            exportStatistics.getStubIndexNameToNumberOfIndexedFiles().put(generator.getIndexName(), generator.getIndexedFilesNumber());
            if (generator.isEmpty()) {
                exportStatistics.getEmptyStubIndexes().add(generator.getIndexName());
                continue;
            }
            exportStatistics.getStubNameToDirectorySize().put(generator.getIndexName(), UtilKt.getFileOrDirectorySize(generator.getIndexRoot()));
        }
    }

    private static void deleteEmptyIndices(@NotNull List<HashBasedIndexGenerator<?, ?>> generators, @NotNull Path chunkRoot, boolean stubs) {
        if (generators == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(5);
        }
        if (chunkRoot == null) {
            IndexesExporterGenerators.$$$reportNull$$$0(6);
        }
        TreeSet<String> emptyIndices = new TreeSet<String>();
        for (HashBasedIndexGenerator<?, ?> generator : generators) {
            if (!generator.isEmpty()) continue;
            emptyIndices.add(generator.getIndexName());
            Path indexRoot = generator.getIndexRoot();
            PathKt.delete((Path)indexRoot);
        }
        try {
            if (stubs) {
                EmptyIndexEnumerator.writeEmptyStubIndexes(chunkRoot, emptyIndices);
            } else {
                EmptyIndexEnumerator.writeEmptyIndexes(chunkRoot, emptyIndices);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deleteEmptyIndices. " + e.getMessage(), e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportStatistics";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generators";
                break;
            }
        }
        objectArray2[1] = "com/intellij/indexing/shared/generate/IndexesExporterGenerators";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "openAndClose";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "exportStatistics";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteEmptyIndices";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

