/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.intellij.indexing.shared.generate.EnumeratedHashedIndexedFiles;
import com.intellij.indexing.shared.generate.ErrorsCollector;
import com.intellij.indexing.shared.generate.IndexChunk;
import com.intellij.indexing.shared.generate.IndexesExporterExtension;
import com.intellij.indexing.shared.generate.IndexesExporterExtensionKt;
import com.intellij.indexing.shared.generate.IndexesExporterRequest;
import com.intellij.indexing.shared.generate.IndexesExporterState;
import com.intellij.indexing.shared.generate.SharedIndexWriter;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureCapability;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/generate/IndexesExporterEP;", "", "project", "Lcom/intellij/openapi/project/Project;", "myRequest", "Lcom/intellij/indexing/shared/generate/IndexesExporterRequest;", "errorsCollector", "Lcom/intellij/indexing/shared/generate/ErrorsCollector;", "indexRootPath", "Ljava/nio/file/Path;", "state", "Lcom/intellij/indexing/shared/generate/IndexesExporterState;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/indexing/shared/generate/IndexesExporterRequest;Lcom/intellij/indexing/shared/generate/ErrorsCollector;Ljava/nio/file/Path;Lcom/intellij/indexing/shared/generate/IndexesExporterState;)V", "executeExtensionPoints", "", "files", "Lcom/intellij/indexing/shared/generate/EnumeratedHashedIndexedFiles;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getSharedIndexWriter", "Lcom/intellij/indexing/shared/generate/SharedIndexWriter;", "intellij.indexing.shared"})
public final class IndexesExporterEP {
    private final Project project;
    private final IndexesExporterRequest myRequest;
    private final ErrorsCollector errorsCollector;
    private final Path indexRootPath;
    private final IndexesExporterState state;

    public final void executeExtensionPoints(@NotNull EnumeratedHashedIndexedFiles files2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        SharedIndexWriter writer = this.getSharedIndexWriter(files2);
        IndexesExporterExtensionKt.access$getEP_NAME$p().forEachExtensionSafe((Consumer)new Consumer<IndexesExporterExtension>(this, indicator, writer){
            final /* synthetic */ IndexesExporterEP this$0;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ SharedIndexWriter $writer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void accept(IndexesExporterExtension ext) {
                if (!IndexesExporterEP.access$getMyRequest$p(this.this$0).getAdditionalIndexes().contains(ext.getId())) {
                    return;
                }
                this.$indicator.pushState();
                try {
                    this.$indicator.setText(SharedIndexesBundle.message("index.exporter.processing.exporter.extension", ext.getExtensionPresentableName()));
                    ext.generateAdditionalIndexes(this.$writer, this.$indicator);
                }
                catch (Throwable t) {
                    IndexesExporterEP.access$getErrorsCollector$p(this.this$0).genericError("Failed to generate index for " + ext.getClass().getName() + ". " + t.getMessage(), t);
                }
                finally {
                    this.$indicator.popState();
                }
            }
            {
                this.this$0 = indexesExporterEP;
                this.$indicator = progressIndicator;
                this.$writer = sharedIndexWriter;
            }
        });
    }

    private final SharedIndexWriter getSharedIndexWriter(EnumeratedHashedIndexedFiles files2) {
        return new SharedIndexWriter(this, files2){
            @NotNull
            private final Set<VirtualFile> allFiles;
            @NotNull
            private final Set<VirtualFile> inputFiles;
            final /* synthetic */ IndexesExporterEP this$0;
            final /* synthetic */ EnumeratedHashedIndexedFiles $files;

            @NotNull
            public final Set<VirtualFile> getAllFiles() {
                return this.allFiles;
            }

            @NotNull
            public Project getProject() {
                return IndexesExporterEP.access$getProject$p(this.this$0);
            }

            @NotNull
            public Path getIndexRootPath() {
                return IndexesExporterEP.access$getIndexRootPath$p(this.this$0);
            }

            @NotNull
            public IndexChunk getChunk() {
                return IndexesExporterEP.access$getMyRequest$p(this.this$0).getChunk();
            }

            @NotNull
            public Set<VirtualFile> getInputFiles() {
                return this.inputFiles;
            }

            @NotNull
            public ErrorsCollector getErrorsCollector() {
                return IndexesExporterEP.access$getErrorsCollector$p(this.this$0);
            }

            @Nullable
            public Integer getEnumeratedHashId(@NotNull VirtualFile fileOrDirectory) {
                Intrinsics.checkNotNullParameter((Object)fileOrDirectory, (String)"fileOrDirectory");
                return this.$files.getIds().get(fileOrDirectory);
            }

            public void pushCapability(@NotNull IndexInfrastructureCapability capability, @NotNull Map<String, String> versions) {
                Intrinsics.checkNotNullParameter((Object)capability, (String)"capability");
                Intrinsics.checkNotNullParameter(versions, (String)"versions");
                IndexesExporterEP.access$getState$p(this.this$0).registerCapability(capability, versions);
            }
            {
                this.this$0 = this$0;
                this.$files = $captured_local_variable$1;
                this.allFiles = $captured_local_variable$1.getAllFiles();
                this.inputFiles = this.allFiles;
            }
        };
    }

    public IndexesExporterEP(@NotNull Project project2, @NotNull IndexesExporterRequest myRequest, @NotNull ErrorsCollector errorsCollector, @NotNull Path indexRootPath, @NotNull IndexesExporterState state) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myRequest, (String)"myRequest");
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        Intrinsics.checkNotNullParameter((Object)indexRootPath, (String)"indexRootPath");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.project = project2;
        this.myRequest = myRequest;
        this.errorsCollector = errorsCollector;
        this.indexRootPath = indexRootPath;
        this.state = state;
    }

    public static final /* synthetic */ IndexesExporterRequest access$getMyRequest$p(IndexesExporterEP $this) {
        return $this.myRequest;
    }

    public static final /* synthetic */ ErrorsCollector access$getErrorsCollector$p(IndexesExporterEP $this) {
        return $this.errorsCollector;
    }

    public static final /* synthetic */ Project access$getProject$p(IndexesExporterEP $this) {
        return $this.project;
    }

    public static final /* synthetic */ Path access$getIndexRootPath$p(IndexesExporterEP $this) {
        return $this.indexRootPath;
    }

    public static final /* synthetic */ IndexesExporterState access$getState$p(IndexesExporterEP $this) {
        return $this.state;
    }
}

