/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.generate.IndexedFileHash;
import com.intellij.indexing.shared.generate.IndexesExporterBasesLoaderKt;
import com.intellij.indexing.shared.generate.SharedIndexBase;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.IdeIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentEnumerators;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.PersistentEnumeratorBase;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"loadSharedIndexAsBase", "Lcom/intellij/indexing/shared/generate/SharedIndexBase;", "sharedIndex", "Ljava/nio/file/Path;", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/IdeIndexInfrastructureVersion;", "tempRoot", "intellij.indexing.shared"})
public final class IndexesExporterBasesLoaderKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final SharedIndexBase loadSharedIndexAsBase(@NotNull Path sharedIndex, @NotNull IdeIndexInfrastructureVersion ideVersion, @NotNull Path tempRoot) {
        void size;
        Pair pair;
        HashSet hashSet;
        boolean $i$a$-use-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$22;
        Path unpackRoot;
        Object object;
        boolean $i$a$-singleOrNull-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$ext$22;
        Object element$iv;
        Object single$iv;
        boolean $i$f$singleOrNull2;
        Object $this$singleOrNull$iv;
        block37: {
            Intrinsics.checkNotNullParameter((Object)sharedIndex, (String)"sharedIndex");
            Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
            Intrinsics.checkNotNullParameter((Object)tempRoot, (String)"tempRoot");
            $this$singleOrNull$iv = SharedIndexCompression.values();
            $i$f$singleOrNull2 = false;
            single$iv = null;
            boolean found$iv222 = false;
            SharedIndexCompression[] sharedIndexCompressionArray = $this$singleOrNull$iv;
            int n = sharedIndexCompressionArray.length;
            for (int i = 0; i < n; ++i) {
                SharedIndexCompression it = element$iv = sharedIndexCompressionArray[i];
                $i$a$-singleOrNull-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$ext$22 = false;
                if (!StringsKt.endsWith$default((String)((Object)sharedIndex.getFileName()).toString(), (String)(".ijx" + it.getExtensionSuffix()), (boolean)false, (int)2, null)) continue;
                if (found$iv222) {
                    object = null;
                    break block37;
                }
                single$iv = element$iv;
                found$iv222 = true;
            }
            object = !found$iv222 ? null : single$iv;
        }
        if (object == null) {
            $this$singleOrNull$iv = "Failed to resolve extension to shared index compression";
            $i$f$singleOrNull2 = false;
            throw (Throwable)new IllegalStateException($this$singleOrNull$iv.toString());
        }
        SharedIndexCompression ext = object;
        String $i$f$singleOrNull2 = ((Object)sharedIndex.getFileName()).toString();
        single$iv = null;
        File found$iv222 = tempRoot.toFile();
        Path path = unpackRoot = FilesKt.createTempDir$default((String)$i$f$singleOrNull2, single$iv, (File)found$iv222, (int)2, null).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"unpackRoot");
        PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
        byte[] metadataBytes = null;
        single$iv = PathKt.inputStream((Path)sharedIndex);
        int found$iv222 = 0x100000;
        boolean bl = false;
        single$iv = single$iv instanceof BufferedInputStream ? (BufferedInputStream)single$iv : new BufferedInputStream((InputStream)single$iv, found$iv222);
        found$iv222 = 0;
        bl = false;
        Object object2 = null;
        try {
            BufferedInputStream compressedStream = (BufferedInputStream)single$iv;
            $i$a$-use-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$22 = false;
            element$iv = ext.createUnpackingStream(compressedStream);
            boolean it = false;
            $i$a$-singleOrNull-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$ext$22 = false;
            Throwable $i$a$-singleOrNull-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$ext$22 = null;
            try {
                InputStream uncompressedZipStream = (InputStream)element$iv;
                boolean bl2 = false;
                Closeable closeable = new ZipInputStream(uncompressedZipStream);
                boolean bl3 = false;
                boolean bl4 = false;
                Object object3 = null;
                try {
                    ZipInputStream zip = (ZipInputStream)closeable;
                    boolean bl5 = false;
                    while (zip.getNextEntry() != null) {
                        String name;
                        ZipEntry next;
                        if (next.isDirectory()) continue;
                        String string2 = name = next.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                        if (SharedIndexContentEnumerators.INSTANCE.isRelatedToEnumerator(string2)) {
                            byte[] bytes = ByteStreamsKt.readBytes((InputStream)zip);
                            PathKt.write$default((Path)PathKt.div((Path)unpackRoot, (String)name), (byte[])bytes, (int)0, (int)0, (int)6, null);
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)name, (Object)SharedIndexMetadata.Companion.getMetadataPath())) continue;
                        metadataBytes = ByteStreamsKt.readBytes((InputStream)zip);
                    }
                    zip = Unit.INSTANCE;
                }
                catch (Throwable zip) {
                    object3 = zip;
                    throw zip;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
                }
                uncompressedZipStream = Unit.INSTANCE;
            }
            catch (Throwable uncompressedZipStream) {
                $i$a$-singleOrNull-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$ext$22 = uncompressedZipStream;
                throw uncompressedZipStream;
            }
            finally {
                CloseableKt.closeFinally((Closeable)element$iv, (Throwable)$i$a$-singleOrNull-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$ext$22);
            }
            compressedStream = Unit.INSTANCE;
        }
        catch (Throwable compressedStream) {
            object2 = compressedStream;
            throw compressedStream;
        }
        finally {
            CloseableKt.closeFinally((Closeable)single$iv, (Throwable)object2);
        }
        if (metadataBytes == null) {
            single$iv = "Failed to find metadata.json entry";
            found$iv222 = 0;
            throw (Throwable)new IllegalStateException(single$iv.toString());
        }
        SharedIndexMetadata metadata = SharedIndexMetadata.Companion.tryReadIndexesVersion(metadataBytes);
        if (metadata == null) {
            String found$iv222 = "Failed to read metadata.json";
            boolean bl6 = false;
            throw (Throwable)new IllegalStateException(found$iv222.toString());
        }
        if (!ideVersion.isSuitableVersion(metadata.getIndexInfrastructureVersion())) {
            String found$iv222 = "The shared index (" + metadata + ") is not compatible with the current version (" + ideVersion + ')';
            boolean bl7 = false;
            throw (Throwable)new IllegalStateException(found$iv222.toString());
        }
        try {
            object2 = (Closeable)SharedIndexContentEnumerators.INSTANCE.openEnumeratorForAttachedSharedIndex(unpackRoot);
            boolean compressedStream = false;
            $i$a$-use-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$22 = false;
            Throwable $i$a$-use-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$22 = null;
            try {
                void $this$mapTo$iv$iv;
                ContentHashEnumerator enumerator = (ContentHashEnumerator)object2;
                boolean bl8 = false;
                Collection collection = enumerator.getAllDataObjects((PersistentEnumeratorBase.DataFilter)loadSharedIndexAsBase.knownHashes.1.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"enumerator.getAllDataObjects { true }");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    byte[] bl5 = (byte[])item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl9 = false;
                    void v4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                    IndexedFileHash indexedFileHash = new IndexedFileHash((byte[])v4, null, 2, null);
                    collection2.add(indexedFileHash);
                }
                hashSet = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            }
            catch (Throwable throwable) {
                $i$a$-use-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$22 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)$i$a$-use-IndexesExporterBasesLoaderKt$loadSharedIndexAsBase$22);
            }
            object2 = hashSet;
        }
        catch (Throwable t) {
            throw (Throwable)new RuntimeException("Failed to load ContentHashEnumerator. " + t.getMessage(), t);
        }
        finally {
            PathKt.delete$default((Path)unpackRoot, (boolean)false, (int)1, null);
        }
        Object knownHashes2 = object2;
        try {
            pair = TuplesKt.to((Object)PathKt.size((Path)sharedIndex), (Object)UtilKt.sha256(sharedIndex));
        }
        catch (Throwable t) {
            throw (Throwable)new RuntimeException("Cannot compute size and sha256 for the shared index. " + t.getMessage(), t);
        }
        hashSet = pair;
        long l = ((Number)hashSet.component1()).longValue();
        String sha256 = (String)hashSet.component2();
        return new SharedIndexBase(sharedIndex, sha256, (long)size, metadata, (Set)knownHashes2);
    }
}

