/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.intellij.indexing.shared.generate.ErrorsCollector;
import com.intellij.indexing.shared.generate.HashedIndexedFiles;
import com.intellij.indexing.shared.generate.IndexedFileContentLoader;
import com.intellij.indexing.shared.generate.IndexedFileHash;
import com.intellij.indexing.shared.generate.IndexedFilesHashingTaskKt;
import com.intellij.indexing.shared.generate.IndexedFilesHashingTaskParameters;
import com.intellij.indexing.shared.generate.IndexesExporterHasher;
import com.intellij.indexing.shared.generate.IndexesExporterHasherKt;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/indexing/shared/generate/IndexedFilesHashingTask;", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "Lcom/intellij/indexing/shared/generate/IndexedFilesHashingTaskParameters;", "fileContentLoader", "Lcom/intellij/indexing/shared/generate/IndexedFileContentLoader;", "errorsCollector", "Lcom/intellij/indexing/shared/generate/ErrorsCollector;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/indexing/shared/generate/IndexedFilesHashingTaskParameters;Lcom/intellij/indexing/shared/generate/IndexedFileContentLoader;Lcom/intellij/indexing/shared/generate/ErrorsCollector;)V", "computeFileHashes", "Lcom/intellij/indexing/shared/generate/HashedIndexedFiles;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "providerToFiles", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.indexing.shared"})
public final class IndexedFilesHashingTask {
    private final Project project;
    private final IndexedFilesHashingTaskParameters parameters;
    private final IndexedFileContentLoader fileContentLoader;
    private final ErrorsCollector errorsCollector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final HashedIndexedFiles computeFileHashes(@NotNull ProgressIndicator indicator, @NotNull Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> providerToFiles) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(providerToFiles, (String)"providerToFiles");
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            void $this$distinctBy$iv;
            Collection<SharedIndexContentHash> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void provider;
            void totalNumberOfFilesForIndexing2;
            Iterator $this$mapTo$iv$iv2;
            void destination$iv;
            Object list$iv;
            void $this$flatMapTo$iv;
            boolean bl = false;
            indicator.setText(SharedIndexesBundle.message("progress.text.hashing.files", new Object[0]));
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            Iterable iterable = providerToFiles.values();
            Collection collection2 = new HashSet();
            Object object = this.parameters;
            Object object2 = this.project;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                Set it = (Set)element$iv;
                boolean bl2 = false;
                list$iv = it;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> map2 = destination$iv;
            List<SharedIndexContentHashProvider> providers = IndexesExporterHasherKt.resolveGeneratorsForExporter((Project)object2, (IndexedFilesHashingTaskParameters)object, (Set)((Object)map2), indicator);
            IndexesExporterHasher hasher = new IndexesExporterHasher(providers, this.errorsCollector);
            ConcurrentHashMap fileToHash = new ConcurrentHashMap();
            Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> $this$map$iv2 = providerToFiles;
            boolean $i$f$map232 = false;
            list$iv = $this$map$iv2;
            Object destination$iv$iv = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo = false;
            Map.Entry entry = $this$mapTo$iv$iv2;
            boolean bl3 = false;
            Iterator iterator = entry.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry entry2;
                Map.Entry entry3 = entry2 = iterator.next();
                object2 = destination$iv$iv;
                boolean bl4 = false;
                object = ((Set)it.getValue()).size();
                object2.add(object);
            }
            int totalNumberOfFilesForIndexing22 = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            if (totalNumberOfFilesForIndexing22 <= 0) {
                HashedIndexedFiles hashedIndexedFiles = IndexedFilesHashingTaskKt.getEmptyHashedIndexedFiles();
                return hashedIndexedFiles;
            }
            ConcurrentTasksProgressManager tasksProgressManager = new ConcurrentTasksProgressManager(indicator, (int)totalNumberOfFilesForIndexing2);
            destination$iv$iv = providerToFiles;
            $i$f$mapTo = false;
            $this$mapTo$iv$iv2 = destination$iv$iv.entrySet().iterator();
            while ($this$mapTo$iv$iv2.hasNext()) {
                SubTaskProgressIndicator subTaskIndicator;
                entry = $i$f$map232 = $this$mapTo$iv$iv2.next();
                bl3 = false;
                destination$iv$iv = (IndexableFilesIterator)entry.getKey();
                entry = $i$f$map232;
                bl3 = false;
                Set providerFiles = (Set)entry.getValue();
                if (providerFiles.isEmpty()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)tasksProgressManager.createSubTaskIndicator(providerFiles.size()), (String)"tasksProgressManager.cre\u2026cator(providerFiles.size)");
                subTaskIndicator.setText(provider.getRootsScanningProgressText());
                UtilKt.parallelFor((Collection)providerFiles, null, (ProgressIndicator)subTaskIndicator, null, (BiConsumer)new BiConsumer<VirtualFile, Throwable>(this, indicator, providerToFiles){
                    final /* synthetic */ IndexedFilesHashingTask this$0;
                    final /* synthetic */ ProgressIndicator $indicator$inlined;
                    final /* synthetic */ Map $providerToFiles$inlined;
                    {
                        this.this$0 = indexedFilesHashingTask;
                        this.$indicator$inlined = progressIndicator;
                        this.$providerToFiles$inlined = map2;
                    }

                    public final void accept(@NotNull VirtualFile file2, @NotNull Throwable e) {
                        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (!(e instanceof Exception)) {
                            throw e;
                        }
                        IndexedFilesHashingTask.access$getErrorsCollector$p(this.this$0).fileGenericError(file2, e);
                    }
                }, new Consumer<VirtualFile>(hasher, fileToHash, this, indicator, providerToFiles){
                    final /* synthetic */ IndexesExporterHasher $hasher;
                    final /* synthetic */ ConcurrentHashMap $fileToHash;
                    final /* synthetic */ IndexedFilesHashingTask this$0;
                    final /* synthetic */ ProgressIndicator $indicator$inlined;
                    final /* synthetic */ Map $providerToFiles$inlined;
                    {
                        this.$hasher = indexesExporterHasher;
                        this.$fileToHash = concurrentHashMap;
                        this.this$0 = indexedFilesHashingTask;
                        this.$indicator$inlined = progressIndicator;
                        this.$providerToFiles$inlined = map2;
                    }

                    public final void accept(@NotNull VirtualFile file2) {
                        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                        FileContentImpl fileContentImpl = IndexedFilesHashingTask.access$getFileContentLoader$p(this.this$0).createFileContent(file2);
                        if (fileContentImpl == null) {
                            return;
                        }
                        FileContentImpl fileContent = fileContentImpl;
                        IndexedFileHash indexedFileHash = this.$hasher.computeHash(fileContent);
                        if (indexedFileHash == null) {
                            return;
                        }
                        IndexedFileHash hash = indexedFileHash;
                        ((Map)this.$fileToHash).put(file2, hash);
                    }
                });
                subTaskIndicator.finished();
            }
            $i$f$map232 = false;
            Iterable $i$f$map232 = providers;
            List list = CollectionsKt.emptyList();
            Map map3 = fileToHash;
            map2 = providerToFiles;
            boolean $i$f$map = false;
            provider = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SharedIndexContentHashProvider sharedIndexContentHashProvider = (SharedIndexContentHashProvider)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl5 = false;
                SharedIndexContentHash sharedIndexContentHash = sharedIndexContentHashProvider.getInfo();
                collection.add(sharedIndexContentHash);
            }
            collection = (List)destination$iv$iv2;
            $this$map$iv = collection;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv2 = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                SharedIndexContentHash it = (SharedIndexContentHash)e$iv;
                boolean bl2 = false;
                String key$iv = it.getProviderId();
                if (!set$iv.add(key$iv)) continue;
                list$iv2.add(e$iv);
            }
            Collection<SharedIndexContentHash> collection3 = collection = (List)list$iv2;
            List list2 = list;
            Map map4 = map3;
            Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> map5 = map2;
            HashedIndexedFiles hashedIndexedFiles = new HashedIndexedFiles(map5, map4, list2, (List<? extends SharedIndexContentHash>)collection3);
            return hashedIndexedFiles;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    public IndexedFilesHashingTask(@NotNull Project project2, @NotNull IndexedFilesHashingTaskParameters parameters, @NotNull IndexedFileContentLoader fileContentLoader, @NotNull ErrorsCollector errorsCollector) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)fileContentLoader, (String)"fileContentLoader");
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        this.project = project2;
        this.parameters = parameters;
        this.fileContentLoader = fileContentLoader;
        this.errorsCollector = errorsCollector;
    }

    public static final /* synthetic */ ErrorsCollector access$getErrorsCollector$p(IndexedFilesHashingTask $this) {
        return $this.errorsCollector;
    }

    public static final /* synthetic */ IndexedFileContentLoader access$getFileContentLoader$p(IndexedFilesHashingTask $this) {
        return $this.fileContentLoader;
    }
}

