/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.intellij.indexing.shared.platform.api.IdeIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HashBasedIndexGenerator<K, V> {
    private static final Logger LOG = Logger.getInstance(HashBasedIndexGenerator.class);
    @NotNull
    private final SharedIndexExtension<K, V> mySharedExtension;
    @NotNull
    private final FileBasedIndex.InputFilter myInputFilter;
    @NotNull
    private final Path myStorageFile;
    private final AtomicInteger myIndexedFilesNumber;
    private final AtomicBoolean myIsEmpty;
    private final AtomicBoolean myCollisionReported;
    private InvertedIndex<K, V, FileContent> myIndex;
    @NotNull
    private final ID<K, V> myIndexId;

    public HashBasedIndexGenerator(@NotNull FileBasedIndexExtension<K, V> originalExtension, @NotNull Path chunkRoot) {
        if (originalExtension == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(0);
        }
        if (chunkRoot == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(1);
        }
        this.myIndexedFilesNumber = new AtomicInteger();
        this.myIsEmpty = new AtomicBoolean(true);
        this.myCollisionReported = new AtomicBoolean();
        this.myIndexId = originalExtension.getName();
        Path indexPath = SharedIndexExtension.getSharedIndexDir(chunkRoot, this.myIndexId);
        this.myStorageFile = indexPath.resolve(this.myIndexId.getName());
        IndexInfrastructureVersion ideVersion = IdeIndexInfrastructureVersion.getIdeVersion().getVersion();
        this.mySharedExtension = SharedIndexExtension.findExtensionAndOpen(originalExtension, indexPath, false, ideVersion);
        FileBasedIndex.InputFilter filter = originalExtension.getInputFilter();
        if (filter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
            HashSet fileTypes = new HashSet();
            ((FileBasedIndex.FileTypeSpecificInputFilter)filter).registerFileTypesUsedForIndexing(fileTypes::add);
            this.myInputFilter = file2 -> fileTypes.contains(file2.getFileType()) && filter.acceptInput(file2);
        } else {
            this.myInputFilter = filter;
        }
    }

    public void openIndex() throws IOException {
        FileBasedIndexExtension<K, V> extension2 = this.mySharedExtension.getFileBasedIndexExtension();
        MapIndexStorage indexStorage = new MapIndexStorage<K, V>(this.myStorageFile, extension2.getKeyDescriptor(), extension2.getValueExternalizer(), extension2.getCacheSize(), extension2.keyIsUniqueForIndexedFile()){

            protected void checkCanceled() {
            }

            public void addValue(K k, int inputId, V v) throws StorageException {
                super.addValue(k, inputId, v);
                HashBasedIndexGenerator.this.myIsEmpty.set(false);
            }

            public void removeAllValues(@NotNull K k, int inputId) {
                if (k == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashBasedIndexGenerator.this.reportHashCollision(inputId);
            }

            public void close() throws StorageException {
                try {
                    PersistentHashMap storageMap = (PersistentHashMap)this.myMap;
                    if (storageMap.isCompactionSupported()) {
                        storageMap.compact();
                    }
                }
                catch (IOException e) {
                    throw new StorageException((Throwable)e);
                }
                finally {
                    super.close();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$1", "removeAllValues"));
            }
        };
        final boolean isSingleEntryIndex = extension2 instanceof SingleEntryFileBasedIndexExtension;
        PersistentMapBasedForwardIndex forwardIndex = HashBasedIndexGenerator.createForwardIndex(this.myStorageFile, false);
        MapForwardIndexAccessor<K, V> forwardIndexAccessor = HashBasedIndexGenerator.createForwardIndexAccessor(this.mySharedExtension, this::reportHashCollision);
        this.myIndex = new MapReduceIndex<K, V, FileContent>((IndexExtension)extension2, (IndexStorage)indexStorage, (ForwardIndex)forwardIndex, (ForwardIndexAccessor)forwardIndexAccessor){

            @NotNull
            protected Map<K, V> mapByIndexer(int inputId, @NotNull FileContent content) {
                if (content == null) {
                    2.$$$reportNull$$$0(0);
                }
                Map data = super.mapByIndexer(inputId, (Object)content);
                if (isSingleEntryIndex && !data.isEmpty()) {
                    data = Collections.singletonMap(inputId, data.values().iterator().next());
                }
                Map map2 = HashBasedIndexGenerator.this.transformIndexedData(data, content);
                if (map2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return map2;
            }

            protected void updateForwardIndex(int inputId, @NotNull InputData<K, V> data) throws IOException {
                if (data == null) {
                    2.$$$reportNull$$$0(2);
                }
                super.updateForwardIndex(inputId, data);
                try {
                    HashBasedIndexGenerator.this.visitInputData(inputId, data);
                }
                catch (StorageException e) {
                    throw new IOException(e);
                }
            }

            public void updateWithMap(@NotNull AbstractUpdateData<K, V> updateData) throws StorageException {
                if (updateData == null) {
                    2.$$$reportNull$$$0(3);
                }
                super.updateWithMap(updateData);
                HashBasedIndexGenerator.this.myIndexedFilesNumber.incrementAndGet();
            }

            public void checkCanceled() {
            }

            protected void requestRebuild(@NotNull Throwable e) {
                if (e == null) {
                    2.$$$reportNull$$$0(4);
                }
                throw new RuntimeException("Error while processing " + this.myExtension.getName().getName(), e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "content";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "data";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updateData";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "mapByIndexer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "mapByIndexer";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "updateForwardIndex";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "updateWithMap";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "requestRebuild";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private void reportHashCollision(int hashId) {
        if (this.myCollisionReported.compareAndSet(false, true)) {
            LOG.error("Index \"" + this.mySharedExtension.getFileBasedIndexExtension().getName() + "\" contains data collision for hashId = " + hashId, (Throwable)null);
        }
    }

    @NotNull
    public static <K, V> MapForwardIndexAccessor<K, V> createForwardIndexAccessor(@NotNull SharedIndexExtension<K, V> extension2, final @NotNull IntConsumer collisionReporter) {
        if (extension2 == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(2);
        }
        if (collisionReporter == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(3);
        }
        return new MapForwardIndexAccessor<K, V>((DataExternalizer)new InputMapExternalizer(extension2.getFileBasedIndexExtension())){

            @NotNull
            public InputDataDiffBuilder<K, V> createDiffBuilderByMap(int inputId, @Nullable Map<K, V> map2) {
                return new MapInputDataDiffBuilder<K, V>(inputId, map2){

                    public boolean differentiate(@NotNull Map<K, V> newData, @NotNull KeyValueUpdateProcessor<? super K, ? super V> addProcessor, @NotNull KeyValueUpdateProcessor<? super K, ? super V> updateProcessor, @NotNull RemovedKeyProcessor<? super K> removeProcessor) throws StorageException {
                        if (newData == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (addProcessor == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (updateProcessor == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (removeProcessor == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return super.differentiate(newData, addProcessor, (k, v, inputId) -> {
                            collisionReporter.accept(this.myInputId);
                            updateProcessor.process(k, v, inputId);
                        }, (k, inputId1) -> {
                            collisionReporter.accept(this.myInputId);
                            removeProcessor.process(k, inputId1);
                        });
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "newData";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "addProcessor";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "updateProcessor";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[0] = "removeProcessor";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator$3$1";
                        objectArray[2] = "differentiate";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
        };
    }

    @NotNull
    public static PersistentMapBasedForwardIndex createForwardIndex(@NotNull Path storageFile, boolean readOnly) throws IOException {
        if (storageFile == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(4);
        }
        return new PersistentMapBasedForwardIndex(HashBasedIndexGenerator.getForwardIndexPath(storageFile), readOnly);
    }

    public static boolean shouldCreateForwardIndex(@NotNull SharedIndexExtension<?, ?> sharedExtension) {
        FileBasedIndexExtension<?, ?> extension2;
        if (sharedExtension == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(5);
        }
        boolean needsForwardIndex = (extension2 = sharedExtension.getFileBasedIndexExtension()).needsForwardIndexWhenSharing() || "true".equalsIgnoreCase(System.getProperty("shared.indexes.always.use.forward.index"));
        return needsForwardIndex && !(extension2 instanceof SingleEntryFileBasedIndexExtension);
    }

    @NotNull
    private static Path getForwardIndexPath(@NotNull Path storageFile) {
        if (storageFile == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(6);
        }
        Path path = storageFile.resolveSibling(storageFile.getFileName() + ".forward");
        if (path == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(7);
        }
        return path;
    }

    protected void visitInputData(int hashId, @NotNull InputData<K, V> data) throws StorageException {
        if (data == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    protected Map<K, V> transformIndexedData(@NotNull Map<K, V> data, @NotNull FileContent content) {
        if (data == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(9);
        }
        if (content == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(10);
        }
        Map<K, V> map2 = data;
        if (map2 == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(11);
        }
        return map2;
    }

    public void closeIndex() throws IOException {
        if (this.myIndex != null) {
            this.myIndex.dispose();
        }
        this.mySharedExtension.closeResources();
        if (!HashBasedIndexGenerator.shouldCreateForwardIndex(this.mySharedExtension)) {
            IOUtil.deleteAllFilesStartingWith((Path)HashBasedIndexGenerator.getForwardIndexPath(this.myStorageFile));
        }
    }

    public void indexFile(int hashId, @NotNull FileContent fileContent) {
        if (fileContent == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(12);
        }
        if (!this.myInputFilter.acceptInput(fileContent.getFile())) {
            return;
        }
        if (!((Boolean)this.myIndex.mapInputAndPrepareUpdate(hashId, (Object)fileContent).compute()).booleanValue()) {
            throw new RuntimeException("Index computation returned false for hashId = " + hashId + ", file = " + fileContent.getFile().getPath() + ", index = " + this.getIndexName());
        }
    }

    @NotNull
    public Path getIndexRoot() {
        Path path = this.myStorageFile.getParent();
        if (path == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(13);
        }
        return path;
    }

    public int getIndexedFilesNumber() {
        return this.myIndexedFilesNumber.get();
    }

    public boolean isEmpty() {
        return this.myIsEmpty.get();
    }

    @NotNull
    public String getIndexName() {
        String string2 = this.myIndexId.getName();
        if (string2 == null) {
            HashBasedIndexGenerator.$$$reportNull$$$0(14);
        }
        return string2;
    }

    public InvertedIndex<K, V, FileContent> getIndex() {
        return this.myIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalExtension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collisionReporter";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedExtension";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/generate/HashBasedIndexGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getForwardIndexPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "transformIndexedData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createForwardIndexAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createForwardIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateForwardIndex";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getForwardIndexPath";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitInputData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "transformIndexedData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "indexFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

