/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.dump.files;

import com.intellij.indexing.shared.dump.files.FileTable;
import com.intellij.indexing.shared.dump.files.FileTable$getChunkId$;
import com.intellij.indexing.shared.platform.impl.MergedInvertedIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.UpdatableIndex;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/indexing/shared/dump/files/FileTable;", "", "()V", "doesFileBelongToSharedIndex", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChunkId", "", "getDebugNameOfSharedIndexChunk", "", "intellij.indexing.shared"})
public final class FileTable {
    public static final FileTable INSTANCE;

    public final boolean doesFileBelongToSharedIndex(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        int associatedChunkId = this.getChunkId(virtualFile);
        return -1 != associatedChunkId;
    }

    @Nullable
    public final String getDebugNameOfSharedIndexChunk(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        int chunkId = this.getChunkId(virtualFile);
        if (chunkId == -1) {
            return null;
        }
        return SharedIndexChunkConfiguration.getInstance().getChunkDebugName(chunkId);
    }

    private final int getChunkId(VirtualFile virtualFile) {
        int fileId = FileBasedIndex.getFileId((VirtualFile)virtualFile);
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        }
        FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
        ExtensionPointName extensionPointName = FileBasedIndexExtension.EXTENSION_POINT_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"FileBasedIndexExtension\n\u2026    .EXTENSION_POINT_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"FileBasedIndexExtension\n\u2026           .extensionList");
        Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getChunkId.1.INSTANCE), (Function1)new Function1<FileBasedIndexExtension<?, ?>, UpdatableIndex<? extends Object, ? extends Object, FileContent>>(fileBasedIndex2){
            final /* synthetic */ FileBasedIndexImpl $fileBasedIndex;

            public final UpdatableIndex<? extends Object, ? extends Object, FileContent> invoke(FileBasedIndexExtension<?, ?> it) {
                FileBasedIndexExtension<?, ?> fileBasedIndexExtension = it;
                Intrinsics.checkNotNullExpressionValue(fileBasedIndexExtension, (String)"it");
                return this.$fileBasedIndex.getIndex(fileBasedIndexExtension.getName());
            }
            {
                this.$fileBasedIndex = fileBasedIndexImpl;
                super(1);
            }
        });
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getChunkId$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Integer n = (Integer)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)sequence, (Function1)new Function1<MergedInvertedIndex<?, ?>, Integer>(fileId, virtualFile){
            final /* synthetic */ int $fileId;
            final /* synthetic */ VirtualFile $virtualFile;

            public final int invoke(@NotNull MergedInvertedIndex<?, ?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.getHashIndex().getAssociatedChunkId(this.$fileId, this.$virtualFile);
            }
            {
                this.$fileId = n;
                this.$virtualFile = virtualFile;
                super(1);
            }
        }), (Function1)getChunkId.4.INSTANCE));
        return n != null ? n : -1;
    }

    private FileTable() {
    }

    static {
        FileTable fileTable;
        INSTANCE = fileTable = new FileTable();
    }
}

