/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.download.SharedIndexAuthException;
import com.intellij.indexing.shared.download.SharedIndexBaseId;
import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.download.SharedIndexDownloadJson;
import com.intellij.indexing.shared.download.SharedIndexListLookup;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.download.SharedIndexNetworkCache;
import com.intellij.indexing.shared.download.SharedIndexNetworkCacheScope;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.IdeIndexInfrastructureVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorForCollections;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0007\u0018\u00002\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002JX\u0010\u0019\u001a\u0004\u0018\u0001H\u001b\"\b\b\u0000\u0010\u001b*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132/\u0010\u001c\u001a+\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0\u001d\u00a2\u0006\u0002\u0010!R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006#"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cache", "com/intellij/indexing/shared/download/SharedIndexLookup$cache$1", "Lcom/intellij/indexing/shared/download/SharedIndexLookup$cache$1;", "cacheSize", "", "downloadIndexList", "", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indexUrl", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "invalidateCaches", "", "lookupSharedIndex", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/IdeIndexInfrastructureVersion;", "lookupSharedIndexWithoutCache", "ourVersion", "T", "matchItem", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "url", "(Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "CacheEntry", "intellij.indexing.shared"})
public final class SharedIndexLookup {
    private final Logger LOG;
    private final cache.1 cache;

    @Nullable
    public final SharedIndexLookupResult lookupSharedIndex(@NotNull SharedIndexLookupRequest request, @NotNull IdeIndexInfrastructureVersion ideVersion, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        CacheEntry cacheEntry = (CacheEntry)this.cache.lookupOrCompute(request, indicator, (Function1)new Function1<CacheEntry, Boolean>(ideVersion){
            final /* synthetic */ IdeIndexInfrastructureVersion $ideVersion;

            public final boolean invoke(@NotNull CacheEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getIdeVersion(), (Object)this.$ideVersion);
            }
            {
                this.$ideVersion = ideIndexInfrastructureVersion;
                super(1);
            }
        }, (Function1)new Function1<SharedIndexNetworkCacheScope, CacheEntry>(this, request, ideVersion, indicator){
            final /* synthetic */ SharedIndexLookup this$0;
            final /* synthetic */ SharedIndexLookupRequest $request;
            final /* synthetic */ IdeIndexInfrastructureVersion $ideVersion;
            final /* synthetic */ ProgressIndicator $indicator;

            @Nullable
            public final CacheEntry invoke(@NotNull SharedIndexNetworkCacheScope $this$lookupOrCompute) {
                SharedIndexLookupResult sharedIndexLookupResult;
                Intrinsics.checkNotNullParameter((Object)$this$lookupOrCompute, (String)"$receiver");
                try {
                    sharedIndexLookupResult = SharedIndexLookup.access$lookupSharedIndexWithoutCache(this.this$0, this.$request, this.$ideVersion, this.$indicator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    if (t instanceof SharedIndexAuthException) {
                        throw t;
                    }
                    this.$indicator.checkCanceled();
                    SharedIndexLookup.access$getLOG$p(this.this$0).warn("Failed to lookup shared index for " + this.$request + ". " + t.getMessage(), t);
                    sharedIndexLookupResult = null;
                }
                SharedIndexLookupResult result2 = sharedIndexLookupResult;
                return new CacheEntry(this.$ideVersion, $this$lookupOrCompute.getNow(), result2);
            }
            {
                this.this$0 = sharedIndexLookup;
                this.$request = sharedIndexLookupRequest;
                this.$ideVersion = ideIndexInfrastructureVersion;
                this.$indicator = progressIndicator;
                super(1);
            }
        });
        return cacheEntry != null ? cacheEntry.getValue() : null;
    }

    private final SharedIndexLookupResult lookupSharedIndexWithoutCache(SharedIndexLookupRequest request, IdeIndexInfrastructureVersion ourVersion, ProgressIndicator indicator) {
        return (SharedIndexLookupResult)this.lookupSharedIndexWithoutCache(request, indicator, (Function2)new Function2<String, List<? extends SharedIndexLookupResult>, SharedIndexLookupResult>(ourVersion){
            final /* synthetic */ IdeIndexInfrastructureVersion $ourVersion;

            @Nullable
            public final SharedIndexLookupResult invoke(@NotNull String $noName_0, @NotNull List<SharedIndexLookupResult> results) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(results, (String)"results");
                return SharedIndexMetadata.Companion.selectBestSuitableIndex(this.$ourVersion, results);
            }
            {
                this.$ourVersion = ideIndexInfrastructureVersion;
                super(2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final <T> T lookupSharedIndexWithoutCache(@NotNull SharedIndexLookupRequest request, @NotNull ProgressIndicator indicator, @NotNull Function2<? super String, ? super List<SharedIndexLookupResult>, ? extends T> matchItem) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(matchItem, (String)"matchItem");
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(SharedIndexListLookup.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        List<String> urlsToProcess = ((SharedIndexListLookup)object).collectUrlsToProcess(request, indicator);
        Collection $this$forEachWithProgress$iv = urlsToProcess;
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv.pushState();
        try {
            boolean bl = false;
            indicator.setIndeterminate(false);
            indicator.checkCanceled();
            double size$iv = $this$forEachWithProgress$iv.size();
            boolean bl2 = false;
            for (Object y$iv : (Iterable)$this$forEachWithProgress$iv) {
                void subIndicator;
                void i$iv;
                indicator.checkCanceled();
                double lowerBound$iv = (double)i$iv / size$iv;
                double upperBound$iv = (double)(i$iv + true) / size$iv;
                indicator.setFraction(lowerBound$iv);
                String prevText$iv = indicator.getText();
                String prevText2$iv = indicator.getText2();
                ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv, (double)upperBound$iv);
                String url2 = (String)y$iv;
                boolean bl3 = false;
                subIndicator.setText2(url2);
                List<SharedIndexLookupResult> results = this.downloadIndexList(request, StringsKt.trim((String)url2, (char[])new char[]{'/'}) + "/index.json.xz", (ProgressIndicator)subIndicator);
                subIndicator.checkCanceled();
                Object object2 = matchItem.invoke((Object)url2, results);
                if (object2 != null) {
                    Object object3 = object2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object best = object3;
                    boolean bl6 = false;
                    this.LOG.info("Selected pre-built shared index " + best + " from " + url2 + " for " + request);
                    Object object4 = best;
                    return (T)object4;
                }
                indicator.setText(prevText$iv);
                indicator.setText2(prevText2$iv);
                ++i$iv;
            }
            indicator.setFraction(1.0);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
            $this$withPushPop$iv$iv.popState();
        }
        this.LOG.debug("No matching shared indexes are found for " + request + ". The following URLs were tried: " + CollectionsKt.joinToString$default((Iterable)urlsToProcess, null, null, null, (int)0, null, null, (int)63, null));
        return null;
    }

    public final void invalidateCaches() {
        boolean $i$f$serviceIfCreated = false;
        SharedIndexListLookup sharedIndexListLookup = (SharedIndexListLookup)ApplicationManager.getApplication().getServiceIfCreated(SharedIndexListLookup.class);
        if (sharedIndexListLookup != null) {
            sharedIndexListLookup.invalidateCaches();
        }
        this.cache.invalidateCaches();
    }

    @VisibleForTesting
    public final int cacheSize() {
        return this.cache.cacheSize();
    }

    @VisibleForTesting
    @NotNull
    public final List<SharedIndexLookupResult> downloadIndexList(@NotNull SharedIndexLookupRequest request, @NotNull String indexUrl, @NotNull ProgressIndicator indicator) {
        String listVersion;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indexUrl, (String)"indexUrl");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(SharedIndexDownloadJson.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        ObjectNode objectNode = ((SharedIndexDownloadJson)object).downloadJsonXz(request, indexUrl, indicator);
        if (objectNode == null) {
            $i$f$service = false;
            return CollectionsKt.emptyList();
        }
        ObjectNode json = objectNode;
        JsonNode jsonNode = json.get("list_version");
        String string2 = listVersion = jsonNode != null ? jsonNode.asText() : null;
        if (Intrinsics.areEqual((Object)listVersion, (Object)"1") ^ true) {
            this.LOG.trace("Index data version mismatch. The current version is " + listVersion + " in " + indexUrl + " for " + request);
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        JsonNode jsonNode2 = json.get("entries");
        if (!(jsonNode2 instanceof ArrayNode)) {
            jsonNode2 = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode2;
        if (arrayNode == null) {
            SharedIndexLookup sharedIndexLookup = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedIndexLookup $this$run = sharedIndexLookup;
            boolean bl3 = false;
            $this$run.LOG.trace("Index data format is incomplete. Missing 'entries' element in " + indexUrl + " for " + request);
            boolean bl4 = false;
            return CollectionsKt.emptyList();
        }
        ArrayNode entries = arrayNode;
        Iterator iterator = entries.elements();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"entries.elements()");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<JsonNode, SharedIndexLookupResult>(request){
            final /* synthetic */ SharedIndexLookupRequest $request;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final SharedIndexLookupResult invoke(JsonNode node) {
                Object object;
                ObjectNode indexVersionJson;
                long size;
                Object sha;
                Object url2;
                block17: {
                    block16: {
                        void $this$mapNotNullTo$iv$iv;
                        if (!(node instanceof ObjectNode)) {
                            return null;
                        }
                        Object object2 = node.get("url");
                        if (object2 == null || (object2 = object2.asText()) == null) {
                            return null;
                        }
                        url2 = object2;
                        Object object3 = node.get("sha256");
                        if (object3 == null || (object3 = object3.asText()) == null) {
                            return null;
                        }
                        sha = object3;
                        JsonNode jsonNode = node.get("size");
                        if (jsonNode == null) {
                            return null;
                        }
                        size = jsonNode.asLong();
                        JsonNode jsonNode2 = node.get("metadata");
                        if (!(jsonNode2 instanceof ObjectNode)) {
                            jsonNode2 = null;
                        }
                        ObjectNode objectNode = (ObjectNode)jsonNode2;
                        if (objectNode == null) {
                            return null;
                        }
                        indexVersionJson = objectNode;
                        JsonNode jsonNode3 = indexVersionJson.get("bases");
                        if (!(jsonNode3 instanceof ArrayNode)) {
                            jsonNode3 = null;
                        }
                        if ((object = (ArrayNode)jsonNode3) == null) break block16;
                        Iterable $this$mapNotNull$iv = (Iterable)object;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            SharedIndexBaseId sharedIndexBaseId;
                            Object object4;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            JsonNode it = (JsonNode)element$iv$iv;
                            boolean bl2 = false;
                            JsonNode jsonNode4 = it;
                            if (!(jsonNode4 instanceof ObjectNode)) {
                                jsonNode4 = null;
                            }
                            if ((object4 = (ObjectNode)jsonNode4) != null && (object4 = object4.get("sha256")) != null && (object4 = object4.asText()) != null) {
                                Object object5 = object4;
                                boolean bl3 = false;
                                boolean bl4 = false;
                                Object p1 = object5;
                                boolean bl5 = false;
                                sharedIndexBaseId = new SharedIndexBaseId((String)p1);
                            } else {
                                sharedIndexBaseId = null;
                            }
                            if (sharedIndexBaseId == null) continue;
                            SharedIndexBaseId sharedIndexBaseId2 = sharedIndexBaseId;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            SharedIndexBaseId it$iv$iv = sharedIndexBaseId2;
                            boolean bl8 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        object = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                        if (object != null) break block17;
                    }
                    boolean $this$mapNotNull$iv = false;
                    object = CollectionsKt.emptyList();
                }
                Object bases = object;
                JsonNode jsonNode = node.get("format");
                SharedIndexCompression sharedIndexCompression = SharedIndexCompression.Companion.findByType(jsonNode != null ? jsonNode.asText() : null);
                if (sharedIndexCompression == null) {
                    return null;
                }
                SharedIndexCompression compression2 = sharedIndexCompression;
                SharedIndexMetadata sharedIndexMetadata = SharedIndexMetadata.Companion.tryReadIndexesVersion(indexVersionJson);
                if (sharedIndexMetadata == null) {
                    return null;
                }
                SharedIndexMetadata indexVersion2 = sharedIndexMetadata;
                return new SharedIndexLookupResult(this.$request, (String)url2, (String)sha, size, compression2, indexVersion2, (List<SharedIndexBaseId>)bases);
            }
            {
                this.$request = sharedIndexLookupRequest;
                super(1);
            }
        })));
    }

    public SharedIndexLookup() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexLookup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
        this.cache = new SharedIndexNetworkCache<SharedIndexLookupRequest, CacheEntry>(){

            @NotNull
            protected Instant getCreated(@NotNull CacheEntry $this$created) {
                Intrinsics.checkNotNullParameter((Object)$this$created, (String)"$this$created");
                return $this$created.getComputed();
            }
        };
    }

    public static final /* synthetic */ SharedIndexLookupResult access$lookupSharedIndexWithoutCache(SharedIndexLookup $this, SharedIndexLookupRequest request, IdeIndexInfrastructureVersion ourVersion, ProgressIndicator indicator) {
        return $this.lookupSharedIndexWithoutCache(request, ourVersion, indicator);
    }

    public static final /* synthetic */ Logger access$getLOG$p(SharedIndexLookup $this) {
        return $this.LOG;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup$CacheEntry;", "", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/IdeIndexInfrastructureVersion;", "computed", "Ljava/time/Instant;", "value", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "(Lcom/intellij/indexing/shared/platform/api/IdeIndexInfrastructureVersion;Ljava/time/Instant;Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;)V", "getComputed", "()Ljava/time/Instant;", "getIdeVersion", "()Lcom/intellij/indexing/shared/platform/api/IdeIndexInfrastructureVersion;", "getValue", "()Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared"})
    private static final class CacheEntry {
        @NotNull
        private final IdeIndexInfrastructureVersion ideVersion;
        @NotNull
        private final Instant computed;
        @Nullable
        private final SharedIndexLookupResult value;

        @NotNull
        public final IdeIndexInfrastructureVersion getIdeVersion() {
            return this.ideVersion;
        }

        @NotNull
        public final Instant getComputed() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexLookupResult getValue() {
            return this.value;
        }

        public CacheEntry(@NotNull IdeIndexInfrastructureVersion ideVersion, @NotNull Instant computed, @Nullable SharedIndexLookupResult value) {
            Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            this.ideVersion = ideVersion;
            this.computed = computed;
            this.value = value;
        }

        @NotNull
        public final IdeIndexInfrastructureVersion component1() {
            return this.ideVersion;
        }

        @NotNull
        public final Instant component2() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexLookupResult component3() {
            return this.value;
        }

        @NotNull
        public final CacheEntry copy(@NotNull IdeIndexInfrastructureVersion ideVersion, @NotNull Instant computed, @Nullable SharedIndexLookupResult value) {
            Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            return new CacheEntry(ideVersion, computed, value);
        }

        public static /* synthetic */ CacheEntry copy$default(CacheEntry cacheEntry, IdeIndexInfrastructureVersion ideIndexInfrastructureVersion, Instant instant, SharedIndexLookupResult sharedIndexLookupResult, int n, Object object) {
            if ((n & 1) != 0) {
                ideIndexInfrastructureVersion = cacheEntry.ideVersion;
            }
            if ((n & 2) != 0) {
                instant = cacheEntry.computed;
            }
            if ((n & 4) != 0) {
                sharedIndexLookupResult = cacheEntry.value;
            }
            return cacheEntry.copy(ideIndexInfrastructureVersion, instant, sharedIndexLookupResult);
        }

        @NotNull
        public String toString() {
            return "CacheEntry(ideVersion=" + this.ideVersion + ", computed=" + this.computed + ", value=" + this.value + ")";
        }

        public int hashCode() {
            IdeIndexInfrastructureVersion ideIndexInfrastructureVersion = this.ideVersion;
            Instant instant = this.computed;
            SharedIndexLookupResult sharedIndexLookupResult = this.value;
            return ((ideIndexInfrastructureVersion != null ? ((Object)ideIndexInfrastructureVersion).hashCode() : 0) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + (sharedIndexLookupResult != null ? ((Object)sharedIndexLookupResult).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CacheEntry)) break block3;
                    CacheEntry cacheEntry = (CacheEntry)object;
                    if (!Intrinsics.areEqual((Object)this.ideVersion, (Object)cacheEntry.ideVersion) || !Intrinsics.areEqual((Object)this.computed, (Object)cacheEntry.computed) || !Intrinsics.areEqual((Object)this.value, (Object)cacheEntry.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

