/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.EmptyChangelistBuilder;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.rollback.ThroughRenameInfo;

public class UnversionedAndNotTouchedFilesGroupCollector
extends EmptyChangelistBuilder {
    private final List<Couple<File>> myToBeDeleted;
    private final Map<File, ThroughRenameInfo> myFromTo = new HashMap<File, ThroughRenameInfo>();
    private TreeMap<String, File> myRenames;
    private Set<String> myAlsoReverted;

    UnversionedAndNotTouchedFilesGroupCollector() {
        this.myToBeDeleted = new ArrayList<Couple<File>>();
    }

    public void processUnversionedFile(@NotNull FilePath file) {
        if (file == null) {
            UnversionedAndNotTouchedFilesGroupCollector.$$$reportNull$$$0(0);
        }
        this.toFromTo(file);
    }

    public void markRename(@NotNull File beforeFile, @NotNull File afterFile) {
        if (beforeFile == null) {
            UnversionedAndNotTouchedFilesGroupCollector.$$$reportNull$$$0(1);
        }
        if (afterFile == null) {
            UnversionedAndNotTouchedFilesGroupCollector.$$$reportNull$$$0(2);
        }
        this.myToBeDeleted.add((Couple<File>)Couple.of((Object)beforeFile, (Object)afterFile));
    }

    public ThroughRenameInfo findToFile(@NotNull FilePath file, @Nullable File firstTo) {
        String path;
        if (file == null) {
            UnversionedAndNotTouchedFilesGroupCollector.$$$reportNull$$$0(3);
        }
        if (this.myAlsoReverted.contains(path = FilePathsHelper.convertPath((FilePath)file))) {
            return null;
        }
        NavigableMap<String, File> head = this.myRenames.headMap(path, true);
        if (head == null || head.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : head.descendingMap().entrySet()) {
            if (path.equals(entry.getKey())) {
                return null;
            }
            if (!path.startsWith((String)entry.getKey())) continue;
            String convertedBase = FileUtil.toSystemIndependentName((String)((String)entry.getKey()));
            String convertedChild = FileUtil.toSystemIndependentName((String)file.getPath());
            String relativePath = FileUtil.getRelativePath((String)convertedBase, (String)convertedChild, (char)'/');
            assert (relativePath != null);
            return new ThroughRenameInfo((File)entry.getValue(), new File((File)entry.getValue(), relativePath), firstTo, file.getIOFile(), firstTo != null);
        }
        return null;
    }

    private void toFromTo(@NotNull FilePath path) {
        ThroughRenameInfo info2;
        if (path == null) {
            UnversionedAndNotTouchedFilesGroupCollector.$$$reportNull$$$0(4);
        }
        if ((info2 = this.findToFile(path, null)) != null) {
            this.myFromTo.put(path.getIOFile(), info2);
        }
    }

    private void processChangeImpl(Change change) {
        FilePath after;
        ThroughRenameInfo info2;
        if (change.getAfterRevision() != null && (info2 = this.findToFile(after = change.getAfterRevision().getFile(), change.getBeforeRevision() == null ? null : change.getBeforeRevision().getFile().getIOFile())) != null) {
            this.myFromTo.put(after.getIOFile(), info2);
        }
    }

    public void processChange(Change change, VcsKey vcsKey) {
        this.processChangeImpl(change);
    }

    public void processChangeInList(Change change, @Nullable ChangeList changeList, VcsKey vcsKey) {
        this.processChangeImpl(change);
    }

    public void processChangeInList(Change change, String changeListName, VcsKey vcsKey) {
        this.processChangeImpl(change);
    }

    public void processIgnoredFile(@NotNull FilePath file) {
        if (file == null) {
            UnversionedAndNotTouchedFilesGroupCollector.$$$reportNull$$$0(5);
        }
        this.toFromTo(file);
    }

    public List<Couple<File>> getToBeDeleted() {
        return this.myToBeDeleted;
    }

    public Map<File, ThroughRenameInfo> getFromTo() {
        return this.myFromTo;
    }

    public void setRenamesMap(TreeMap<String, File> renames) {
        this.myRenames = renames;
    }

    public void setAlsoReverted(Set<String> alsoReverted) {
        this.myAlsoReverted = alsoReverted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/rollback/UnversionedAndNotTouchedFilesGroupCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processUnversionedFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "markRename";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findToFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "toFromTo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processIgnoredFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

